---
name: r.out.ascii
description: Converts a raster map layer into a GRASS ASCII text file.
keywords: [ raster, export, output, ASCII, Surfer, Modflow, Lisflood ]
---

# r.out.ascii

Converts a raster map layer into a GRASS ASCII text file.

=== "Command line"

    **r.out.ascii**
    [**-hsmli**]
    **input**=*name*
    [**output**=*name*]
    [**precision**=*integer*]
    [**width**=*integer*]
    [**null_value**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.ascii input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.ascii***",
        **input**,
        **output**=*None*,
        **precision**=*None*,
        **width**=*None*,
        **null_value**=*"\*"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.ascii", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_ascii*(**input**,
        **output**=*None*,
        **precision**=*None*,
        **width**=*None*,
        **null_value**=*"\*"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_ascii(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output ASCII grid map (use out=- for stdout)  
    **precision**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    **width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of values printed before wrapping a line (only SURFER or MODFLOW format)  
    **null_value**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;String to represent null cell (GRASS grid only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of header information  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Write SURFER (Golden Software) ASCII grid  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Write MODFLOW (USGS) ASCII array  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Write LISFLOOD (EU) ASCII array  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force output of integer values  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output ASCII grid map (use out=- for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of values printed before wrapping a line (only SURFER or MODFLOW format)  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String to represent null cell (GRASS grid only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *h*, *s*, *m*, *l*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of header information  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write SURFER (Golden Software) ASCII grid  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write MODFLOW (USGS) ASCII array  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write LISFLOOD (EU) ASCII array  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force output of integer values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output ASCII grid map (use out=- for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **precision** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of significant digits (floating point only)  
    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of values printed before wrapping a line (only SURFER or MODFLOW format)  
    **null_value** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;String to represent null cell (GRASS grid only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *\**  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *h*, *s*, *m*, *l*, *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of header information  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write SURFER (Golden Software) ASCII grid  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write MODFLOW (USGS) ASCII array  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Write LISFLOOD (EU) ASCII array  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force output of integer values  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.out.ascii* converts a user-specified raster map layer
(**input**=*name*) into an ASCII grid in a text file (**output**=*name*)
suitable for export to other computer systems.

The GRASS program *[r.in.ascii](r.in.ascii.md)* can be used to perform
the reverse function, converting an ASCII file in suitable format to
GRASS raster map format.

To write a SURFER .grd ASCII GRID file (with reverted row order and
different header) use the *-s* flag:

```sh
r.out.ascii -s input=inname output=outname.grd [dp=value]
```

NULL data are coded to \"1.70141e+038\" for SURFER ASCII GRID files
(ignoring the *null=* parameter).

To write a LISFLOOD .dem ASCII GRID file (with different header) use the
*-l* flag:

```sh
r.out.ascii -l input=inname output=outname.dem
```

NULL data output are set by the user at \"-9999\" in this case, see
below:

```text
ncols       1514
nrows       2747
xllcorner   212236
yllcorner   2910116
cellsize    120
NODATA_value    -9999
```

## NOTES

The output from *r.out.ascii* may be placed into a file by using the
UNIX redirection mechanism; e.g.:

```sh
r.out.ascii input=soils output=- > out.file
```

The output file out.file can then be printed or copied onto a CDROM or
floppy disk for export purposes.

To export the raster values as x,y,z values of cell centers (one per
line) use the *[r.out.xyz](r.out.xyz.md)* module.

## SEE ALSO

*[r.in.ascii](r.in.ascii.md), [r.in.gdal](r.in.gdal.md),
[r.out.bin](r.out.bin.md), [r.out.gdal](r.out.gdal.md),
[r.out.xyz](r.out.xyz.md)*

## AUTHORS

Michael Shapiro, U.S. Army Construction Engineering Research Laboratory

Surfer support by Markus Neteler

## SOURCE CODE

Available at: [r.out.ascii source code](https://github.com/OSGeo/grass/tree/main/raster/r.out.ascii)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.out.ascii))  
Latest change: Sunday Oct 05 01:26:10 2025 in commit [14fd3ee](https://github.com/OSGeo/grass/commit/14fd3ee61b78346fc901c0aa1d874c83c16cc51a)
