---
name: r.out.ppm
description: Converts a GRASS raster map to a PPM image file.
keywords: [ raster, export, output ]
---

# r.out.ppm

Converts a GRASS raster map to a PPM image file.

=== "Command line"

    **r.out.ppm**
    [**-gh**]
    **input**=*name*
    [**output**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.out.ppm input=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.out.ppm***",
        **input**,
        **output**=*"&lt;rasterfilename&gt;.ppm"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.out.ppm", input="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_out_ppm*(**input**,
        **output**=*"&lt;rasterfilename&gt;.ppm"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_out_ppm(input="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PPM file (use '-' for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *&lt;rasterfilename&gt;.ppm*  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output greyscale instead of color  
    **-h**  
    &nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of PPM header  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PPM file (use '-' for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *&lt;rasterfilename&gt;.ppm*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *h*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output greyscale instead of color  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of PPM header  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for new PPM file (use '-' for stdout)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *&lt;rasterfilename&gt;.ppm*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *h*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output greyscale instead of color  
    &nbsp;&nbsp;&nbsp;&nbsp;**h**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Suppress printing of PPM header  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.out.ppm* converts a GRASS raster map into a PPM image at the pixel
resolution of the CURRENTLY DEFINED REGION. To get the resolution and
region settings of the raster map, run:

```sh
g.region -p raster=[mapname]
```

before running *r.out.ppm*.

By default the PPM file created is 24-bit color, rawbits storage. You
can use the **-g** flag to force *r.out.ppm* to output an 8-bit
greyscale instead. The greyscale conversion uses the NTSC conversion:

```sh
Y = .30*Red + .59*Green + .11*Blue
```

One pixel is written for each cell value, so if `ew_res` and `ns_res`
differ, the aspect ratio of the resulting image will be off.

## NOTES

A few ppm file comments are written: the name of the GRASS raster map,
resolution, etc. Although these are perfectly legal, I've found one PD
image utility that chokes on them, so if you need a commentless PPM
file, use '`out=- > outfile.ppm`'. (When sending output to stdout, no
comments are written.)

## HINTS

You can create a PNG image with NULL values represented by a transparent
background by using the [PNG driver](pngdriver.md) with
[GRASS_RENDER_TRANSPARENT](variables.md) set to TRUE. Alternatively, you
can use the *pnmtopng* program from
[netpbm](https://netpbm.sourceforge.net) to do this:

```sh
r.out.ppm raster
pnmtopng -transparent white raster.ppm > raster.png
```

## SEE ALSO

*[d.out.file](d.out.file.md), [r.out.ascii](r.out.ascii.md),
[r.out.gdal](r.out.gdal.md), [r.out.mpeg](r.out.mpeg.md),
[r.out.png](r.out.png.md), [r.out.ppm3](r.out.ppm3.md)*

## AUTHOR

Bill Brown, UIUC

## SOURCE CODE

Available at: [r.out.ppm source code](https://github.com/OSGeo/grass/tree/main/raster/r.out.ppm)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.out.ppm))  
Latest change: Wednesday Jul 02 11:43:06 2025 in commit [78b88bc](https://github.com/OSGeo/grass/commit/78b88bc34582428809d4a98ae07e2500953f7333)
