---
name: r.pi.export
description: Export of patch based information.
keywords: [ raster, landscape structure analysis, patch index ]
---

# r.pi.export

Export of patch based information.

=== "Command line"

    **r.pi.export**
    [**-a**]
    **input**=*name*
    **output**=*string*
    [**values**=*string*]
    [**id_raster**=*string*]
    [**patch_raster**=*string*]
    **stats**=*string* [,*string*,...]
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.export input=name output=string stats=average
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.export***",
        **input**,
        **output**,
        **values**=*None*,
        **id_raster**=*None*,
        **patch_raster**=*None*,
        **stats**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.export", input="name", output="string", stats="average")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_export*(**input**,
        **output**,
        **values**=*None*,
        **id_raster**=*None*,
        **patch_raster**=*None*,
        **stats**,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_export(input="name", output="string", stats="average")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output ASCII-file  
    **values**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output ASCII-file with patch values  
    **id_raster**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the ID raster map  
    **patch_raster**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the patch raster map  
    **stats**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median, min, max*  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output ASCII-file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **values** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output ASCII-file with patch values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **id_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the ID raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **patch_raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the patch raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **stats** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median, min, max*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output ASCII-file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **values** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output ASCII-file with patch values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output  
    **id_raster** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the ID raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **patch_raster** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the patch raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **stats** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Statistical method to perform on the values  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, variance, standard deviation, median, min, max*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Set for 8 cell-neighbors. 4 cell-neighbors are default  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This module exports raster patch values (no single pixels, but single
individual patch values), which can be used for subsequent analysis in R
and later import into GRASS again, using [r.pi.import](r.pi.import.md).

## NOTES

This module...

## EXAMPLE

An example for the North Carolina sample dataset: generating a patch
index map for later export:

```sh
r.pi.index input=landclass96 output=landclass96_forestclass5_area keyval=5 method=area
```

export this resulting map:

```sh
r.pi.export input=landclass96_forestclass5_area output=patch_area_out values=patch_area_values id_raster=forestclass5_ID stats=average,variance,min
```

various resulting files are generated:  
*patch\_area\_out*: a text file with the *average*, *variance* and
*minimum* statistics as defined above and additionally informaton about
the percentage coverage (*landcover*) and the number of fragments
(*number*) of the analysed landcover.  
*patch\_area\_values*: a text file with the actual patch values not the
statistics. The first column is providing the corresponding patch ID,
which is also existing in the *forestclass5\_ID* raster map
(here:0-878). The second column is providing the percentage cover of
each patch (sum is equal the overall coverage: 0.506). The third column
is holding the actual patch index value (here area; e.g. patch 0: 12).

## SEE ALSO

*[r.pi.corearea](r.pi.corearea.md), [r.pi.corr.mw](r.pi.corr.mw.md),
[r.pi.csr.mw](r.pi.csr.mw.md), [r.pi.graph](r.pi.graph.md),
[r.pi.graph.dec](r.pi.graph.dec.md), [r.pi.graph.pr](r.pi.graph.pr.md),
[r.pi.graph.red](r.pi.graph.red.md), [r.pi.grow](r.pi.grow.md),
[r.pi.import](r.pi.import.md), [r.pi.index](r.pi.index.md),
[r.pi.lm](r.pi.lm.md), [r.pi.odc](r.pi.odc.md),
[r.pi.prob.mw](r.pi.prob.mw.md), [r.pi.rectangle](r.pi.rectangle.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.export source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.export)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.export))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
