---
name: r.pi.nlm
description: Creates a random generated map with values 0 or 1by given landcover and fragment count.
keywords: [ raster, landscape structure analysis, neutral landscapes ]
---

# r.pi.nlm

Creates a random generated map with values 0 or 1by given landcover and fragment count.

=== "Command line"

    **r.pi.nlm**
    [**-r**]
    [**input**=*name*]
    **output**=*name*
    [**keyval**=*integer*]
    [**nullval**=*integer* [,*integer*,...]]
    [**landcover**=*float*]
    [**sharpness**=*float*]
    [**seed**=*integer*]
    [**title**=*"phrase"*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.pi.nlm output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.pi.nlm***",
        **input**=*None*,
        **output**,
        **keyval**=*None*,
        **nullval**=*None*,
        **landcover**=*None*,
        **sharpness**=*None*,
        **seed**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.pi.nlm", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_pi_nlm*(**input**=*None*,
        **output**,
        **keyval**=*None*,
        **nullval**=*None*,
        **landcover**=*None*,
        **sharpness**=*None*,
        **seed**=*None*,
        **title**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_pi_nlm(output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **keyval**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of a category from the input file to measure desired landcover  
    **nullval**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Values marking areas from the input file, which are to be NULL in the resulting map  
    **landcover**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landcover in percent  
    **sharpness**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Small values produce smooth structures, great values produce sharp, edgy structures - Range [0-1]  
    **seed**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title**=*"phrase"*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print report to stdout  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of a category from the input file to measure desired landcover  
    **nullval** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Values marking areas from the input file, which are to be NULL in the resulting map  
    **landcover** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landcover in percent  
    **sharpness** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Small values produce smooth structures, great values produce sharp, edgy structures - Range [0-1]  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print report to stdout  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **keyval** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Value of a category from the input file to measure desired landcover  
    **nullval** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Values marking areas from the input file, which are to be NULL in the resulting map  
    **landcover** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Landcover in percent  
    **sharpness** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Small values produce smooth structures, great values produce sharp, edgy structures - Range [0-1]  
    **seed** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Seed for random number generator  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *"phrase"*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print report to stdout  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Creates a random generated map with values 0 or 1" "by given landcover
and agglomeration value.

## NOTES

Related to r.pi.nlm.circ but using fractal landscapes instead of
circular growth. Per default the size of the whole region is used for
generating a random landscape, this can be constraint by assigning a
class in a raster map with acts as mask for the generation of the random
landscape (*nullval*). The landcover can be set manually, randomly or be
taken from the input class coverage. The agglomeration level
(*sharpness*) can be set manually or randomly. If similar random
landscape with differing e.g. percentage coverage should be generated,
then the *seed* can be set using any number and reused for any
subsequent analysis.

## EXAMPLE

An example for the North Carolina sample dataset: A random landscape
with random percentage coverage and agglomeration factor:  

```sh
r.pi.nlm output=nlm.1 landcover=50
```

A random landscape is generated using the percentage coverage of class
5. The agglomeration factor is set randomly:  

```sh
r.pi.nlm input=landclass96 output=nlm.2 keyval=5
```

## SEE ALSO

*[r.pi.nlm.circ](r.pi.nlm.circ.md), [r.pi.nlm.stats](r.pi.nlm.stats.md),
[r.pi](r.pi.md)*

## AUTHORS

Programming: Elshad Shirinov  
Scientific concept: Dr. Martin Wegmann  
Department of Remote Sensing  
Remote Sensing and Biodiversity Unit  
University of Wuerzburg, Germany

Port to GRASS GIS 7: Markus Metz

## SOURCE CODE

Available at: [r.pi.nlm source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.pi/r.pi.nlm)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.pi/r.pi.nlm))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
