---
name: r.plane.py
description: Creates raster plane map given dip (inclination), aspect (azimuth) and one point.
keywords: [ raster, elevation ]
---

# r.plane.py

Creates raster plane map given dip (inclination), aspect (azimuth) and one point.

=== "Command line"

    **r.plane.py**
    **output**=*name*
    **dip**=*float*
    **azimuth**=*float*
    **easting**=*float*
    **northing**=*float*
    **elevation**=*float*
    [**type**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.plane.py output=name dip=0.0 azimuth=0.0 easting=0.0 northing=0.0 elevation=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.plane.py***",
        **output**,
        **dip**=*0.0*,
        **azimuth**=*0.0*,
        **easting**,
        **northing**,
        **elevation**,
        **type**=*"FCELL"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.plane.py", output="name", dip=0.0, azimuth=0.0, easting=0.0, northing=0.0, elevation=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_plane_py*(**output**,
        **dip**=*0.0*,
        **azimuth**=*0.0*,
        **easting**,
        **northing**,
        **elevation**,
        **type**=*"FCELL"*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_plane_py(output="name", dip=0.0, azimuth=0.0, easting=0.0, northing=0.0, elevation=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **dip**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip of plane in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-90-90*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **azimuth**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Azimuth of the plane in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **easting**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Easting coordinate of a point on the plane  
    **northing**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Northing coordinate of a point on the plane  
    **elevation**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation coordinate of a point on the plane  
    **type**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *FCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **dip** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip of plane in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-90-90*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **azimuth** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Azimuth of the plane in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **easting** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Easting coordinate of a point on the plane  
    **northing** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northing coordinate of a point on the plane  
    **elevation** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation coordinate of a point on the plane  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *FCELL*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **dip** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip of plane in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *-90-90*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **azimuth** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Azimuth of the plane in degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **easting** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Easting coordinate of a point on the plane  
    **northing** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Northing coordinate of a point on the plane  
    **elevation** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation coordinate of a point on the plane  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of raster map to be created  
    &nbsp;&nbsp;&nbsp;&nbsp;Storage type for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *CELL, FCELL, DCELL*  
    &nbsp;&nbsp;&nbsp;&nbsp;**CELL**: Integer  
    &nbsp;&nbsp;&nbsp;&nbsp;**FCELL**: Single precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;**DCELL**: Double precision floating point  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *FCELL*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.plane* creates a tilted plane raster map given user-specified
parameters for inclination, azimuth, and the geographic location of a
point on the plane.  
The angle orientations of the *azimuth* parameter increase
counter-clockwise, i.e., 0 degree = N, 45 degree = NW, 90 degree = W
etc.

Increasing values of the *dip* parameter progressively lower (or dip)
the northern half of the plane, and incline the southern half, assuming
the *azimuth* parameter is held constant at 0 degrees.

## NOTES

`g.region -c` provides the easting and northing coordinates for the
center of the current region.

*CELL* (integer) maps take less disk space than *FCELL*s (floating
point), which in turn take up less space than *DCELL*s (double precision
floating point).

## EXAMPLE

A tilted plane in the North Carolina sample dataset region:

```sh
# set computational region
g.region raster=elev_lid792_1m -p

# get center coordinates as an example
g.region -c
# get terrain height at point
r.what map=elev_lid792_1m coordinates=638650.0,220375.0
# shows elevation: 116.7734

# generate tilted plane
r.plane myplane30 dip=30 az=75 east=638650.0 north=220375.0 \
        elev=116.7734 type=FCELL
```

![r.plane example](r_plane_3d.png)  
*Figure: Tilted plane shown in NVIZ along with elevation map*

## AUTHORS

Stefan Jäger (1994), University of Heidelberg during a stay at USGS  
Updated to GRASS 5.7 by Michael Barton, Arizona State University  
Full rewrite for GRASS 7 by Glynn Clements

## SOURCE CODE

Available at: [r.plane source code](https://github.com/OSGeo/grass/tree/main/scripts/r.plane)
([history](https://github.com/OSGeo/grass/commits/main/scripts/r.plane))  
Latest change: Tuesday Apr 29 06:15:53 2025 in commit [14f5310](https://github.com/OSGeo/grass/commit/14f53105a219d361c75919765a39ecaedaf0650a)
