---
name: r.quant
description: Produces the quantization file for a floating-point map.
keywords: [ raster, statistics, quantization ]
---

# r.quant

Produces the quantization file for a floating-point map.

=== "Command line"

    **r.quant**
    [**-tr**]
    **input**=*string* [,*string*,...]
    [**rules**=*name*]
    [**basemap**=*string*]
    [**fprange**=*dmin,dmax*]
    [**range**=*min,max*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.quant input=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.quant***",
        **input**,
        **rules**=*None*,
        **basemap**=*None*,
        **fprange**=*None*,
        **range**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.quant", input="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_quant*(**input**,
        **rules**=*None*,
        **basemap**=*None*,
        **fprange**=*None*,
        **range**=*None*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_quant(input="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) to be quantized  
    **rules**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to rules file ("-" to read from stdin)  
    **basemap**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base map to take quant rules from  
    **fprange**=*dmin,dmax*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floating point range: dmin,dmax  
    **range**=*min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer range: min,max  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Truncate floating point data  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Round floating point data  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) to be quantized  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **rules** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to rules file ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **basemap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base map to take quant rules from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **fprange** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floating point range: dmin,dmax  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *dmin,dmax*  
    **range** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer range: min,max  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Truncate floating point data  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Round floating point data  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map(s) to be quantized  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **rules** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to rules file ("-" to read from stdin)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **basemap** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base map to take quant rules from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **fprange** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Floating point range: dmin,dmax  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *dmin,dmax*  
    **range** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Integer range: min,max  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Truncate floating point data  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Round floating point data  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.quant* produces the quantization file for a floating-point map.

The *map* parameter defines the map for which the rules are to be
created. If more than one map is specified, then this implies that the
floating-point range is the minimum and maximum of all the maps
together, unless either *basemap=map* or *fprange=min,max* is specified.

### Quant rules

The quant rules have to be entered interactively.

If rules is specified, the input has the form:

```sh
value1:value2:cat1:[cat2]
```

where *value1* and *value2* are floating point values and *cat1* and
*cat2* are integers. If *cat2* is missing, it is taken to be equal to
*cat1*. All values can be *"\*"* which means infinity.

## NOTE

It is an error to specify both *basemap* and *fprange*.

## SEE ALSO

*[r.support](r.support.md), [r.null](r.null.md)*

## AUTHORS

Michael Shapiro, Olga Waupotitsch, U.S.Army Construction Engineering
Research Laboratory

## SOURCE CODE

Available at: [r.quant source code](https://github.com/OSGeo/grass/tree/main/raster/r.quant)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.quant))  
Latest change: Thursday May 08 20:58:05 2025 in commit [4144ba8](https://github.com/OSGeo/grass/commit/4144ba81fa125e1549fc52e1cf5feb4fa004be8b)
