---
name: r.resamp.bspline
description: Performs bilinear or bicubic spline interpolation with Tykhonov regularization.
keywords: [ raster, surface, resample, interpolation, splines, bilinear, bicubic, no-data filling ]
---

# r.resamp.bspline

Performs bilinear or bicubic spline interpolation with Tykhonov regularization.

=== "Command line"

    **r.resamp.bspline**
    [**-nc**]
    **input**=*name*
    **output**=*name*
    [**grid**=*name*]
    [**mask**=*name*]
    [**ew_step**=*float*]
    [**ns_step**=*float*]
    [**method**=*string*]
    [**lambda**=*float*]
    [**memory**=*memory in MB*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.resamp.bspline input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.resamp.bspline***",
        **input**,
        **output**,
        **grid**=*None*,
        **mask**=*None*,
        **ew_step**=*None*,
        **ns_step**=*None*,
        **method**=*"bicubic"*,
        **lambda**=*0.01*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.resamp.bspline", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_resamp_bspline*(**input**,
        **output**,
        **grid**=*None*,
        **mask**=*None*,
        **ew_step**=*None*,
        **ns_step**=*None*,
        **method**=*"bicubic"*,
        **lambda**=*0.01*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_resamp_bspline(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **grid**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map with interpolation grid  
    **mask**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to use for masking  
    &nbsp;&nbsp;&nbsp;&nbsp;Only cells that are not NULL and not zero are interpolated  
    **ew_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the east-west direction. Default: 1.5 \* ewres.  
    **ns_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the north-south direction. Default: 1.5 \* nsres.  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spline interpolation algorithm  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    **lambda**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tykhonov regularization parameter (affects smoothing)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **memory**=*memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Only interpolate null cells in input raster map  
  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Find the best Tykhonov regularizing parameter using a "leave-one-out" cross validation method  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **grid** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map with interpolation grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to use for masking  
    &nbsp;&nbsp;&nbsp;&nbsp;Only cells that are not NULL and not zero are interpolated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ew_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the east-west direction. Default: 1.5 \* ewres.  
    **ns_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the north-south direction. Default: 1.5 \* nsres.  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spline interpolation algorithm  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bicubic*  
    **lambda** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tykhonov regularization parameter (affects smoothing)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only interpolate null cells in input raster map  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Find the best Tykhonov regularizing parameter using a "leave-one-out" cross validation method  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **grid** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map with interpolation grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **mask** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map to use for masking  
    &nbsp;&nbsp;&nbsp;&nbsp;Only cells that are not NULL and not zero are interpolated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ew_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the east-west direction. Default: 1.5 \* ewres.  
    **ns_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Length of each spline step in the north-south direction. Default: 1.5 \* nsres.  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spline interpolation algorithm  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bicubic*  
    **lambda** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tykhonov regularization parameter (affects smoothing)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.01*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum memory to be used (in MB)  
    &nbsp;&nbsp;&nbsp;&nbsp;Cache size for raster rows  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *memory in MB*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Only interpolate null cells in input raster map  
  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Find the best Tykhonov regularizing parameter using a "leave-one-out" cross validation method  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.resamp.bspline* performs a bilinear/bicubic spline interpolation with
Tykhonov regularization. The input is a raster surface map, e.g.
elevation, temperature, precipitation etc. Output is a raster map.
Optionally, only input NULL cells are interpolated, useful to fill NULL
cells, an alternative to *[r.fillnulls](r.fillnulls.md)*. Using the
**-n** flag to only interpolate NULL cells will considerably speed up
the module.

The input raster map is read at its native resolution, the output raster
map will be produced for the current computational region set with
*[g.region](g.region.md)*. A raster mask, if present, will be respected.
Masked values will be treated like other NULL cells in both the input
and output maps.

Spline step values **ew_step** for the east-west direction and
**ns_step** for the north-south direction should not be smaller than the
east-west and north-south resolutions of the input map. For a raster map
without NULL cells, 1 \* resolution can be used, but check for
undershoots and overshoots. For very large areas with missing values
(NULL cells), larger spline step values may be required, but most of the
time the defaults (1.5 x resolution) should be fine.

The Tykhonov regularization parameter (**lambda**) acts to smooth the
interpolation. With a small **lambda**, the interpolated surface closely
follows observation points; a larger value will produce a smoother
interpolation. Reasonable values are 0.0001, 0.001, 0.005, 0.01, 0.02,
0.05, 0.1 (needs more testing). For seamless NULL cell interpolation, a
small value is required. The default **lambda** value is set to 0.01.

From a theoretical perspective, the interpolating procedure takes place
in two parts: the first is an estimate of the linear coefficients of a
spline function; these are derived from the observation points using a
least squares regression; the second is the computation of the
interpolated surface (or interpolated vector points). As used here, the
splines are 2D piece-wise non-zero polynomial functions calculated
within a limited 2D area. The length of each spline step is defined by
**ew_step** for the east-west direction and **ns_step** for the
north-south direction. For optimal performance, the spline step values
should be no less than the east-west and north-south resolutions of the
input map. Each non-NULL cell observation is modeled as a linear
function of the non-zero splines in the area around the observation. The
least squares regression predicts the coefficients of these linear
functions. Regularization avoids the need to have one one observation
and one coefficient for each spline (in order to avoid instability).

A cross validation "leave-one-out" analysis is available to help to
determine the optimal **lambda** value that produces an interpolation
that best fits the original observation data. The more points used for
cross-validation, the longer the time needed for computation. Empirical
testing indicates a threshold of a maximum of 100 points is recommended.
Note that cross validation can run very slowly if more than 100
observations are used. The cross-validation output reports *mean* and
*rms* of the residuals from the true point value and the estimated from
the interpolation for a fixed series of **lambda** values. No vector nor
raster output will be created when cross-validation is selected.

## EXAMPLES

### Basic interpolation

```sh
r.resamp.bspline input=raster_surface output=interpolated_surface method=bicubic
```

A bicubic spline interpolation will be done and a raster map with
estimated (i.e., interpolated) values will be created.

### Interpolation of NULL cells and patching

General procedure:

```sh
# set region to area with NULL cells, align region to input map
g.region n=north s=south e=east w=west align=input -p
# interpolate NULL cells
r.resamp.bspline -n input=input_raster output=interpolated_nulls method=bicubic
# set region to area with NULL cells, align region to input map
g.region raster=input -p
# patch original map and interpolated NULLs
r.patch input=input_raster,interpolated_nulls output=input_raster_gapfilled
```

### Interpolation of NULL cells and patching (NC data)

In this example, the SRTM elevation map in the North Carolina sample
dataset is filtered for outlier elevation values; missing pixels are
then re-interpolated to obtain a complete elevation map:

```sh
g.region raster=elev_srtm_30m -p
d.mon wx0
d.histogram elev_srtm_30m

r.univar -e elev_srtm_30m

# remove too low elevations (esp. lakes)
# Threshold: thresh = Q1 - 1.5 * (Q3 - Q1)
r.mapcalc "elev_srtm_30m_filt = if(elev_srtm_30m < 50.0, null(), elev_srtm_30m)"

# verify
d.histogram elev_srtm_30m_filt
d.erase
d.rast elev_srtm_30m_filt

r.resamp.bspline -n input=elev_srtm_30m_filt output=elev_srtm_30m_complete \
  method=bicubic

d.histogram elev_srtm_30m_complete
d.rast elev_srtm_30m_complete
```

### Estimation of **lambda** parameter with a cross validation process

A random sample of points should be generated first with
*[r.random](r.random.md)*, and the current region should not include
more than 100 non-NULL random cells.

```sh
r.resamp.bspline -c input=input_raster
```

## REFERENCES

- Brovelli M. A., Cannata M., and Longoni U.M., 2004, LIDAR Data
  Filtering and DTM Interpolation Within GRASS, Transactions in GIS,
  April 2004, vol. 8, iss. 2, pp. 155-174(20), Blackwell Publishing Ltd
- Brovelli M. A. and Cannata M., 2004, Digital Terrain model
  reconstruction in urban areas from airborne laser scanning data: the
  method and an example for Pavia (Northern Italy). Computers and
  Geosciences 30, pp.325-331
- Brovelli M. A e Longoni U.M., 2003, Software per il filtraggio di dati
  LIDAR, Rivista dell'Agenzia del Territorio, n. 3-2003, pp. 11-22 (ISSN
  1593-2192)
- Antolin R. and Brovelli M.A., 2007, LiDAR data Filtering with GRASS
  GIS for the Determination of Digital Terrain Models. Proceedings of
  Jornadas de SIG Libre, Girona, España. CD ISBN: 978-84-690-3886-9

## SEE ALSO

*[r.fillnulls](r.fillnulls.md), [r.resamp.rst](r.resamp.rst.md),
[r.resamp.interp](r.resamp.interp.md),
[v.surf.bspline](v.surf.bspline.md)*

Overview: [Interpolation and
Resampling](https://grasswiki.osgeo.org/wiki/Interpolation) in GRASS

## AUTHORS

Markus Metz  
  
based on *[v.surf.bspline](v.surf.bspline.md)* by  
Maria Antonia Brovelli, Massimiliano Cannata, Ulisse Longoni, Mirko
Reguzzoni, Roberto Antolin

## SOURCE CODE

Available at: [r.resamp.bspline source code](https://github.com/OSGeo/grass/tree/main/raster/r.resamp.bspline)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.resamp.bspline))  
Latest change: Friday Aug 08 09:39:19 2025 in commit [ed72c71](https://github.com/OSGeo/grass/commit/ed72c71d8580e872cd6fd345c84a15c324764465)
