---
name: r.resamp.tps
description: Performs thin plate spline interpolation with regularization and covariables.
keywords: [ raster, surface, interpolation, TPS ]
---

# r.resamp.tps

Performs thin plate spline interpolation with regularization and covariables.

=== "Command line"

    **r.resamp.tps**
    [**-c**]
    **input**=*name*
    [**smooth**=*float*]
    [**overlap**=*float*]
    [**min**=*float*]
    [**max**=*float*]
    [**radius**=*integer*]
    [**icovars**=*name* [,*name*,...]]
    [**ocovars**=*name* [,*name*,...]]
    [**lmfilter**=*float*]
    [**epfilter**=*float*]
    **output**=*name*
    [**mask**=*name*]
    [**memory**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.resamp.tps input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.resamp.tps***",
        **input**,
        **smooth**=*0*,
        **overlap**=*0.2*,
        **min**=*100*,
        **max**=*None*,
        **radius**=*0*,
        **icovars**=*None*,
        **ocovars**=*None*,
        **lmfilter**=*0*,
        **epfilter**=*0*,
        **output**,
        **mask**=*None*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.resamp.tps", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_resamp_tps*(**input**,
        **smooth**=*0*,
        **overlap**=*0.2*,
        **min**=*100*,
        **max**=*None*,
        **radius**=*0*,
        **icovars**=*None*,
        **ocovars**=*None*,
        **lmfilter**=*0*,
        **epfilter**=*0*,
        **output**,
        **mask**=*None*,
        **memory**=*300*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_resamp_tps(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **smooth**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overlap**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap factor &lt;= 1  
    &nbsp;&nbsp;&nbsp;&nbsp;A larger value increase the tile overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.2*  
    **min**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points to use for TPS interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **max**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of points to use for TPS interpolation  
    **radius**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius for moving window interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;The unit for radius is cells. If radius is &gt; 0, moving window interpolation will be used instead of nearest neighbor search  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **icovars**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) to use as covariables matching the input raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **ocovars**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) to use as covariables matching the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    **lmfilter**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold to avoid interpolation outliers when using covariables  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled when set to zero, must be within [0, 1], larger values will cause more outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **epfilter**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold to avoid extrapolation when using covariables  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled when set to zero, must be &gt; 0, smaller values will cause more outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **mask**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to use for masking  
    &nbsp;&nbsp;&nbsp;&nbsp;Only cells where the mask map is not NULL and not zero are interpolated  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input points are dense clusters separated by empty areas  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **smooth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overlap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap factor &lt;= 1  
    &nbsp;&nbsp;&nbsp;&nbsp;A larger value increase the tile overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.2*  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points to use for TPS interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of points to use for TPS interpolation  
    **radius** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius for moving window interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;The unit for radius is cells. If radius is &gt; 0, moving window interpolation will be used instead of nearest neighbor search  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **icovars** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) to use as covariables matching the input raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ocovars** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) to use as covariables matching the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **lmfilter** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold to avoid interpolation outliers when using covariables  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled when set to zero, must be within [0, 1], larger values will cause more outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **epfilter** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold to avoid extrapolation when using covariables  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled when set to zero, must be &gt; 0, smaller values will cause more outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mask** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to use for masking  
    &nbsp;&nbsp;&nbsp;&nbsp;Only cells where the mask map is not NULL and not zero are interpolated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input points are dense clusters separated by empty areas  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **smooth** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Smoothing factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **overlap** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Overlap factor &lt;= 1  
    &nbsp;&nbsp;&nbsp;&nbsp;A larger value increase the tile overlap  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.2*  
    **min** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of points to use for TPS interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *100*  
    **max** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of points to use for TPS interpolation  
    **radius** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Radius for moving window interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;The unit for radius is cells. If radius is &gt; 0, moving window interpolation will be used instead of nearest neighbor search  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **icovars** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) to use as covariables matching the input raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **ocovars** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s) to use as covariables matching the current region  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **lmfilter** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold to avoid interpolation outliers when using covariables  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled when set to zero, must be within [0, 1], larger values will cause more outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **epfilter** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold to avoid extrapolation when using covariables  
    &nbsp;&nbsp;&nbsp;&nbsp;Disabled when set to zero, must be &gt; 0, smaller values will cause more outliers  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mask** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map to use for masking  
    &nbsp;&nbsp;&nbsp;&nbsp;Only cells where the mask map is not NULL and not zero are interpolated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Memory in MB  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Input points are dense clusters separated by empty areas  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.resamp.tps* performs multivariate thin plate spline interpolation
with regularization. The **input** is a raster map to be resampled to a
higher resolution or where NULL cells need to be interpolated. Output is
a raster map. Optionally, several raster maps can be specified to be
used as covariables which will improve results in areas with few points.
Raster maps to be used as covariables need to be provided separately
matching the grid geometry of the **input** raster map with the
**icovars** option and matching the grid geometry of the **output**
raster map with the **ocovars** option. The module can be regarded as a
combination of a multiple regression and spline interpolation.

The **min** options specifies the minimum number of points to be used
for interpolation. *r.resamp.tps* always performs tiled local TPS
interpolation. Tile sizes are variable and dependent on the extents of
the **min** nearest neighbors when a new tile is generated.

The **smooth** option can be used to reduce the influence of the splines
and increase the influence of the covariables. Without covariables, the
resulting surface will be smoother. With covariables and a large
smooting value, the resulting surface will be mainly determined by the
multiple regression component.

The **overlap** option controls how much tiles are overlapping when the
**min** option is smaller than the numer of input points. Tiling
artefacts occur with low values for the **min** option and the
**overlap** option. Increasing both options will reduce tiling artefacts
but processing will take more time.

The module works best with evenly spaced points. In case of highly
unevenly spaced points, e.g. remote sensing data with gaps due to cloud
cover, the module will take a long time to finish. For data with large
gaps, it is recommended to use first a different interpolation method
and then optionally use *r.resamp.tps* with the **smooth** option to
identify outliers (difference between the output of *r.resamp.tps* and
the data interpolated with a different method).

When using covariables, outliers might be created if the values of the
covariables of the current output cell are far outside the observed
range of covariables, or if the linear regression component of the TPS
interpolation for the covariables does not provide a good solution. Two
methods are provided to avoid outliers caused by covariables. The first
method (*lmfilter*) will discard covariables if R squared is larger than
the value provided with the *lmfilter* option. The second method
(*epfilter*) will discard covariables if the current value of a
covariable is outside the observed range of covariables by a factor of
(*epfilter*). The *epfilter* option typically results in more
interpolations using the supplied covariables than the *lmfilter* option
when both are adjusted to reject the same outliers.

The **memory** option controls only how much memory should be used for
the covariables and the intermediate output. The data needed for TPS
interpolation are always completely loaded to memory.

## REFERENCES

- Hutchinson MF, 1995, Interpolating mean rainfall using thin plate
    smoothing splines. International Journal of Geographical Information
    Systems, 9(4), pp. 385-403
- Wahba G, 1990, Spline models for observational data. In CBMS-NSF
    Regional Conference Series in Applied Mathematics. Philadelpia:
    Society for Industrial and Applied Mathematics

## SEE ALSO

*[v.surf.tps](v.surf.tps.md),
[v.surf.rst](https://grass.osgeo.org/grass-stable/manuals/v.surf.rst.html),
[v.surf.bspline](https://grass.osgeo.org/grass-stable/manuals/v.surf.bspline.html),
[v.surf.idw](https://grass.osgeo.org/grass-stable/manuals/v.surf.idw.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [r.resamp.tps source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.resamp.tps)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.resamp.tps))  
Latest change: Sunday Jan 11 13:16:41 2026 in commit [4e21106](https://github.com/OSGeo/grass-addons/commit/4e21106a15350697580ad96e27424a17791a45cb)
