---
name: r.rock.stability.py
description: A tool for preliminary rock failure susceptibility mapping.
keywords: [ rock mass, planar failure, toppling ]
---

# r.rock.stability.py

A tool for preliminary rock failure susceptibility mapping.

=== "Command line"

    **r.rock.stability.py**
    **dem**=*string*
    **imme**=*integer*
    **incl**=*integer*
    **f4**=*string*
    **rmr**=*string*
    **prefix**=*string*
    [**tc**=*float*]
    [**imme2**=*integer*]
    [**incl2**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.rock.stability.py dem=string imme=0 incl=0 f4=Natural Slope +15 rmr=string prefix=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.rock.stability.py***",
        **dem**,
        **imme**,
        **incl**,
        **f4**,
        **rmr**,
        **prefix**,
        **tc**=*None*,
        **imme2**=*None*,
        **incl2**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.rock.stability.py", dem="string", imme=0, incl=0, f4="Natural Slope +15", rmr="string", prefix="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_rock_stability_py*(**dem**,
        **imme**,
        **incl**,
        **f4**,
        **rmr**,
        **prefix**,
        **tc**=*None*,
        **imme2**=*None*,
        **incl2**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_rock_stability_py(dem="string", imme=0, incl=0, f4="Natural Slope +15", rmr="string", prefix="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **dem**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dtm of the zone  
    **imme**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip direction of the joint (0-360)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    **incl**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip of the joint (0-90)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-90*  
    **f4**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;F4 index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Natural Slope +15, Pre-splitting +10, Smooth blasting +8, Normal blasting or mechanical excavation 0, Poor blasting -8*  
    **rmr**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;RMR index  
    **prefix**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output maps  
    **tc**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Total Condition of joint, for SSPC output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.018975 - 1.0165*  
    **imme2**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip direction of the joint (0-360). For SMR_wedge output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    **incl2**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip of the joint (0-90). For SMR_wedge output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-90*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **dem** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dtm of the zone  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **imme** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip direction of the joint (0-360)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    **incl** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip of the joint (0-90)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-90*  
    **f4** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;F4 index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Natural Slope +15, Pre-splitting +10, Smooth blasting +8, Normal blasting or mechanical excavation 0, Poor blasting -8*  
    **rmr** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;RMR index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output maps  
    **tc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Total Condition of joint, for SSPC output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.018975 - 1.0165*  
    **imme2** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip direction of the joint (0-360). For SMR_wedge output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    **incl2** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip of the joint (0-90). For SMR_wedge output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-90*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **dem** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dtm of the zone  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **imme** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip direction of the joint (0-360)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    **incl** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip of the joint (0-90)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-90*  
    **f4** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;F4 index  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Natural Slope +15, Pre-splitting +10, Smooth blasting +8, Normal blasting or mechanical excavation 0, Poor blasting -8*  
    **rmr** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;RMR index  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **prefix** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Prefix for output maps  
    **tc** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Total Condition of joint, for SSPC output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.018975 - 1.0165*  
    **imme2** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip direction of the joint (0-360). For SMR_wedge output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-360*  
    **incl2** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Dip of the joint (0-90). For SMR_wedge output  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-90*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Two important steps can be recognised in the rockfall analysis: the
potential failure detection and the run out simulation. Analyzing the
stability of rock slopes, most important kinematisms are slidings
(planar or wedge) and topplings. r.rock.stability is a module that
allows users to apply geomechanical classifications (SMR and SSPC) for
the preliminary assessment of the susceptibility of rock slopes to
failures induced by these kinematisms.

**SMR approach (default)**:SMR (Slope Mass Rating) is a widely used
geomechanical classification developed by Romana (1995). The final SMR
rating is obtained by means of next expression: SMR=RMRb+(F1\*F2\*F3)+F4
where:

- RMRb is the RMR index resulting from Bieniawski's Rock Mass
    Classification (1989)
- F1 depends on the parallelism between discontinuity and slope dip
    direction
- F2 depends on the discontinuity dip in the case of planar failure
    and the plunge, or of the intersection line in wedge failure. As
    regards toppling failure, this parameter takes the value 1.0
- F3 depends on the relationship between slope and discontinuity dips
    (toppling or planar failure cases) or the immersion line dip (wedge
    failure case)
- F4 is a correction factor that depends on the excavation method
    used:
  - Natural Slope +15
  - Pre-splitting +10
  - Smooth blasting +8
  - Normal blasting or mechanical excavation 0
  - Poor blasting -8
  </li>

r.rock.stability calculate F1, F2 and F3 index by combining DEM (slope
and aspect) and joint dip and dip direction.

F1, F2 and F3 are calculated according two functions of Romana (1995)
and of Tomàs et al. (2007). The functions proposed by Romana are
discrete, instead Tomàs et al. (2007) proposed continuous functions that
reduced subjective interpretations.

**SSPC approach (optional)**: inserting TC value (or a map of TC values)
it's possible to obtain a SSPC map according to Hack's classification
(Hack, 1998). Only a part of the method introduced by Hack is used in
the module: the orientation dependent stability (the stability depend on
relation between slope and discontinuity orientation). According to the
author:

- sliding occurs if: TC \< 0,0113\*AP
- toppling occurs if: TC \< 0,0087\*(-90-AP+dip)

where AP is the apparent dip, TC is the condition factor for a
discontinuity. TC can be calculated by multiplying the large scale
roughness, the small scale roughness, the infill material and the karst
factors observed in the field:

**TC=Rl Rs Im Ka**.

**Rl** (roughness in large scale - area between 0,2x0,2 m2 and 1x1 m2)

- 1,00 Wavy
- 0,95 Slightly wavy
- 0,85 Curved
- 0,80 Slightly curved
- 0,75 Straight

**Rs** (roughness in small scale - area of 0,2x0,2m2):

- 0,95 Rough stepped
- 0,90 Smooth stepped
- 0,85 Polished stepped
- 0,80 Rough undulating
- 0,75 Smooth undulating
- 0,70 Polished undulating
- 0,65 Rough planar
- 0,60 Smooth planar
- 0,55 Polished planar.

**Im** (Infill material)

- Cemented --\> Infill (1,07), No Infill (1,00)
- Non softening and sheared material e.g. free of clay, talc, etc --\>
    Coarse (0,95) Medium (0,90) Fine (0,85)
- Soft sheared material e.g. clay, talc, etc --\> Coarse (0,75) Medium
    (0,65) Fine (0,55)
- Gouge \< irregularities (0,42); Gouge \> irregularities (0,17);
    flowing material (0,05)

**Ka** (karst):

- 1,00 None
- 0.92 Karst

NOTE: high pixel values indicate high susceptibility

**SMR wedge (optional)**: inserting dip and dip direction it's possible
to calculate the SMR index of wedge.

## INPUT

**Digital Elevation Model**:
Name of elevation raster map

**Dip direction**:
Value of the direction of the discontinuity measured clockwise starting from
North. North is 0 or 360 degrees, East (90 degrees), South (180 degrees),
West (270 degrees)

**Dip**:
Angle of inclination of the discontinuity relative to a horizontal plane.

**F4**:
Correction factor according to Romana's classification

**RMR**:
Value of RMRb according to Bieniawski's classification

**TC (optional)**:
Value of TC according to Hack's classification

**Output prefix**:
Name of prefix used for output raster maps

## OUTPUT

**r.rock.stability** generates **3 raster maps of SMR**
(prefix\_toppling; prefix\_planar; prefix\_wedge;) values distribution
according to mechanism: planar sliding, toppling and wedge (if optional
dip and dip direction is inserted).

| SMR classes | SMR values | Suggest supports                                                                                  |
| ----------- | ---------- | ------------------------------------------------------------------------------------------------- |
| Ia          | 91-100     | None                                                                                              |
| Ib          | 81-90      | None, scaling is required                                                                         |
| IIa         | 71-80      | (None, toe ditch or fence), spot bolting                                                          |
| IIb         | 61-70      | (Toe ditch or fence nets), spot or systematic bolting                                             |
| IIIa        | 51-60      | (Toe ditch and/or fence nets), spot or systematic bolting, spot shotcrete                         |
| IIIb        | 41-50      | (Toe ditch and/or fence nets), spot or systematic bolting/anchor, toe wall and/or dental concrete |
| IVa         | 31-40      | Anchor systematic shotcrete, toe wall and/or dental concrete (or re-excavation), drainage         |
| IVb         | 21-30      | Systematic reinforced shotcrete, toe wall and/or concrete, re-excavation, deep drainage           |
| Va          | 11-20      | Gravity or anchored wall, re-excavation                                                           |

## REFERENCES

BIENIAWSKI Z.T. (1989). Engineering Rock Mass Classifications. John
Wiley and Sons: New York.

FILIPELLO A., GIULIANI A., MANDRONE G. (2010) - Rock Slopes Failure
Susceptibility Analysis: From Remote Sensing Measurements to Geographic
Information System Raster Modules. American Journal of Environmental
Sciences 6 (6): 489-494, 2010 ISSN 1553-345X © 2010 Science
Publications.

HACK HRGK (1998) Slope stability probability classification, SSPC, 2nd
edn. ITC, Enschede, The Netherlands, 258 pp, ISBN 90 6164 154 3

ROMANA M. (1995). The geomechanical classification SMR for slope
correction. Proc. Int. Congress on Rock Mechanics 3: 1085-1092.

TOMÀS, R., DELGADO, J.,SERON, J.B. (2007). Modification of slope mass
rating(SMR) by continuous functions. International Journal of Rock
Mechanics and Mining Sciences 44: 1062-1069.

## SEE ALSO

## AUTHORS

Andrea Filipello, University of Turin, Italy

Daniele Strigaro, University of Milan, Italy

## SOURCE CODE

Available at: [r.rock.stability source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.rock.stability)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.rock.stability))  
Latest change: Thursday Mar 20 21:35:59 2025 in commit [f270357](https://github.com/OSGeo/grass-addons/commit/f270357f0ee5a6a465fc12b118ca6694cd6c7f9d)
