---
name: r.ros
description: Generates rate of spread raster maps. Generates three, or four raster map layers showing the base (perpendicular) rate of spread (ROS), the maximum (forward) ROS, the direction of the maximum ROS, and optionally the maximum potential spotting distance for fire spread simulation.
keywords: [ raster, fire, spread, rate of spread, hazard, model ]
---

# r.ros

Generates rate of spread raster maps.

Generates three, or four raster map layers showing the base (perpendicular) rate of spread (ROS), the maximum (forward) ROS, the direction of the maximum ROS, and optionally the maximum potential spotting distance for fire spread simulation.

=== "Command line"

    **r.ros**
    **model**=*name*
    [**moisture_1h**=*name*]
    [**moisture_10h**=*name*]
    [**moisture_100h**=*name*]
    **moisture_live**=*name*
    [**velocity**=*name*]
    [**direction**=*name*]
    [**slope**=*name*]
    [**aspect**=*name*]
    [**elevation**=*name*]
    **base_ros**=*name*
    **max_ros**=*name*
    **direction_ros**=*name*
    [**spotting_distance**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.ros model=name moisture_live=name base_ros=name max_ros=name direction_ros=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.ros***",
        **model**,
        **moisture_1h**=*None*,
        **moisture_10h**=*None*,
        **moisture_100h**=*None*,
        **moisture_live**,
        **velocity**=*None*,
        **direction**=*None*,
        **slope**=*None*,
        **aspect**=*None*,
        **elevation**=*None*,
        **base_ros**,
        **max_ros**,
        **direction_ros**,
        **spotting_distance**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.ros", model="name", moisture_live="name", base_ros="name", max_ros="name", direction_ros="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_ros*(**model**,
        **moisture_1h**=*None*,
        **moisture_10h**=*None*,
        **moisture_100h**=*None*,
        **moisture_live**,
        **velocity**=*None*,
        **direction**=*None*,
        **slope**=*None*,
        **aspect**=*None*,
        **elevation**=*None*,
        **base_ros**,
        **max_ros**,
        **direction_ros**,
        **spotting_distance**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_ros(model="name", moisture_live="name", base_ros="name", max_ros="name", direction_ros="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **model**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing fuel models  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the standard fuel models defined by the USDA Forest Service. Valid values are 1-13; other numbers are recognized as barriers by r.ros.  
    **moisture_1h**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing the 1-hour fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 1-hour (&lt;.25") fuel moisture (percentage content multiplied by 100).  
    **moisture_10h**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing the 10-hour fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 10-hour (.25-1") fuel moisture (percentage content multiplied by 100).  
    **moisture_100h**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing the 100-hour fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 100-hour (1-3") fuel moisture (percentage content multiplied by 100).  
    **moisture_live**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing live fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing live (herbaceous) fuel moisture (percentage content multiplied by 100).  
    **velocity**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing midflame wind velocities (ft/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing wind velocities at half of the average flame height (feet/minute).  
    **direction**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing wind directions (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing wind direction, clockwise from north (degree).  
    **slope**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing slope (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing topographic slope (degree).  
    **aspect**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing aspect (degree, CCW from E)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing topographic aspect, counterclockwise from east (GRASS convention) in degrees.  
    **elevation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing elevation (m, required for spotting)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing elevation (meters). Option is required from spotting distance computation (when spotting_distance option is provided)  
    **base_ros**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing base ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Base (perpendicular) rate of spread (ROS)  
    **max_ros**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing maximal ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum (forward) rate of spread (ROS)  
    **direction_ros**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing directions of maximal ROS (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;The direction of the maximal (forward) rate of spread (ROS)  
    **spotting_distance**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing maximal spotting distance (m)  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximal potential spotting distance (requires elevation raster map to be provided).  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **model** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing fuel models  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the standard fuel models defined by the USDA Forest Service. Valid values are 1-13; other numbers are recognized as barriers by r.ros.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **moisture_1h** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing the 1-hour fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 1-hour (&lt;.25") fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **moisture_10h** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing the 10-hour fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 10-hour (.25-1") fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **moisture_100h** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing the 100-hour fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 100-hour (1-3") fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **moisture_live** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing live fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing live (herbaceous) fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **velocity** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing midflame wind velocities (ft/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing wind velocities at half of the average flame height (feet/minute).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **direction** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing wind directions (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing wind direction, clockwise from north (degree).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing slope (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing topographic slope (degree).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing aspect (degree, CCW from E)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing topographic aspect, counterclockwise from east (GRASS convention) in degrees.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing elevation (m, required for spotting)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing elevation (meters). Option is required from spotting distance computation (when spotting_distance option is provided)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **base_ros** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing base ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Base (perpendicular) rate of spread (ROS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **max_ros** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing maximal ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum (forward) rate of spread (ROS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **direction_ros** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing directions of maximal ROS (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;The direction of the maximal (forward) rate of spread (ROS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **spotting_distance** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing maximal spotting distance (m)  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximal potential spotting distance (requires elevation raster map to be provided).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **model** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing fuel models  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the standard fuel models defined by the USDA Forest Service. Valid values are 1-13; other numbers are recognized as barriers by r.ros.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **moisture_1h** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing the 1-hour fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 1-hour (&lt;.25") fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **moisture_10h** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing the 10-hour fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 10-hour (.25-1") fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **moisture_100h** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing the 100-hour fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing the 100-hour (1-3") fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **moisture_live** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing live fuel moisture (%)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing live (herbaceous) fuel moisture (percentage content multiplied by 100).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **velocity** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing midflame wind velocities (ft/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing wind velocities at half of the average flame height (feet/minute).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **direction** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing wind directions (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing wind direction, clockwise from north (degree).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slope** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map containing slope (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing topographic slope (degree).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing aspect (degree, CCW from E)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing topographic aspect, counterclockwise from east (GRASS convention) in degrees.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **elevation** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map containing elevation (m, required for spotting)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of an existing raster map layer in the user's current mapset search path containing elevation (meters). Option is required from spotting distance computation (when spotting_distance option is provided)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **base_ros** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing base ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;Base (perpendicular) rate of spread (ROS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **max_ros** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing maximal ROS (cm/min)  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum (forward) rate of spread (ROS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **direction_ros** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing directions of maximal ROS (degree)  
    &nbsp;&nbsp;&nbsp;&nbsp;The direction of the maximal (forward) rate of spread (ROS)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **spotting_distance** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output raster map containing maximal spotting distance (m)  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximal potential spotting distance (requires elevation raster map to be provided).  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.ros* is part of the wildfire simulation toolset. Preparational steps
for the fire simulation are the calculation of the rate of spread (ROS)
with *r.ros*, and the creating of spread map with *r.spread*.
Eventually, the fire path(s) based on starting point(s) are calculated
with *r.spreadpath*.

*r.ros* is used for fire (wildfire) modeling. The input is fuel model
and moisture and the outputs are rate of spread (ROS) values. The module
generates the base ROS value, maximum ROS value, direction of the
maximum ROS, and optionally the maximum potential spotting distance of
wildfire for each raster cell in the current geographic region. These
three or four raster map layers serve as inputs for the
*[r.spread](r.spread.md)* module which is the next step in fire
simulation.

The *r.ros* module and two related modules *[r.spread](r.spread.md)*,
and *[r.spreadpath](r.spreadpath.md)* can be used not only for wildfire
modeling but also generally to simulate other events where spread of
something is involved and elliptical spread is appropriate.

The calculation of the two ROS values for each raster cell is based on
the Fortran code by Pat Andrews (1983) of the Northern Forest Fire
Laboratory, USDA Forest Service. The direction of the maximum ROS
results from the vector addition of the forward ROS in wind direction
and that in upslope direction. The spotting distance, if required, will
be calculated by a separate function, spot_dist(), which is based on
Lathrop and Xu (in preparation), Chase (1984) and Rothermel (1991). More
information on *r.ros* and *[r.spread](r.spread.md)* can be found in Xu
(1994).

The **output** parameter is a basename (prefix) for all generated raster
maps and each map gets a unique suffix:

- `.base` for the base (perpendicular) ROS (cm/minute)
- `.max` for the maximum (forward) ROS (cm/minute),
- `.maxdir` for the direction of the maximum ROS, clockwise from north
  (degree), and optionally
- `.spotdist` for the maximum potential spotting distance (meters).

So, if the output parameter is `blackforest_ros`, *r.ros* creates
`blackforest_ros.base`, `blackforest_ros.max`, `blackforest_ros.maxdir`,
and (optionally) `blackforest_ros.spotdist` raster maps.

If only one or two of the options **moisture_1h**, **moisture_10h**, and
**moisture_100h** are given, the module will assign values to the
missing option using the formula:

```sh
moisture_100h = moisture_10h + 1 = moisture_1h + 2
```

However, at least one of them should be given.

Options **velocity** and **direction** must be both given or both
omitted. If none is given, the module will assume a no-wind condition.

Options **slope** and **aspect** must be also given together. If none is
given, the module will assume a topographically flat condition. Option
**elevation** must be given if **-s** (spotting) flag is used.

## EXAMPLES

Assume we have inputs, the following generates ROSes and spotting
distances:

```sh
r.ros -s model=fire_model moisture_1h=1hour_moisture moisture_live=live_moisture \
    velocity=wind_speed direction=wind_direction \
    slope=slope aspect=aspect elevation=elevation output=ros
```

## NOTES

1. *r.ros* is supposed to be run before running
    *[r.spread](r.spread.md)* module. The combination of these two
    modules forms a simulation of the spread of wildfires.
2. The user should be sure that the inputs to *r.ros* are in proper
    units.
3. The output units for the base and maximum ROSes are in cm/minute
    rather than ft/minute, which is due to that a possible zero
    ft/minute base ROS value and a positive integer ft/minute maximum
    ROS would result in calculation failure in the
    *[r.spread](r.spread.md)* module. As far as the user just use
    *r.ros* together with *[r.spread](r.spread.md)*, there is no need to
    concern about these output units.

## REFERENCES

- **Albini,** F. A., 1976, Computer-based models of wildland fire
  behavior: a user's manual, USDA Forest Service, Intermountain Forest
  and Range Experiment Station, Ogden, Utah.
- **Andrews**, P. L., 1986, BEHAVE: fire behavior prediction and fuel
  modeling system -- BURN subsystem, Part 1, USDA Forest Service,
  Intermountain Research Station, Gen. Tech. Rep. INT-194, Ogden, Utah.
- **Chase**, Carolyn, H., 1984, Spotting distance from wind-driven
  surface fires -- extensions of equations for pocket calculators, US
  Forest Service, Res. Note INT-346, Ogden, Utah.
- **Lathrop**, Richard G. and Jianping Xu, A geographic information
  system-based approach for calculating spotting distance. (in
  preparation)
- **Rothermel**, R. E., 1972, A mathematical model for predicting fire
  spread in wildland fuels, USDA Forest Service, Intermountain Forest
  and Range Experiment Station, Res. Pap. INT-115, Ogden, Utah.
- **Rothermel**, Richard, 1991, Predicting behavior and size of crown
  fires in the northern Rocky Mountains, US Forest Service, Res. Paper
  INT-438, Ogden, Utah.
- **Xu**, Jianping, 1994, Simulating the spread of wildfires using a
  geographic information system and remote sensing, Ph. D. Dissertation,
  Rutgers University, New Brunswick, Jersey
  ([ref](https://dl.acm.org/citation.cfm?id=921466)).

## SEE ALSO

*[g.region](g.region.md), [r.slope.aspect](r.slope.aspect.md),
[r.spread](r.spread.md), [r.spreadpath](r.spreadpath.md)* Sample data
download:
[firedemo.sh](https://grass.osgeo.org/sampledata/firedemo_grass7.sh)
(run this script within the "Fire simulation data set" project).

## AUTHOR

Jianping Xu, Center for Remote Sensing and Spatial Analysis, Rutgers
University.

## SOURCE CODE

Available at: [r.ros source code](https://github.com/OSGeo/grass/tree/main/raster/r.ros)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.ros))  
Latest change: Friday Mar 07 07:39:48 2025 in commit [e1e37d8](https://github.com/OSGeo/grass/commit/e1e37d87e78212dfcf4c97aaf32c54042adbd2b0)
