---
name: r.skyview.py
description: Computes skyview factor visualization technique.
keywords: [ raster, visualization ]
---

# r.skyview.py

Computes skyview factor visualization technique.

=== "Command line"

    **r.skyview.py**
    [**-on**]
    **input**=*name*
    **output**=*name*
    **ndir**=*integer*
    [**maxdistance**=*float*]
    [**color_source**=*string*]
    [**color_input**=*name*]
    [**color_table**=*string*]
    [**colorized_output**=*name*]
    [**basename**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.skyview.py input=name output=name ndir=16
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.skyview.py***",
        **input**,
        **output**,
        **ndir**=*16*,
        **maxdistance**=*None*,
        **color_source**=*"input"*,
        **color_input**=*None*,
        **color_table**=*None*,
        **colorized_output**=*None*,
        **basename**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.skyview.py", input="name", output="name", ndir=16)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_skyview_py*(**input**,
        **output**,
        **ndir**=*16*,
        **maxdistance**=*None*,
        **color_source**=*"input"*,
        **color_input**=*None*,
        **color_table**=*None*,
        **colorized_output**=*None*,
        **basename**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_skyview_py(input="name", output="name", ndir=16)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **ndir**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of directions (8 to 32 recommended)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *16*  
    **maxdistance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum distance to consider when finding the horizon height  
    **color_source**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Source raster for colorization  
    &nbsp;&nbsp;&nbsp;&nbsp;Input and color_input are taken from input and color_input options respectively. The rest is computed using r.slope.aspect  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input,  color_input,  slope,  aspect,  dxy*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**:  use the raster from the input option  
    &nbsp;&nbsp;&nbsp;&nbsp;**color_input**: use the raster from the color_input option  
    &nbsp;&nbsp;&nbsp;&nbsp;**slope**: compute and use slope  
    &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: compute and use aspect  
    &nbsp;&nbsp;&nbsp;&nbsp;**dxy**: compute and use second order partial derivative dxy  
    **color_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom raster map to be used for colorization  
    **color_table**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color table for colorization raster (preset color table by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;If empty, the color table of the created raster is used (not used at all for input and color_input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *reds,  blues,  greens,  oranges,  sepia,  aspectcolr*  
    **colorized_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colorized sky-view factor  
    **basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the basename for the intermediate maps  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Compute openness instead of skyview factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Openness considers zenith angles &gt; 90 degrees  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Invert color table for colorization raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignored for input and color_input  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **ndir** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of directions (8 to 32 recommended)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *16*  
    **maxdistance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum distance to consider when finding the horizon height  
    **color_source** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Source raster for colorization  
    &nbsp;&nbsp;&nbsp;&nbsp;Input and color_input are taken from input and color_input options respectively. The rest is computed using r.slope.aspect  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input,  color_input,  slope,  aspect,  dxy*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**:  use the raster from the input option  
    &nbsp;&nbsp;&nbsp;&nbsp;**color_input**: use the raster from the color_input option  
    &nbsp;&nbsp;&nbsp;&nbsp;**slope**: compute and use slope  
    &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: compute and use aspect  
    &nbsp;&nbsp;&nbsp;&nbsp;**dxy**: compute and use second order partial derivative dxy  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **color_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom raster map to be used for colorization  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color_table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color table for colorization raster (preset color table by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;If empty, the color table of the created raster is used (not used at all for input and color_input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *reds,  blues,  greens,  oranges,  sepia,  aspectcolr*  
    **colorized_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colorized sky-view factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the basename for the intermediate maps  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute openness instead of skyview factor  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Openness considers zenith angles &gt; 90 degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert color table for colorization raster  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignored for input and color_input  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **ndir** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of directions (8 to 32 recommended)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *2-360*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *16*  
    **maxdistance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum distance to consider when finding the horizon height  
    **color_source** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Source raster for colorization  
    &nbsp;&nbsp;&nbsp;&nbsp;Input and color_input are taken from input and color_input options respectively. The rest is computed using r.slope.aspect  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *input,  color_input,  slope,  aspect,  dxy*  
    &nbsp;&nbsp;&nbsp;&nbsp;**input**:  use the raster from the input option  
    &nbsp;&nbsp;&nbsp;&nbsp;**color_input**: use the raster from the color_input option  
    &nbsp;&nbsp;&nbsp;&nbsp;**slope**: compute and use slope  
    &nbsp;&nbsp;&nbsp;&nbsp;**aspect**: compute and use aspect  
    &nbsp;&nbsp;&nbsp;&nbsp;**dxy**: compute and use second order partial derivative dxy  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *input*  
    **color_input** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Custom raster map to be used for colorization  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **color_table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color table for colorization raster (preset color table by default)  
    &nbsp;&nbsp;&nbsp;&nbsp;If empty, the color table of the created raster is used (not used at all for input and color_input)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *reds,  blues,  greens,  oranges,  sepia,  aspectcolr*  
    **colorized_output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Colorized sky-view factor  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Set the basename for the intermediate maps  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *o*, *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute openness instead of skyview factor  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Openness considers zenith angles &gt; 90 degrees  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert color table for colorization raster  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignored for input and color_input  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

Module *r.skyview* computes skyview factor, a relief visualization
technique (Zaksek et al. 2011). The value of each cell is given by the
portion of visible sky (from that cell) limited by the surrounding
relief. The values range from 0 to 1. The lighter the value is, the more
open the terrain is.

When flag **-o** is set, r.skyview computes openness instead of skyview
factor. Openness (based on positive openness by Yokoyama et al. 2002)
takes into account zenith angles greater than 90 degrees, while skyview
limits zenith angles to 90 degrees (celestial hemisphere). This makes
difference for example for visualization of horizontal planes and
slopes. Openness values range from 0 to 2.

## NOTES

Module
*[r.horizon](https://grass.osgeo.org/grass-stable/manuals/r.horizon.html)*
is used to compute elevation angles.

## EXAMPLES

We compute the skyview factor map of the North Carolina sample dataset
`elevation` map:

```sh
g.region raster=elevation
r.skyview input=elevation output=elevation_skyview ndir=8
```

![image-alt](elevation.jpg)

## SEE ALSO

*[r.horizon](https://grass.osgeo.org/grass-stable/manuals/r.horizon.html),
[r.relief](https://grass.osgeo.org/grass-stable/manuals/r.relief.html),
[r.shaded.pca](r.shaded.pca.md), [r.local.relief](r.local.relief.md)*

## REFERENCES

- Zaksek K, Ostir K, Kokalj Z. *Sky-View Factor as a Relief
    Visualization Technique.* Remote Sensing. 2011; 3(2):398-415.
- Yokoyama R, Shirasawa M, Pike J R. *Visualizing topography by
    Openness: A new application of image processing to digital elevation
    models.* Photogrammetric engineering and remote sensing 68.3 (2002):
    257-266.

## AUTHOR

Anna Petrasova, [NCSU GeoForAll](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.skyview source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.skyview)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.skyview))  
Latest change: Friday Feb 21 10:10:05 2025 in commit [7d78fe3](https://github.com/OSGeo/grass-addons/commit/7d78fe34868674c3b6050ba1924e1c5675d155c9)
