---
name: r.slopeunits.create.py
description: Create a raster layer of slope units
keywords: [ raster, elevation, slopeunits ]
---

# r.slopeunits.create.py

Create a raster layer of slope units

=== "Command line"

    **r.slopeunits.create.py**
    [**-gs**]
    **demmap**=*name*
    [**plainsmap**=*name*]
    **slumap**=*name*
    [**slumapvect**=*name*]
    [**circvarmap**=*name*]
    [**areamap**=*name*]
    **thresh**=*float*
    **areamin**=*float*
    [**areamax**=*float*]
    **cvmin**=*float*
    **rf**=*integer*
    **maxiteration**=*integer*
    [**generalize_treshold**=*float*]
    [**convergence**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.slopeunits.create.py demmap=name slumap=name thresh=0.0 areamin=0.0 cvmin=0.0 rf=0 maxiteration=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.slopeunits.create.py***",
        **demmap**,
        **plainsmap**=*None*,
        **slumap**,
        **slumapvect**=*None*,
        **circvarmap**=*None*,
        **areamap**=*None*,
        **thresh**,
        **areamin**,
        **areamax**=*None*,
        **cvmin**,
        **rf**,
        **maxiteration**,
        **generalize_treshold**=*20*,
        **convergence**=*5*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.slopeunits.create.py", demmap="name", slumap="name", thresh=0.0, areamin=0.0, cvmin=0.0, rf=0, maxiteration=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_slopeunits_create_py*(**demmap**,
        **plainsmap**=*None*,
        **slumap**,
        **slumapvect**=*None*,
        **circvarmap**=*None*,
        **areamap**=*None*,
        **thresh**,
        **areamin**,
        **areamax**=*None*,
        **cvmin**,
        **rf**,
        **maxiteration**,
        **generalize_treshold**=*20*,
        **convergence**=*5*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_slopeunits_create_py(demmap="name", slumap="name", thresh=0.0, areamin=0.0, cvmin=0.0, rf=0, maxiteration=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **demmap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    **plainsmap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of alluvial plains  
    **slumap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer (the main output)  
    **slumapvect**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer as vector layer  
    **circvarmap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Circular Variance layer  
    **areamap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Area layer; values in square meters  
    **thresh**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial threshold (m^2).  
    **areamin**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum area (m^2) below which the slope unit is not further segmented  
    **areamax**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum area (m^2) above which the slope unit is segmented irrespective of aspect  
    **cvmin**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum value of the circular variance (0.0-1.0) below which the slope unit is not further segmented  
    **rf**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor used to iterativelly reduce initial threshold: newthresh=thresh-thresh/reductionfactor  
    **maxiteration**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum number of iteration to do before the procedure is in any case stopped  
    **generalize_treshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for maximal tolerance value for v.generalize  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1000000000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **convergence**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence factor for MFD in r.watershed (1-10)  
    &nbsp;&nbsp;&nbsp;&nbsp;1 = most diverging flow, 10 = most converging flow. Recommended: 5  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Generalize Slope Units vector layer  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;SFD (D8) flow in r.watershed (default is MFD)  
    &nbsp;&nbsp;&nbsp;&nbsp;SFD: single flow direction, MFD: multiple flow direction  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **demmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plainsmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of alluvial plains  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slumap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer (the main output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **slumapvect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer as vector layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **circvarmap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Circular Variance layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **areamap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Area layer; values in square meters  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **thresh** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial threshold (m^2).  
    **areamin** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum area (m^2) below which the slope unit is not further segmented  
    **areamax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum area (m^2) above which the slope unit is segmented irrespective of aspect  
    **cvmin** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum value of the circular variance (0.0-1.0) below which the slope unit is not further segmented  
    **rf** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor used to iterativelly reduce initial threshold: newthresh=thresh-thresh/reductionfactor  
    **maxiteration** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum number of iteration to do before the procedure is in any case stopped  
    **generalize_treshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for maximal tolerance value for v.generalize  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1000000000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **convergence** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence factor for MFD in r.watershed (1-10)  
    &nbsp;&nbsp;&nbsp;&nbsp;1 = most diverging flow, 10 = most converging flow. Recommended: 5  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generalize Slope Units vector layer  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SFD (D8) flow in r.watershed (default is MFD)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SFD: single flow direction, MFD: multiple flow direction  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **demmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plainsmap** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input raster map of alluvial plains  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slumap** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer (the main output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **slumapvect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer as vector layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **circvarmap** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Circular Variance layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **areamap** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Area layer; values in square meters  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **thresh** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial threshold (m^2).  
    **areamin** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum area (m^2) below which the slope unit is not further segmented  
    **areamax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum area (m^2) above which the slope unit is segmented irrespective of aspect  
    **cvmin** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum value of the circular variance (0.0-1.0) below which the slope unit is not further segmented  
    **rf** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor used to iterativelly reduce initial threshold: newthresh=thresh-thresh/reductionfactor  
    **maxiteration** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;maximum number of iteration to do before the procedure is in any case stopped  
    **generalize_treshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold for maximal tolerance value for v.generalize  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-1000000000*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **convergence** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence factor for MFD in r.watershed (1-10)  
    &nbsp;&nbsp;&nbsp;&nbsp;1 = most diverging flow, 10 = most converging flow. Recommended: 5  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Generalize Slope Units vector layer  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SFD (D8) flow in r.watershed (default is MFD)  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;SFD: single flow direction, MFD: multiple flow direction  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.slopeunits.create* creates a raster layer of slope units. Optionally,
a vector map can be created.

## EXAMPLE

```sh
r.slopeunits.create \
    demmap=dem_italia_isolegrandi@su_test \
    plainsmap=flat \
    slumap=su_tmp \
    thresh=250000 \
    areamin=200000 \
    cvmin=0.25 \
    rf=2 \
    maxiteration=50
```

## REFERENCES

- Alvioli, M., Marchesini, I., Reichenbach, P., Rossi, M., Ardizzone,
  F., Fiorucci, F., and Guzzetti, F. (2016): Automatic delineation of
  geomorphological slope units with r.slopeunits v1.0 and their
  optimization for landslide susceptibility modeling, Geosci. Model
  Dev., 9, 3975-3991.
  DOI:[10.5194/gmd-9-3975-2016](https://doi.org/10.5194/gmd-9-3975-2016)
- Alvioli, M., Guzzetti, F., & Marchesini, I. (2020): Parameter-free
  delineation of slope units and terrain subdivision of Italy.
  Geomorphology, 358, 107124.
  DOI:[10.1016/j.geomorph.2020.107124](https://doi.org/10.1016/j.geomorph.2020.107124)

## SEE ALSO

*[r.slopeunits.clean](r.slopeunits.clean.md),
[r.slopeunits.metrics](r.slopeunits.metrics.md),
[r.slopeunits.optimize](r.slopeunits.optimize.md)*

## AUTHORS

Main authors: Ivan Marchesini, Massimiliano Alvioli, CNR-IRPI  
Markus Metz (refactoring), [mundialis](https://www.mundialis.de/)

## SOURCE CODE

Available at: [r.slopeunits.create source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.slopeunits/r.slopeunits.create)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.slopeunits/r.slopeunits.create))  
Latest change: Wednesday May 07 16:16:50 2025 in commit [8af96b6](https://github.com/OSGeo/grass-addons/commit/8af96b6c1138b2b992213db3bfb2242a3e482331)
