---
name: r.slopeunits.metrics.py
description: Create metrics for slope units
keywords: [ raster, elevation, slopeunits ]
---

# r.slopeunits.metrics.py

Create metrics for slope units

=== "Command line"

    **r.slopeunits.metrics.py**
    **basin**=*name*
    **demmap**=*name*
    **slumapclean**=*name*
    **cleansize**=*float*
    **areamin**=*float*
    **cvmin**=*float*
    **resolution**=*float*
    [**outfile**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.slopeunits.metrics.py basin=name demmap=name slumapclean=name cleansize=25000 areamin=0.0 cvmin=0.0 resolution=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.slopeunits.metrics.py***",
        **basin**,
        **demmap**,
        **slumapclean**,
        **cleansize**=*25000*,
        **areamin**,
        **cvmin**,
        **resolution**,
        **outfile**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.slopeunits.metrics.py", basin="name", demmap="name", slumapclean="name", cleansize=25000, areamin=0.0, cvmin=0.0, resolution=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_slopeunits_metrics_py*(**basin**,
        **demmap**,
        **slumapclean**,
        **cleansize**=*25000*,
        **areamin**,
        **cvmin**,
        **resolution**,
        **outfile**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_slopeunits_metrics_py(basin="name", demmap="name", slumapclean="name", cleansize=25000, areamin=0.0, cvmin=0.0, resolution=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **basin**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input basin  
    **demmap**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    **slumapclean**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer, cleaned (the main output)  
    **cleansize**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units size to be removed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25000*  
    **areamin**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum area (m^2) below which the slope unit is not further segmented  
    **cvmin**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum value of the circular variance (0.0-1.0) below which the slope unit is not further segmented  
    **resolution**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution  
    **outfile**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with metrics  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **basin** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **demmap** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slumapclean** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer, cleaned (the main output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **cleansize** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units size to be removed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25000*  
    **areamin** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum area (m^2) below which the slope unit is not further segmented  
    **cvmin** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum value of the circular variance (0.0-1.0) below which the slope unit is not further segmented  
    **resolution** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution  
    **outfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with metrics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **basin** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Input basin  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **demmap** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input digital elevation model  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slumapclean** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output Slope Units layer, cleaned (the main output)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **cleansize** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Slope Units size to be removed  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *25000*  
    **areamin** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum area (m^2) below which the slope unit is not further segmented  
    **cvmin** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum value of the circular variance (0.0-1.0) below which the slope unit is not further segmented  
    **resolution** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Resolution  
    **outfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output file with metrics  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.slopeunits.metrics* creates metrics for slope units. Returns output
"areamin, cvmin, v_fin and i_fin" to stdout, optionally writes to a
file.

## EXAMPLE

```sh
r.slopeunits.metrics \
    basin=basin_chk \
    demmap=dem_italia_isolegrandi@su_test \
    slumapclean=su_tmp_cl \
    cleansize=25000 \
    areamin=50000.0 \
    cvmin=0.05 \
    resolution=625 \
    outfile=objf_1.dat
```

## REFERENCES

- Alvioli, M., Marchesini, I., Reichenbach, P., Rossi, M., Ardizzone,
  F., Fiorucci, F., and Guzzetti, F. (2016): Automatic delineation of
  geomorphological slope units with r.slopeunits v1.0 and their
  optimization for landslide susceptibility modeling, Geosci. Model
  Dev., 9, 3975-3991.
  DOI:[10.5194/gmd-9-3975-2016](https://doi.org/10.5194/gmd-9-3975-2016)
- Alvioli, M., Guzzetti, F., & Marchesini, I. (2020): Parameter-free
  delineation of slope units and terrain subdivision of Italy.
  Geomorphology, 358, 107124.
  DOI:[10.1016/j.geomorph.2020.107124](https://doi.org/10.1016/j.geomorph.2020.107124)

## SEE ALSO

*[r.slopeunits.create](r.slopeunits.create.md),
[r.slopeunits.clean](r.slopeunits.clean.md),
[r.slopeunits.optimize](r.slopeunits.optimize.md)*

## AUTHORS

Main authors: Ivan Marchesini, Massimiliano Alvioli, CNR-IRPI  
Carmen Tawalika (translation to python),
[mundialis](https://www.mundialis.de/)

## SOURCE CODE

Available at: [r.slopeunits.metrics source code](https://github.com/OSGeo/grass-addons/tree/grass8/raster/r.slopeunits/r.slopeunits.metrics)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/raster/r.slopeunits/r.slopeunits.metrics))  
Latest change: Wednesday May 07 16:16:50 2025 in commit [8af96b6](https://github.com/OSGeo/grass-addons/commit/8af96b6c1138b2b992213db3bfb2242a3e482331)
