---
name: r.sun.daily.py
description: Runs r.sun for multiple days in loop (mode 2)
keywords: [ raster, solar, sun energy, parallel ]
---

# r.sun.daily.py

Runs r.sun for multiple days in loop (mode 2)

=== "Command line"

    **r.sun.daily.py**
    [**-tpm**]
    **elevation**=*name*
    [**aspect**=*string*]
    [**slope**=*string*]
    [**linke**=*name*]
    [**linke_value**=*float*]
    [**albedo**=*name*]
    [**albedo_value**=*float*]
    [**lat**=*name*]
    [**long**=*name*]
    [**horizon_basename**=*basename*]
    [**horizon_step**=*stepsize*]
    **start_day**=*integer*
    **end_day**=*integer*
    [**day_step**=*integer*]
    [**step**=*float*]
    [**civil_time**=*float*]
    [**beam_rad**=*string*]
    [**diff_rad**=*string*]
    [**refl_rad**=*string*]
    [**glob_rad**=*string*]
    [**insol_time**=*string*]
    [**beam_rad_basename**=*string*]
    [**diff_rad_basename**=*string*]
    [**refl_rad_basename**=*string*]
    [**glob_rad_basename**=*string*]
    [**insol_time_basename**=*string*]
    [**solar_constant**=*float*]
    [**method**=*string*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.sun.daily.py elevation=name start_day=0 end_day=0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.sun.daily.py***",
        **elevation**,
        **aspect**=*None*,
        **slope**=*None*,
        **linke**=*None*,
        **linke_value**=*3.0*,
        **albedo**=*None*,
        **albedo_value**=*0.2*,
        **lat**=*None*,
        **long**=*None*,
        **horizon_basename**=*None*,
        **horizon_step**=*None*,
        **start_day**,
        **end_day**,
        **day_step**=*1*,
        **step**=*0.5*,
        **civil_time**=*None*,
        **beam_rad**=*None*,
        **diff_rad**=*None*,
        **refl_rad**=*None*,
        **glob_rad**=*None*,
        **insol_time**=*None*,
        **beam_rad_basename**=*None*,
        **diff_rad_basename**=*None*,
        **refl_rad_basename**=*None*,
        **glob_rad_basename**=*None*,
        **insol_time_basename**=*None*,
        **solar_constant**=*None*,
        **method**=*"sum"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.sun.daily.py", elevation="name", start_day=0, end_day=0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_sun_daily_py*(**elevation**,
        **aspect**=*None*,
        **slope**=*None*,
        **linke**=*None*,
        **linke_value**=*3.0*,
        **albedo**=*None*,
        **albedo_value**=*0.2*,
        **lat**=*None*,
        **long**=*None*,
        **horizon_basename**=*None*,
        **horizon_step**=*None*,
        **start_day**,
        **end_day**,
        **day_step**=*1*,
        **step**=*0.5*,
        **civil_time**=*None*,
        **beam_rad**=*None*,
        **diff_rad**=*None*,
        **refl_rad**=*None*,
        **glob_rad**=*None*,
        **insol_time**=*None*,
        **beam_rad_basename**=*None*,
        **diff_rad_basename**=*None*,
        **refl_rad_basename**=*None*,
        **glob_rad_basename**=*None*,
        **insol_time_basename**=*None*,
        **solar_constant**=*None*,
        **method**=*"sum"*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_sun_daily_py(elevation="name", start_day=0, end_day=0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input elevation raster map [meters]  
    **aspect**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input aspect map (terrain aspect or azimuth of the solar panel) [decimal degrees]  
    **slope**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input slope raster map (terrain slope or solar panel inclination) [decimal degrees]  
    **linke**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Linke atmospheric turbidity coefficient input raster map [-]  
    **linke_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the Linke atmospheric turbidity coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3.0*  
    **albedo**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the ground albedo coefficient input raster map [-]  
    **albedo_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the ground albedo coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.2*  
    **lat**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing latitudes (if projection undefined) [decimal degrees]  
    **long**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing longitudes (if projection undefined) [decimal degrees]  
    **horizon_basename**=*basename*  
    &nbsp;&nbsp;&nbsp;&nbsp;The horizon information input map basename  
    **horizon_step**=*stepsize*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle step size for multidirectional horizon [degrees]  
    **start_day**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start day (of year) of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    **end_day**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;End day (of year) of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    **day_step**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Run r.sun for every n-th day [days]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time step when computing all-day radiation [decimal hours]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **civil_time**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Civil time zone value, if none, the time will be local solar time  
    **beam_rad**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output beam irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    **diff_rad**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output diffuse irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    **refl_rad**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output ground reflected irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    **glob_rad**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output global (total) irradiance/irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    **insol_time**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output insolation time raster map aggregated for the whole period of time [h]  
    **beam_rad_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output beam irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **diff_rad_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output diffuse irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **refl_rad_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output ground reflected irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **glob_rad_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output global (total) irradiance/irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **insol_time_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output insolation time raster map aggregated for the whole period of time [h]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **solar_constant**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solar constant [W/m^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, r.sun default will be used.  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for daily maps aggregation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, average*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sum*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.sun processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Register created series of output maps into temporal dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Dataset name is the same as the base name for the output series of maps  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not incorporate the shadowing effect of terrain  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use the low-memory version of the program  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input elevation raster map [meters]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input aspect map (terrain aspect or azimuth of the solar panel) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input slope raster map (terrain slope or solar panel inclination) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **linke** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Linke atmospheric turbidity coefficient input raster map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **linke_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the Linke atmospheric turbidity coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3.0*  
    **albedo** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the ground albedo coefficient input raster map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the ground albedo coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.2*  
    **lat** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing latitudes (if projection undefined) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **long** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing longitudes (if projection undefined) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **horizon_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The horizon information input map basename  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *basename*  
    **horizon_step** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle step size for multidirectional horizon [degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *stepsize*  
    **start_day** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start day (of year) of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    **end_day** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;End day (of year) of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    **day_step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Run r.sun for every n-th day [days]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time step when computing all-day radiation [decimal hours]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **civil_time** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Civil time zone value, if none, the time will be local solar time  
    **beam_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output beam irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **diff_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output diffuse irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **refl_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output ground reflected irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **glob_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output global (total) irradiance/irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **insol_time** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output insolation time raster map aggregated for the whole period of time [h]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **beam_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output beam irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **diff_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output diffuse irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **refl_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output ground reflected irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **glob_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output global (total) irradiance/irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **insol_time_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output insolation time raster map aggregated for the whole period of time [h]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **solar_constant** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solar constant [W/m^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, r.sun default will be used.  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for daily maps aggregation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, average*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sum*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.sun processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *p*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register created series of output maps into temporal dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dataset name is the same as the base name for the output series of maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not incorporate the shadowing effect of terrain  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the low-memory version of the program  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input elevation raster map [meters]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input aspect map (terrain aspect or azimuth of the solar panel) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **slope** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input slope raster map (terrain slope or solar panel inclination) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **linke** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Linke atmospheric turbidity coefficient input raster map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **linke_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the Linke atmospheric turbidity coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3.0*  
    **albedo** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the ground albedo coefficient input raster map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the ground albedo coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.2*  
    **lat** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing latitudes (if projection undefined) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **long** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing longitudes (if projection undefined) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **horizon_basename** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The horizon information input map basename  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *basename*  
    **horizon_step** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Angle step size for multidirectional horizon [degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *stepsize*  
    **start_day** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start day (of year) of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    **end_day** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;End day (of year) of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    **day_step** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Run r.sun for every n-th day [days]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time step when computing all-day radiation [decimal hours]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.5*  
    **civil_time** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Civil time zone value, if none, the time will be local solar time  
    **beam_rad** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output beam irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **diff_rad** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output diffuse irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **refl_rad** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output ground reflected irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **glob_rad** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output global (total) irradiance/irradiation raster map aggregated for the whole period of time [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **insol_time** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output insolation time raster map aggregated for the whole period of time [h]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster  
    **beam_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output beam irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **diff_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output diffuse irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **refl_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output ground reflected irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **glob_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output global (total) irradiance/irradiation raster maps [Wh.m-2.day-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **insol_time_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output insolation time raster map aggregated for the whole period of time [h]  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and day number are added to the base name for daily maps  
    **solar_constant** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solar constant [W/m^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, r.sun default will be used.  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method for daily maps aggregation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *sum, average*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sum*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.sun processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*, *p*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register created series of output maps into temporal dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dataset name is the same as the base name for the output series of maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not incorporate the shadowing effect of terrain  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the low-memory version of the program  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.sun.daily* is a convenient script for running r.sun for multiple days
in a loop. It corresponds to mode 2 (aggregation mode, see r.sun [manual
page](https://grass.osgeo.org/grass-stable/manuals/r.sun.html)).

### Output parameters explanation

There are two basic options:

- output series of maps (one for each day): options containing
    basename in their name
- output one map which is an aggregation of the intermediate maps

You can choose any combination of parameters: e.g. total map of diffuse
radiance and series of beam radiance maps. Series of maps are (if flag
*t* is checked) registered to space time raster dataset with relative
time and point time (not interval time). For GRASS 6, only timestamp is
assigned.

## EXAMPLE

```sh
g.region raster=elevation -p
r.sun.daily elevation=elevation start_day=30 end_day=40 \
            beam_rad_basename=beam beam_rad=beam_sum nprocs=4 -t
# show information about newly created space time dataset
t.info beam

# show information about newly created beam_sum raster map
r.info beam
```

## SEE ALSO

*[r.sun](https://grass.osgeo.org/grass-stable/manuals/r.sun.html)  
[r.sun.hourly](r.sun.hourly.md) in Addons*

## AUTHORS

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/),  
Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.sun.daily source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.sun.daily)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.sun.daily))  
Latest change: Monday Nov 24 22:33:44 2025 in commit [0df3f4a](https://github.com/OSGeo/grass-addons/commit/0df3f4a109ebb8a965e35e13bb943299cfc1352c)
