---
name: r.sun.hourly.py
description: Runs r.sun in loop for given time range within one day (mode 1 or 2)
keywords: [ raster, solar, sun energy, parallel ]
---

# r.sun.hourly.py

Runs r.sun in loop for given time range within one day (mode 1 or 2)

=== "Command line"

    **r.sun.hourly.py**
    [**-ctbpm**]
    **elevation**=*string*
    [**aspect**=*string*]
    [**slope**=*string*]
    [**linke**=*name*]
    [**linke_value**=*float*]
    [**albedo**=*name*]
    [**albedo_value**=*float*]
    [**coeff_bh**=*name*]
    [**coeff_bh_strds**=*name*]
    [**coeff_dh**=*name*]
    [**coeff_dh_strds**=*name*]
    [**lat**=*name*]
    [**long**=*name*]
    **mode**=*string*
    **start_time**=*float*
    **end_time**=*float*
    [**time_step**=*float*]
    **day**=*integer*
    **year**=*integer*
    [**civil_time**=*float*]
    [**distance_step**=*float*]
    [**beam_rad_basename**=*string*]
    [**diff_rad_basename**=*string*]
    [**refl_rad_basename**=*string*]
    [**glob_rad_basename**=*string*]
    [**incidout_basename**=*string*]
    [**beam_rad**=*string*]
    [**diff_rad**=*string*]
    [**refl_rad**=*string*]
    [**glob_rad**=*string*]
    [**solar_constant**=*float*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.sun.hourly.py elevation=string mode=mode1 start_time=0.0 end_time=0.0 day=0 year=1900
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.sun.hourly.py***",
        **elevation**,
        **aspect**=*None*,
        **slope**=*None*,
        **linke**=*None*,
        **linke_value**=*3.0*,
        **albedo**=*None*,
        **albedo_value**=*0.2*,
        **coeff_bh**=*None*,
        **coeff_bh_strds**=*None*,
        **coeff_dh**=*None*,
        **coeff_dh_strds**=*None*,
        **lat**=*None*,
        **long**=*None*,
        **mode**=*"mode1"*,
        **start_time**,
        **end_time**,
        **time_step**=*1*,
        **day**,
        **year**=*1900*,
        **civil_time**=*None*,
        **distance_step**=*1.0*,
        **beam_rad_basename**=*None*,
        **diff_rad_basename**=*None*,
        **refl_rad_basename**=*None*,
        **glob_rad_basename**=*None*,
        **incidout_basename**=*None*,
        **beam_rad**=*None*,
        **diff_rad**=*None*,
        **refl_rad**=*None*,
        **glob_rad**=*None*,
        **solar_constant**=*None*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.sun.hourly.py", elevation="string", mode="mode1", start_time=0.0, end_time=0.0, day=0, year=1900)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_sun_hourly_py*(**elevation**,
        **aspect**=*None*,
        **slope**=*None*,
        **linke**=*None*,
        **linke_value**=*3.0*,
        **albedo**=*None*,
        **albedo_value**=*0.2*,
        **coeff_bh**=*None*,
        **coeff_bh_strds**=*None*,
        **coeff_dh**=*None*,
        **coeff_dh_strds**=*None*,
        **lat**=*None*,
        **long**=*None*,
        **mode**=*"mode1"*,
        **start_time**,
        **end_time**,
        **time_step**=*1*,
        **day**,
        **year**=*1900*,
        **civil_time**=*None*,
        **distance_step**=*1.0*,
        **beam_rad_basename**=*None*,
        **diff_rad_basename**=*None*,
        **refl_rad_basename**=*None*,
        **glob_rad_basename**=*None*,
        **incidout_basename**=*None*,
        **beam_rad**=*None*,
        **diff_rad**=*None*,
        **refl_rad**=*None*,
        **glob_rad**=*None*,
        **solar_constant**=*None*,
        **nprocs**=*1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_sun_hourly_py(elevation="string", mode="mode1", start_time=0.0, end_time=0.0, day=0, year=1900)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input elevation raster map [meters]  
    **aspect**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input aspect map (terrain aspect or azimuth of the solar panel) [decimal degrees]  
    **slope**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input slope raster map (terrain slope or solar panel inclination) [decimal degrees]  
    **linke**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Linke atmospheric turbidity coefficient input raster map [-]  
    **linke_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the Linke atmospheric turbidity coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3.0*  
    **albedo**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the ground albedo coefficient input raster map [-]  
    **albedo_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the ground albedo coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.2*  
    **coeff_bh**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky beam radiation coefficient (thick cloud) input raster map [0-1]  
    **coeff_bh_strds**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky beam radiation coefficient (thick cloud) input space-time raster dataset  
    **coeff_dh**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky diffuse radiation coefficient (haze) input raster map [0-1]  
    **coeff_dh_strds**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky diffuse radiation coefficient (haze) input space-time raster dataset  
    **lat**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing latitudes [decimal degrees]  
    **long**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing longitudes [decimal degrees]  
    **mode**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Select r.sun mode to choose between irradiance (mode 1) and irradiation (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mode1, mode2*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mode1*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mode1**: r.sun mode 1 computes irradiance [W.m-2]  
    &nbsp;&nbsp;&nbsp;&nbsp;**mode2**: r.sun mode 2 computes irradiation [Wh.m-2]  
    **start_time**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start time of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Use up to 2 decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    **end_time**=*float* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;End time of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Use up to 2 decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    **time_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time step for running r.sun [decimal hours]  
    &nbsp;&nbsp;&nbsp;&nbsp;Use up to 2 decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **day**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;No. of day of the year  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    **year**=*integer* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Year used for map registration into temporal dataset or r.timestamp  
    &nbsp;&nbsp;&nbsp;&nbsp;This value is not used in r.sun calculations  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1900-9999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1900*  
    **civil_time**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Civil time zone value, if none, the time will be local solar time  
    **distance_step**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling distance step coefficient (0.5-1.5)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **beam_rad_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output beam irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **diff_rad_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output diffuse irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **refl_rad_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output ground reflected irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **glob_rad_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output global (total) irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **incidout_basename**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output incidence angle raster maps (mode 1 only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **beam_rad**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output beam irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **diff_rad**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output diffuse irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **refl_rad**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output ground reflected irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **glob_rad**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output global (total) irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **solar_constant**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solar constant [W/m^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, r.sun default will be used.  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.sun processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Compute cumulative raster maps of irradiation (only with mode 2)  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Register created series of output maps into temporal dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Dataset name is the same as the base name for the output series of maps  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create binary rasters instead of irradiance rasters  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not incorporate the shadowing effect of terrain  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use the low-memory version of the program  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input elevation raster map [meters]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **aspect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input aspect map (terrain aspect or azimuth of the solar panel) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input slope raster map (terrain slope or solar panel inclination) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **linke** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Linke atmospheric turbidity coefficient input raster map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **linke_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the Linke atmospheric turbidity coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3.0*  
    **albedo** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the ground albedo coefficient input raster map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the ground albedo coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.2*  
    **coeff_bh** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky beam radiation coefficient (thick cloud) input raster map [0-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coeff_bh_strds** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky beam radiation coefficient (thick cloud) input space-time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **coeff_dh** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky diffuse radiation coefficient (haze) input raster map [0-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coeff_dh_strds** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky diffuse radiation coefficient (haze) input space-time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **lat** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing latitudes [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **long** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing longitudes [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **mode** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select r.sun mode to choose between irradiance (mode 1) and irradiation (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mode1, mode2*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mode1**: r.sun mode 1 computes irradiance [W.m-2]  
    &nbsp;&nbsp;&nbsp;&nbsp;**mode2**: r.sun mode 2 computes irradiation [Wh.m-2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mode1*  
    **start_time** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start time of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Use up to 2 decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    **end_time** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;End time of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Use up to 2 decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    **time_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time step for running r.sun [decimal hours]  
    &nbsp;&nbsp;&nbsp;&nbsp;Use up to 2 decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **day** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;No. of day of the year  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    **year** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Year used for map registration into temporal dataset or r.timestamp  
    &nbsp;&nbsp;&nbsp;&nbsp;This value is not used in r.sun calculations  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1900-9999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1900*  
    **civil_time** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Civil time zone value, if none, the time will be local solar time  
    **distance_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling distance step coefficient (0.5-1.5)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **beam_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output beam irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **diff_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output diffuse irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **refl_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output ground reflected irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **glob_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output global (total) irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **incidout_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output incidence angle raster maps (mode 1 only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **beam_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output beam irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **diff_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output diffuse irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **refl_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output ground reflected irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **glob_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output global (total) irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **solar_constant** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solar constant [W/m^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, r.sun default will be used.  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.sun processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *t*, *b*, *p*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute cumulative raster maps of irradiation (only with mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register created series of output maps into temporal dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dataset name is the same as the base name for the output series of maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create binary rasters instead of irradiance rasters  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not incorporate the shadowing effect of terrain  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the low-memory version of the program  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input elevation raster map [meters]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **aspect** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input aspect map (terrain aspect or azimuth of the solar panel) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **slope** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input slope raster map (terrain slope or solar panel inclination) [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **linke** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the Linke atmospheric turbidity coefficient input raster map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **linke_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the Linke atmospheric turbidity coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3.0*  
    **albedo** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the ground albedo coefficient input raster map [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **albedo_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;A single value of the ground albedo coefficient [-]  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0.0-1.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.2*  
    **coeff_bh** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky beam radiation coefficient (thick cloud) input raster map [0-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coeff_bh_strds** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky beam radiation coefficient (thick cloud) input space-time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **coeff_dh** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky diffuse radiation coefficient (haze) input raster map [0-1]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **coeff_dh_strds** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of real-sky diffuse radiation coefficient (haze) input space-time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **lat** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing latitudes [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **long** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map containing longitudes [decimal degrees]  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **mode** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Select r.sun mode to choose between irradiance (mode 1) and irradiation (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *mode1, mode2*  
    &nbsp;&nbsp;&nbsp;&nbsp;**mode1**: r.sun mode 1 computes irradiance [W.m-2]  
    &nbsp;&nbsp;&nbsp;&nbsp;**mode2**: r.sun mode 2 computes irradiation [Wh.m-2]  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *mode1*  
    **start_time** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Start time of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Use up to 2 decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    **end_time** : float, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;End time of interval  
    &nbsp;&nbsp;&nbsp;&nbsp;Use up to 2 decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    **time_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time step for running r.sun [decimal hours]  
    &nbsp;&nbsp;&nbsp;&nbsp;Use up to 2 decimal places  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-24*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **day** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;No. of day of the year  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-365*  
    **year** : int, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Year used for map registration into temporal dataset or r.timestamp  
    &nbsp;&nbsp;&nbsp;&nbsp;This value is not used in r.sun calculations  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1900-9999*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1900*  
    **civil_time** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Civil time zone value, if none, the time will be local solar time  
    **distance_step** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling distance step coefficient (0.5-1.5)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **beam_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output beam irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **diff_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output diffuse irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **refl_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output ground reflected irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **glob_rad_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output global (total) irradiance [W.m-2] (mode 1) or irradiation raster map [Wh.m-2] (mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **incidout_basename** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Base name for output incidence angle raster maps (mode 1 only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Underscore and time are added to the base name for each map  
    **beam_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output beam irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **diff_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output diffuse irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **refl_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output ground reflected irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **glob_rad** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output global (total) irradiation raster map [Wh.m-2] (mode 2) integrated over specified time period  
    **solar_constant** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Solar constant [W/m^2]  
    &nbsp;&nbsp;&nbsp;&nbsp;If not specified, r.sun default will be used.  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of r.sun processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1-*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *t*, *b*, *p*, *m*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Compute cumulative raster maps of irradiation (only with mode 2)  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register created series of output maps into temporal dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dataset name is the same as the base name for the output series of maps  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create binary rasters instead of irradiance rasters  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not incorporate the shadowing effect of terrain  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the low-memory version of the program  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.sun.hourly* is a convenient script for running r.sun for multiple
times in a loop. It allows to run r.sun in mode 1 to create maps of
instantaneous solar irradiance. Alternatively, it allows to integrate
solar irradiance maps over specified time period to compute solar
irradiation (mode 2). See r.sun [manual
page](https://grass.osgeo.org/grass-stable/manuals/r.sun.html) for more
information.

### Output parameters explanation

There are three basic types of output:

In mode 1, if one of options **beam\_rad\_basename**,
**diff\_rad\_basename** **refl\_rad\_basename**,
**glob\_rad\_basename**, and **incidout\_basename** is selected, it will
compute a time series of irradiance maps. Optionally, **b** flag will
convert them to binary rasters representing shaded areas. Using this
flag in combination with **beam\_rad\_basename** is a convenient way to
determine if there is direct sunlight or not at a certain place and
time. Series of maps are (if flag **t** is checked) registered to space
time raster dataset with absolute time and point time (not interval
time). Option **year** has to be specified so that the raster maps can
be registered to space time dataset or assigned a timestamp. The reason
is that it is not possible to assign time without date.

In mode 2, a series of solar irradiation maps will be computed with
units Wh/m2. This is done by multiplying an instantaneous irradiance
raster computed in the middle of the specified intervals by time step.
For example, if **start\_time** is 8, **end\_time** is 10 and
**time\_step** is 0.5, the irradiation rasters will be computed for
times 8:15, 8:45, 9:15 and 9:45.

If flag **c** is selected it will accumulate the irradiation values,
meaning the last raster represents all solar irradiation during the
period.

When any of output options **beam\_rad**, **diff\_rad** **refl\_rad**
and **glob\_rad** are specified, irradiation rasters are summed over the
specified period (mode 2 only).

### Real-sky radiation parameters

Real-sky radiation parameters (see
[r.sun](https://grass.osgeo.org/grass-stable/manuals/r.sun.html)) can be
input as raster map (**coeff\_bh** and **coeff\_dh**), or space-time
raster dataset (**coeff\_bh\_strds** and **coeff\_dh\_strds**) to
account for time-varying conditions. The space-time raster dataset
(strds) needs to be interval-based (i.e. have start and end time, see
[t.register](https://grass.osgeo.org/grass-stable/manuals/t.register.html),
for more details).

## EXAMPLES

Calculate for current region the beam irradiance (direct radiation) for
DOY 355 in 2014 from 8am to 3pm:

```sh
g.region -p
r.sun.hourly elevation=elevation start_time=8 end_time=15 \
              day=355 year=2014 beam_rad_basename=beam nprocs=4 -t
# show information about newly created space time dataset
t.info beam

# show raster maps registered in beam temporal dataset
t.rast.list beam
```

Calculate beam irradiation during day and also cumulative irradiation,
use different steps:

```sh
g.region raster=elevation res=100 -pa
r.sun.hourly elevation=elevation year=2019 day=100  start=8 end=16 time_step=0.333 beam_rad_basename=beam_m2_step_short mode=mode2 nprocs=4 -t
r.sun.hourly elevation=elevation year=2019 day=100  start=8 end=16 time_step=0.333 beam_rad_basename=beam_m2_step_short_cum mode=mode2 nprocs=4 -tc
r.sun.hourly elevation=elevation year=2019 day=100  start=8 end=16 time_step=1 beam_rad_basename=beam_m2_step_long mode=mode2 nprocs=4 -t
r.sun.hourly elevation=elevation year=2019 day=100  start=8 end=16 time_step=1 beam_rad_basename=beam_m2_step_long_cum mode=mode2 nprocs=4 -tc
g.gui.tplot strds=beam_m2_step_short,beam_m2_step_long,beam_m2_step_short_cum,beam_m2_step_long_cum coordinates=636919,220431
```

[![image-alt](r_sun_hourly.png)](r_sun_hourly.png)

## NOTE

Beam irradiance binary raster maps can be displayed as semitransparent
over other map layers or module
[*r.null*](https://grass.osgeo.org/grass-stable/manuals/r.null.html) can
be used to set one of the values (either shade or sunlight) as NULL.

## SEE ALSO

*[r.sun](https://grass.osgeo.org/grass-stable/manuals/r.sun.html),
[r.sun.daily](r.sun.daily.md) in Addons*

## AUTHORS

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/),  
Anna Petrasova, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [r.sun.hourly source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.sun.hourly)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.sun.hourly))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
