---
name: r.support
description: Allows creation and/or modification of raster map layer support files.
keywords: [ raster, metadata ]
---

# r.support

Allows creation and/or modification of raster map layer support files.

=== "Command line"

    **r.support**
    [**-bsnd**]
    **map**=*name*
    [**title**=*phrase*]
    [**history**=*phrase*]
    [**units**=*string*]
    [**vdatum**=*string*]
    [**source1**=*phrase*]
    [**source2**=*phrase*]
    [**description**=*phrase*]
    [**raster**=*string*]
    [**loadhistory**=*name*]
    [**savehistory**=*name*]
    [**semantic_label**=*phrase*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.support map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.support***",
        **map**,
        **title**=*None*,
        **history**=*None*,
        **units**=*None*,
        **vdatum**=*None*,
        **source1**=*None*,
        **source2**=*None*,
        **description**=*None*,
        **raster**=*None*,
        **loadhistory**=*None*,
        **savehistory**=*None*,
        **semantic_label**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.support", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_support*(**map**,
        **title**=*None*,
        **history**=*None*,
        **units**=*None*,
        **vdatum**=*None*,
        **source1**=*None*,
        **source2**=*None*,
        **description**=*None*,
        **raster**=*None*,
        **loadhistory**=*None*,
        **savehistory**=*None*,
        **semantic_label**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_support(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    **title**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    **history**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to append to the next line of the map's metadata file  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for map data units  
    **vdatum**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for map vertical datum  
    **source1**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 1  
    **source2**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 2  
    **description**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data description or keyword(s)  
    **raster**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy category table  
    **loadhistory**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file from which to load history  
    **savehistory**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file in which to save history  
    **semantic_label**=*phrase*  
    &nbsp;&nbsp;&nbsp;&nbsp;Semantic label e.g. S2_8A  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Delete the semantic label  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Update statistics (histogram, range)  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create/reset the null file  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Delete the null file  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **history** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to append to the next line of the map's metadata file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for map data units  
    **vdatum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for map vertical datum  
    **source1** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **source2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 2  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data description or keyword(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **raster** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy category table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **loadhistory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file from which to load history  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **savehistory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file in which to save history  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **semantic_label** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Semantic label e.g. S2_8A  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *s*, *n*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete the semantic label  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update statistics (histogram, range)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create/reset the null file  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete the null file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **title** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Title for resultant raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **history** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to append to the next line of the map's metadata file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for map data units  
    **vdatum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for map vertical datum  
    **source1** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 1  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **source2** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data source, line 2  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **description** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text to use for data description or keyword(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **raster** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map from which to copy category table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster  
    **loadhistory** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file from which to load history  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **savehistory** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Text file in which to save history  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    **semantic_label** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Semantic label e.g. S2_8A  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *phrase*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *s*, *n*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete the semantic label  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update statistics (histogram, range)  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create/reset the null file  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Delete the null file  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**r.support** allows the user to create and/or edit raster map support
information. Editing of raster map color tables, category labels,
header, history, semantic label elements and title is supported.
Category labels can also be copied from another raster map.

### Raster semantic labels and band management

Raster semantic label concept is similar to dimension name in other GIS
and remote sensing applications. Most common usage will be assigning a
remote sensing platform sensor band identifier to the raster map
metadata, although any identifier is supported (see
[i.band.library](i.band.library.md)). Raster semantic label is suggested
to work with imagery classification tools.

## EXAMPLES

These examples are based on the North Carolina dataset, more
specifically the *landuse* raster map. Copy the landuse map to the
current mapset

```sh
g.copy raster=landuse,my_landuse
```

### Update statistics

```sh
r.support -s map=my_landuse
```

### Update Title

```sh
r.support map=my_landuse title="Landuse copied"
```

### Append to History Metadata

```sh
r.support map=my_landuse history="Copied from PERMANENT mapset"
```

### Update Units Display

```sh
r.support map=my_landuse units=meter
```

### Set semantic label

Note: landuse map doesn't confirm to CORINE specification. This is an
example only.

```sh
r.support map=my_landuse semantic_label=CORINE_LULC
```

## NOTES

If metadata options such as **title** or **history** are given the
module will run non-interactively. If only the map name is given
*r.support* will run interactively within a terminal shell and the user
with be prompted for input.

Freeform metadata information is stored in a "`hist`" file which may be
appended to by using the **history** option. Currently this is limited
to 50 lines of text with a maximum line length of 78 characters. Any
input larger than this will be wrapped to the next line. All other
metadata strings available as standard options are limited to 79
characters.

## SEE ALSO

*[i.band.library](i.band.library.md), [r.category](r.category.md),
[r.describe](r.describe.md), [r.info](r.info.md), [r.null](r.null.md),
[r.region](r.region.md), [r.report](r.report.md),
[r.semantic.label](r.semantic.label.md), [r.timestamp](r.timestamp.md)*

## AUTHORS

Micharl Shapiro, CERL: Original author  
[Brad Douglas](MAILTO:rez@touchofmadness.com): GRASS 6 Port  
M. Hamish Bowman: command line enhancements  
Markus Neteler: category copy from other map  
Maris Nartiss: semantic label management

## SOURCE CODE

Available at: [r.support source code](https://github.com/OSGeo/grass/tree/main/raster/r.support)
([history](https://github.com/OSGeo/grass/commits/main/raster/r.support))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
