---
name: r.terrain.texture.py
description: Unsupervised nested-means algorithm for terrain classification
keywords: [ raster, terrain, classification ]
---

# r.terrain.texture.py

Unsupervised nested-means algorithm for terrain classification

=== "Command line"

    **r.terrain.texture.py**
    **elevation**=*name*
    [**slope**=*name*]
    [**flat_thres**=*float*]
    [**curv_thres**=*float*]
    [**filter_size**=*integer*]
    [**counting_size**=*integer*]
    [**classes**=*integer*]
    **texture**=*name*
    **convexity**=*name*
    **concavity**=*name*
    [**features**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.terrain.texture.py elevation=name texture=name convexity=name concavity=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.terrain.texture.py***",
        **elevation**,
        **slope**=*None*,
        **flat_thres**=*1*,
        **curv_thres**=*0*,
        **filter_size**=*3*,
        **counting_size**=*21*,
        **classes**=*8*,
        **texture**,
        **convexity**,
        **concavity**,
        **features**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.terrain.texture.py", elevation="name", texture="name", convexity="name", concavity="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_terrain_texture_py*(**elevation**,
        **slope**=*None*,
        **flat_thres**=*1*,
        **curv_thres**=*0*,
        **filter_size**=*3*,
        **counting_size**=*21*,
        **classes**=*8*,
        **texture**,
        **convexity**,
        **concavity**,
        **features**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_terrain_texture_py(elevation="name", texture="name", convexity="name", concavity="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation raster:  
    **slope**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input slope raster:  
    **flat_thres**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height threshold for pit and peak detection:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **curv_thres**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Curvature threshold for convexity and concavity detection:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **filter_size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of smoothing filter window:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **counting_size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of counting window:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *21*  
    **classes**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes in nested terrain classification:  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *8, 12, 16*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **texture**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain texture:  
    **convexity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain convexity:  
    **concavity**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain concavity:  
    **features**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain classification:  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation raster:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input slope raster:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flat_thres** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height threshold for pit and peak detection:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **curv_thres** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Curvature threshold for convexity and concavity detection:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **filter_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of smoothing filter window:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **counting_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of counting window:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *21*  
    **classes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes in nested terrain classification:  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *8, 12, 16*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **texture** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain texture:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **convexity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain convexity:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **concavity** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain concavity:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **features** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain classification:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input elevation raster:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slope** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input slope raster:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **flat_thres** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height threshold for pit and peak detection:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **curv_thres** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Curvature threshold for convexity and concavity detection:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **filter_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of smoothing filter window:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **counting_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of counting window:  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *21*  
    **classes** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of classes in nested terrain classification:  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *8, 12, 16*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *8*  
    **texture** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain texture:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **convexity** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain convexity:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **concavity** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain concavity:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **features** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output terrain classification:  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.terrain.texture* calculates the nested-means terrain classification
of Iwahashi and Pike (2007). This classification procedure relies on
three surface-form metrics consisting of: (a) terrain surface texture
which is represented by the spatial frequency of peaks and pits; (b)
surface-form convexity and concavity which are represented by the
spatial frequency of convex/concave locations; and (c) slope-gradient
which should be supplied by *r.slope.aspect* or *r.param.scale*. These
metrics are combined using the mean of each variable as a dividing
measure into a 8, 12 or 16 category classification of the topography.

The calculation follows the description in Iwahashi and Pike (2007).
Terrain surface texture is calculated by smoothing the input *elevation*
using a median filter over a neighborhood specified by the
*filter\_size* parameter (in pixels). Second, pits and peaks are
extracted based on the difference between the smoothed DEM and the
original terrain surface. By default the algorithm uses a threshold of 1
(\> 1 m elevation difference) to identify pits and peaks. This threshold
is set in the *flat\_thres* parameter. The spatial frequency of pits and
peaks is then calculated using a Gaussian resampling filter over a
neighborhood size specified in the *counting\_filter* parameter (default
is 21 x 21 pixels, as per Iwahashi and Pike (2007).

Surface-form convexity and concavity are calculated by first using a
Laplacian filter approximating the second derivative of elevation to
measure surface curvature. The Laplacian filter neighborhood size is set
by the *filter\_size* parameter (in pixels). This yields positive values
in convex-upward areas, and negative values in concave areas, and zero
on planar areas. Pixels are identified as either convex or concave when
their values exceed the *curv\_thres*. Similarly to terrain surface
texture, the spatial frequency of these locations is then calculated to
yield terrain surface convexity and concavity measures.

Optionally, these surface-form metrics along with slope-gradient can be
used to produce a nested-means classification of the topography. Each
class is estimated based on whether the pixels values for each variable
exceed the mean of that variable. The classification sequence follows:

![image-alt](flowchart.png)

A single iteration of this decision tree is completed for the 8-category
classification. However for the 12 category classification, classes 1-4
remain but pixels that otherwise relate to classes 5-8 are passed to a
second iteration of the decision tree, except that the mean of the
gentler half of the area is used as the decision threshold, to produce 8
additional classes. Similarly for the 16 category classification, pixels
that otherwise relate to classes 8-12 are passed onto a third iteration
of the decision tree, except that the mean of the gentler quarter of the
area is used as the decision threshold. This iterative subdivision of
terrain properties acts to progressively partition the terrain into more
gentle terrain features.

## NOTES

In the original algorithm description, SRTM data was smoothed using a
fixed 3 x 3 size median filter and the spatial frequency of extracted
features were measured over a 21 x 21 sized counting window. However, a
larger smoothing filter size (\~15 x 15) is often required to extract
meaningful terrain features from higher resolution topographic data such
as derived from LiDAR, and therefore both *filter\_size* and
*counting\_size* parameters were exposed in the GRASS implementation.
Further, if a large filter size is used then the counting window size
should be increased accordingly.

## EXAMPLE

Here we are going to use the GRASS GIS sample North Carolina data set as
a basis to perform a terrain classification. First we set the
computational region to the elev\_state\_500m dem, and then generate
shaded relief (for visualization) and slope-gradient maps:

```sh
g.region raster=elev_state_500m@PERMANENT
r.relief input=elev_state_500m@PERMANENT output=Hillshade_state_500m altitude=45 azimuth=315
r.slope.aspect elevation=elev_state_500m@PERMANENT slope=slope_state_500m
```

Then we produce the terrain classification:

```sh
r.terrain.texture elevation=elev_state_500m@PERMANENT slope=slope_state_500m@PERMANENT \
  texture=texture_state_500m convexity=convexity_state_500m concavity=concavity_state_500m \
  features=classification_state_500m
```

Terrain surface texture:

![image-alt](texture_example.png)

Surface-form convexity:

![image-alt](convexity_example.png)

8-category terrain classification:

![image-alt](classification_example.png)

## REFERENCES

Iwahashi, J., and Pike, R.J. 2007. Automated classifications of
topography from DEMs by an unsupervised nested-means algorithm and a
three-part geometric signature. Geomorphology 86, 409-440.

## AUTHOR

Steven Pawley

## SOURCE CODE

Available at: [r.terrain.texture source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.terrain.texture)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.terrain.texture))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
