---
name: r.valley.bottom.py
description: Calculation of Multi-resolution Valley Bottom Flatness (MrVBF) index
keywords: [ raster, terrain ]
---

# r.valley.bottom.py

Calculation of Multi-resolution Valley Bottom Flatness (MrVBF) index

=== "Command line"

    **r.valley.bottom.py**
    [**-s**]
    **elevation**=*name*
    **mrvbf**=*name*
    [**mrrtf**=*name*]
    [**t_slope**=*string*]
    [**t_pctl_v**=*string*]
    [**t_pctl_r**=*string*]
    [**t_vf**=*string*]
    [**t_rf**=*string*]
    [**p_slope**=*string*]
    [**p_pctl**=*string*]
    [**min_cells**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.valley.bottom.py elevation=name mrvbf=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.valley.bottom.py***",
        **elevation**,
        **mrvbf**,
        **mrrtf**=*None*,
        **t_slope**=*"16"*,
        **t_pctl_v**=*"0.4"*,
        **t_pctl_r**=*"0.3"*,
        **t_vf**=*"0.3"*,
        **t_rf**=*"0.35"*,
        **p_slope**=*"4"*,
        **p_pctl**=*"3"*,
        **min_cells**=*"2"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.valley.bottom.py", elevation="name", mrvbf="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_valley_bottom_py*(**elevation**,
        **mrvbf**,
        **mrrtf**=*None*,
        **t_slope**=*"16"*,
        **t_pctl_v**=*"0.4"*,
        **t_pctl_r**=*"0.3"*,
        **t_vf**=*"0.3"*,
        **t_rf**=*"0.35"*,
        **p_slope**=*"4"*,
        **p_pctl**=*"3"*,
        **min_cells**=*"2"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_valley_bottom_py(elevation="name", mrvbf="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    **mrvbf**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output MRVBF raster map  
    **mrrtf**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output MRRTF raster map  
    **t_slope**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial Threshold for Slope  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *16*  
    **t_pctl_v**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Elevation Percentile (Lowness)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **t_pctl_r**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Elevation Percentile (Upness)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **t_vf**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Valley Bottom Flatness  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **t_rf**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Ridge Top Flatness  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.35*  
    **p_slope**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shape Parameter (p) for Slope  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **p_pctl**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shape Parameter (p) for Elevation Percentile  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **min_cells**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells in generalized DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use square moving window instead of circular moving window  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **mrvbf** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output MRVBF raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mrrtf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output MRRTF raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **t_slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial Threshold for Slope  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *16*  
    **t_pctl_v** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Elevation Percentile (Lowness)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **t_pctl_r** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Elevation Percentile (Upness)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **t_vf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Valley Bottom Flatness  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **t_rf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Ridge Top Flatness  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.35*  
    **p_slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shape Parameter (p) for Slope  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **p_pctl** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shape Parameter (p) for Elevation Percentile  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **min_cells** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells in generalized DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use square moving window instead of circular moving window  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of elevation raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **mrvbf** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output MRVBF raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **mrrtf** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of output MRRTF raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **t_slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Initial Threshold for Slope  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *16*  
    **t_pctl_v** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Elevation Percentile (Lowness)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.4*  
    **t_pctl_r** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Elevation Percentile (Upness)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **t_vf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Valley Bottom Flatness  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **t_rf** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Threshold (t) for transformation of Ridge Top Flatness  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.35*  
    **p_slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shape Parameter (p) for Slope  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4*  
    **p_pctl** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shape Parameter (p) for Elevation Percentile  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **min_cells** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Minimum number of cells in generalized DEM  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *s*  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use square moving window instead of circular moving window  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.valley.bottom* calculates the Multi-resolution Valley Bottom Flatness
(MRVBF) index (Gallant and Dowling, 2003). The MRVBF index assesses the
flatness and lowness of terrain over multiple scales and DEM resolutions
in order to identify valley bottoms, which represent areas that are flat
across multiple scales, and remain low relative to the surrounding
relief at coarser scales. The algorithm uses a sigmoid/logistic
transform to rescale terrain slope angles and elevation percentile into
a 0 to 1 range, and then combines these results across multiple levels
of DEM smoothing and coarser grid resolutions. Although the resulting
index represents a continuous value, values \< 0.5 do not generally
represent valley bottoms, values from 0.5 to 1.5 represent the steepest
resolvable valley bottoms, and flatter/larger valley bottoms are
represented by values \> 1.5.

## NOTES

The user must specify the input **elevation** raster map as a required
input. The output is given by the **mrvbf** argument. Optionally, the
complementary Multiresolution Index of Ridge Top Flatness can be
calculated by specifying the **mrrtf** argument. In addition, there are
several parameters than can be used to change the behaviour of the
argument, although note that in this case the results and their
interpretation will differ from what was envisaged in the original
paper. However, in practice, this is often required especially for
high-resolution DEMs. The arguments are:

- *t\_slope* represents the initial threshold (t) for slope angle (in
    percentage). This specifies the slope angle that corresponds to a
    (logit) rescaled flatness value of 0.5. This means that slope angles
    lower than t\_slope will be considered as flat areas, and slope
    angles higher than t\_slope will be represented as non-flat areas.
    t\_slope should be set based on the resolution of the input
    elevation dataset, and the algorithm was designed using with a 25 m
    DEM having a t\_slope value of 16. Otherwise the t\_slope value
    should by halved for every resolution step (a step consisting of a 3
    x coarsening of resolution) above a 25 m resolution. For example, a
    75 m DEM (3 x 25 m, 1 step) should have a t\_slope value of 8, and a
    250 m DEM (\~2 resolution steps) should have a t\_slope value of 4.
- *p\_slope* represents the shape parameter (p) for the sigmoid
    transformation. It defines the slope of the sigmoid function, i.e.
    how quickly changes in slope angle scale to being flat vs. non-flat
    areas. High p\_slope values will cause a slow, smooth transition
    from flat areas to steep areas. Low p\_slope values will result in
    much more rapid transitions that highlight more local vs. regional
    relief.
- *t\_pctl\_v* represents the threshold for transformation of
    elevation percentile to evaluate lowness. This represents the
    threshold value for elevation percentile by which values less than
    this value will represent low areas. Elevation percentile represents
    the ratio of pixels of lower elevation relative to the total number
    of pixels in a moving-window neighborhood. Similarly *t\_pctl\_r* is
    the equivalent 'upness' threshold for the MRRTF index.
- *p\_pctl* represents the shape parameter (p) for the transformation
    of the elevation percentile. It defines the slope of the sigmoid
    function and governs how quickly transitions occur from low areas to
    upland areas.
- *t\_vf* and *t\_rf* represent the thresholds for identifying valley
    bottoms (or ridge tops). Larger values indicate increasing valley
    bottom characteristics, with values \< 0.5 considered not to be in
    valley bottoms.

The calculation of elevation percentile by default is performed using a
circular window. With the **-s** flag a square moving window is used in
calculations.

In practice, the user does not usually need to alter the
threshold-related parameters other than t\_slope. However, changing the
shape parameters can be useful for to emphasize more local vs. more
regional variations in relief. The degree of generalization can also be
adjusted by the *min\_cells* argument. The default value of 1 is
equivalent to generalizing the input **elevation** raster to 100 percent
of its original cell size. To reduce processing time, or focus the
results on more local-relief, try increasing the number of min\_cells.

## EXAMPLE

Here we are going to use the GRASS GIS sample North Carolina data set as
a basis to calculate the MRVBF index.

```sh
  # align region to DEM
  g.region -a raster=el_D782_6m

  # run r.valley.bottom
  r.valley.bottom elevation=el_D782_6m mrvbf=mrvbf_el_D782_6m t_slope=40 p_slope=3 p_pctl=2

  # set colors
  r.colors map=mrvbf_el_D782_6m color=bcyr -n

  # display over a shaded relief map
  r.relief input=el_D782_6m output=hs_D782_6m altitude=45 azimuth=315 zscale=4 scale=1
  r.shade shade=hs_D782_6m color=mrvbf_el_D782_6m output=mrvbf_shade
  d.rast map=mrvbf_shade
 
```

![image-alt](r_valley_bottom_mrvbf.png)

## SEE ALSO

*[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),
[r.slope.aspect](https://grass.osgeo.org/grass-stable/manuals/r.slope.aspect.html)*

## REFERENCES

J.C. Gallant & T.I. Dowling 2003. A multiresolution index of valley
bottom flatness for mapping depositional areas. Water Resources
Research, Vol. 39, No. 12, 1347. doi:10.1029/2002WR001426

## AUTHORS

Helmut Kudrnovsky & Steven Pawley

## SOURCE CODE

Available at: [r.valley.bottom source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.valley.bottom)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.valley.bottom))  
Latest change: Saturday Oct 18 14:02:41 2025 in commit [5cb968f](https://github.com/OSGeo/grass-addons/commit/5cb968f55a99751846ac9af8070831e07b9710e5)
