---
name: r.vector.ruggedness.py
description: Vector Ruggedness Measure
keywords: [ raster, surface, terrain, ruggedness, parallel ]
---

# r.vector.ruggedness.py

Vector Ruggedness Measure

=== "Command line"

    **r.vector.ruggedness.py**
    **elevation**=*name* [,*name*,...]
    [**size**=*integer* [,*integer*,...]]
    **output**=*name* [,*name*,...]
    [**slope**=*name*]
    [**aspect**=*name*]
    [**exponent**=*float*]
    [**nprocs**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r.vector.ruggedness.py elevation=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r.vector.ruggedness.py***",
        **elevation**,
        **size**=*3*,
        **output**,
        **slope**=*None*,
        **aspect**=*None*,
        **exponent**=*0*,
        **nprocs**=*-1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r.vector.ruggedness.py", elevation="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r_vector_ruggedness_py*(**elevation**,
        **size**=*3*,
        **output**,
        **slope**=*None*,
        **aspect**=*None*,
        **exponent**=*0*,
        **nprocs**=*-1*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r_vector_ruggedness_py(elevation="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **elevation**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;DEM Raster Input  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS raster elevation map  
    **size**=*integer* [,*integer*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighbourhood  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighbourhood to calculate the vector dispersion over. Multiple sizes are accepted to more efficiently calculate the VRM over different scales.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **output**=*name* [,*name*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector Ruggedness Measure Output  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map(s)  
    **slope**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional slope raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional slope raster map. If not supplied, then a slope map will be calculated internally.  
    **aspect**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional aspect raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional aspect raster map. If not supplied, then an aspect map will be calculated internally.  
    **exponent**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent for distance weighting (zero is equal weights)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum number of cores to use for multiprocessing  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum number of cores to use for multiprocessing. -1 uses all cores, -2 uses n_cores-1 etc.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **elevation** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;DEM Raster Input  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS raster elevation map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **size** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighbourhood  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighbourhood to calculate the vector dispersion over. Multiple sizes are accepted to more efficiently calculate the VRM over different scales.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **output** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector Ruggedness Measure Output  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional slope raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional slope raster map. If not supplied, then a slope map will be calculated internally.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional aspect raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional aspect raster map. If not supplied, then an aspect map will be calculated internally.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **exponent** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent for distance weighting (zero is equal weights)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum number of cores to use for multiprocessing  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum number of cores to use for multiprocessing. -1 uses all cores, -2 uses n_cores-1 etc.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **elevation** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;DEM Raster Input  
    &nbsp;&nbsp;&nbsp;&nbsp;GRASS raster elevation map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **size** : int | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighbourhood  
    &nbsp;&nbsp;&nbsp;&nbsp;Size of neighbourhood to calculate the vector dispersion over. Multiple sizes are accepted to more efficiently calculate the VRM over different scales.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **output** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector Ruggedness Measure Output  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **slope** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional slope raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional slope raster map. If not supplied, then a slope map will be calculated internally.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **aspect** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional aspect raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional aspect raster map. If not supplied, then an aspect map will be calculated internally.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **exponent** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Exponent for distance weighting (zero is equal weights)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum number of cores to use for multiprocessing  
    &nbsp;&nbsp;&nbsp;&nbsp;The maximum number of cores to use for multiprocessing. -1 uses all cores, -2 uses n_cores-1 etc.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r.vector.ruggedness* represents a measurement of terrain ruggedness
based on the methodology conceived by Sappington et al. (2007). The
measure is calculated by decomposing slope and aspect into 3-dimensional
vectors, and calculating the resultant vector magnitude within a
user-specified moving window size using *r.neighbors*. The user can
specify neighborhood size to measure ruggedness across larger scales.
Neighborhood operations are performed using a rectangular window shape.

## MULTI-SCALE CALCULATION

The *r.vector.ruggedness* tool provides an efficient approach of
calculating the Vector Ruggedness Measure over multiple window sizes.
The *size* argument accepts multiple answers (as a comma separated
list), which will cause the tool to reuse the same slope, aspect and
vector calculations, and apply them to the neighborhood operations that
calculate the vector magnitudes. By default, both the calculation of the
vectors and the vector magnitudes, including over different window sizes
is performed in parallel using all available cores. To restrict parallel
processing, the *nprocs* argument can be changed to use a smaller number
of processing cores. When multiple sizes are used, the *output* raster
name is appended with the window size. Optionally, pre-calculated slope
and aspect maps (in degrees) can be used in the *slope* and *aspect*
arguments to save computational time if the maps are already available.

## NOTES

This script was adapted from the original Sappington et al. (2007)
script.

## EXAMPLE

The examples are to be executed using the GRASS GIS sample North
Carolina data set. To calculate the Vector Ruggedness Measure using a
single neighborhood size:

```sh
    r.vector.ruggedness elevation=elevation size=3 output=vrm
```

For efficient calculations of the Vector Ruggedness Measure over
multiple neighborhood sizes, the slope, aspect and their x, y, z vectors
will be reused during the calculation. The output name will be appended
with the neighborhood size in order to identify the output maps:

```sh
    r.vector.ruggedness elevation=elevation size=3,5,7,9,11 output=vrm
```

## REFERENCES

Sappington, J.M., K.M. Longshore, and D.B. Thomson. 2007. Quantifying
Landscape Ruggedness for Animal Habitat Analysis: A case Study Using
Bighorn Sheep in the Mojave Desert. Journal of Wildlife Management.
71(5): 1419 -1426.

## SEE ALSO

*[r.mapcalc](https://grass.osgeo.org/grass-stable/manuals/r.mapcalc.html),
[r.neighbors](https://grass.osgeo.org/grass-stable/manuals/r.neighbors.html)*

## AUTHOR

Steven Pawley

## SOURCE CODE

Available at: [r.vector.ruggedness source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/raster/r.vector.ruggedness)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/raster/r.vector.ruggedness))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
