---
name: r3.mask
description: Establishes the current working 3D raster mask.
keywords: [ raster3d, mask, null data, no-data, voxel ]
---

# r3.mask

Establishes the current working 3D raster mask.

=== "Command line"

    **r3.mask**
    **map**=*string*
    [**maskvalues**=*val[-val]* [,*val[-val]*,...]]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.mask map=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.mask***",
        **map**,
        **maskvalues**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.mask", map="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_mask*(**map**,
        **maskvalues**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_mask(map="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map with reference values  
    **maskvalues**=*val[-val]* [,*val[-val]*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be masked out  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map with reference values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **maskvalues** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be masked out  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *val[-val]*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map with reference values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **maskvalues** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be masked out  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *val[-val]*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.mask* facilitates the creation of a raster3d "MASK" map to control
raster3d operations. The raster3d *map* is used as the reference map.
Cells in the mask are marked as "mask out" if the corresponding cell in
*map* contains a value in the range specified with *maskvalues*.

## NOTES

Before a new 3D-mask can be created the existing mask has to be removed
with *g.remove*.

## SEE ALSO

*[g.remove](g.remove.md)*

## AUTHORS

Roman Waupotitsch, Michael Shapiro, Helena Mitasova, Bill Brown, Lubos
Mitas, Jaro Hofierka

## SOURCE CODE

Available at: [r3.mask source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.mask)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.mask))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
