---
name: r3.null
description: Explicitly create the 3D NULL-value bitmap file.
keywords: [ raster3d, map management, null data, no-data, voxel ]
---

# r3.null

Explicitly create the 3D NULL-value bitmap file.

=== "Command line"

    **r3.null**
    **map**=*string*
    [**setnull**=*val[-val]* [,*val[-val]*,...]]
    [**null**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    r3.null map=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***r3.null***",
        **map**,
        **setnull**=*None*,
        **null**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("r3.null", map="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.r3_null*(**map**,
        **setnull**=*None*,
        **null**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.r3_null(map="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map for which to modify null values  
    **setnull**=*val[-val]* [,*val[-val]*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    **null**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map for which to modify null values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **setnull** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *val[-val]*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map for which to modify null values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3d-raster  
    **setnull** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of cell values to be set to NULL  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *val[-val]*  
    **null** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The value to replace the null value by  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*r3.null* modifies the NULL values of a 3D raster map.

## SEE ALSO

*[r.null](r.null.md)*

## AUTHORS

Roman Waupotitsch, Michael Shapiro, Helena Mitasova, Bill Brown, Lubos
Mitas, Jaro Hofierka

## SOURCE CODE

Available at: [r3.null source code](https://github.com/OSGeo/grass/tree/main/raster3d/r3.null)
([history](https://github.com/OSGeo/grass/commits/main/raster3d/r3.null))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
