---
name: t.copy.py
description: Creates a copy of a space time raster dataset.
keywords: [ temporal, copy, time ]
---

# t.copy.py

Creates a copy of a space time raster dataset.

=== "Command line"

    **t.copy.py**
    [**-c**]
    **input**=*name*
    [**type**=*name*]
    **output**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.copy.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.copy.py***",
        **input**,
        **type**=*"strds"*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.copy.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_copy_py*(**input**,
        **type**=*"strds"*,
        **output**,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_copy_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    **type**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds,  str3ds,  stvds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time dataset  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Also copy maps of the space-time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;By default the old maps are only registered in the new dataset.  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds,  str3ds,  stvds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stds, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also copy maps of the space-time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default the old maps are only registered in the new dataset.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, stds, *name*  
    **type** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Type of the input space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *strds,  str3ds,  stvds*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *strds*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the output space time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, stds, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Also copy maps of the space-time dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;By default the old maps are only registered in the new dataset.  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

The purpose of **t.copy** is to create a copy of a space time dataset.
The new space time dataset will be located in the current mapset,
whereas the old space time dataset can be located in a different mapset
as long as this mapset is in the search path.

If the *-c* flag is given, the maps of the old space time dataset will
also be copied to the current mapset, otherwise the original maps will
be simply registered in the temporal database. The new copies will have
the same name as the old maps.

## NOTES

A fully qualified name for the input space-time dataset is only required
if space-time datasets with the same name exist in different mapsets.

## EXAMPLE

In the North Carolina sample dataset with the separately available
mapset *modis_lst* included, copy the space-time raster dataset
*LST_Day_monthly@modis_lst* to the current mapset *user1*:

```sh
g.mapsets mapset=modis_lst operation=add
t.copy input=LST_Day_monthly@modis_lst type=strds output=LST_Day_monthly
```

## SEE ALSO

*[t.rast.extract](t.rast.extract.md),
[t.rast3d.extract](t.rast3d.extract.md),
[t.vect.extract](t.vect.extract.md), [t.info](t.info.md)*

## AUTHOR

Markus Metz, [mundialis](https://www.mundialis.de)

## SOURCE CODE

Available at: [t.copy source code](https://github.com/OSGeo/grass/tree/main/temporal/t.copy)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.copy))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
