---
name: t.rast.accdetect.py
description: Detects accumulation patterns in temporally accumulated space time raster datasets created by t.rast.accumulate.
keywords: [ temporal, accumulation, raster, time ]
---

# t.rast.accdetect.py

Detects accumulation patterns in temporally accumulated space time raster datasets created by t.rast.accumulate.

=== "Command line"

    **t.rast.accdetect.py**
    [**-nr**]
    **input**=*name*
    [**minimum**=*name*]
    [**maximum**=*name*]
    **occurrence**=*name*
    [**indicator**=*name*]
    **start**=*string*
    [**stop**=*string*]
    **cycle**=*string*
    [**offset**=*string*]
    **basename**=*string*
    [**suffix**=*string*]
    [**range**=*min,max*]
    [**staend**=*start,intermediate,end*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.accdetect.py input=name occurrence=name start=string cycle=string basename=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.accdetect.py***",
        **input**,
        **minimum**=*None*,
        **maximum**=*None*,
        **occurrence**,
        **indicator**=*None*,
        **start**,
        **stop**=*None*,
        **cycle**,
        **offset**=*None*,
        **basename**,
        **suffix**=*"gran"*,
        **range**=*None*,
        **staend**=*"1,2,3"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.accdetect.py", input="name", occurrence="name", start="string", cycle="string", basename="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_accdetect_py*(**input**,
        **minimum**=*None*,
        **maximum**=*None*,
        **occurrence**,
        **indicator**=*None*,
        **start**,
        **stop**=*None*,
        **cycle**,
        **offset**=*None*,
        **basename**,
        **suffix**=*"gran"*,
        **range**=*None*,
        **staend**=*"1,2,3"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_accdetect_py(input="name", occurrence="name", start="string", cycle="string", basename="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **minimum**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input space time raster dataset that specifies the minimum values to detect the accumulation pattern  
    **maximum**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input space time raster dataset that specifies the maximum values to detect the accumulation pattern  
    **occurrence**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The output space time raster dataset that stores the occurrence of the accumulation pattern using the provided data range  
    **indicator**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;The output space time raster dataset that stores the indication of the start, intermediate and end of the specified data range  
    **start**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal starting point to begin the accumulation, eg '2001-01-01'  
    **stop**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal date to stop the accumulation, eg '2009-01-01'  
    **cycle**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal cycle to restart the accumulation, eg '12 months'  
    **offset**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal offset to the begin of the next cycle, eg '6 months'  
    **basename**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'count' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **range**=*min,max*  
    &nbsp;&nbsp;&nbsp;&nbsp;The minimum and maximum value of the occurrence of accumulated values, these values will be used if the min/max space time raster datasets are not specified  
    **staend**=*start,intermediate,end*  
    &nbsp;&nbsp;&nbsp;&nbsp;The user defined values that indicate start, intermediate and end status in the indicator output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1,2,3*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Register empty maps in the output space time raster dataset, otherwise they will be deleted  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reverse time direction in cyclic accumulation  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **minimum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input space time raster dataset that specifies the minimum values to detect the accumulation pattern  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **maximum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input space time raster dataset that specifies the maximum values to detect the accumulation pattern  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **occurrence** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The output space time raster dataset that stores the occurrence of the accumulation pattern using the provided data range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **indicator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The output space time raster dataset that stores the indication of the start, intermediate and end of the specified data range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **start** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal starting point to begin the accumulation, eg '2001-01-01'  
    **stop** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal date to stop the accumulation, eg '2009-01-01'  
    **cycle** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal cycle to restart the accumulation, eg '12 months'  
    **offset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal offset to the begin of the next cycle, eg '6 months'  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'count' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The minimum and maximum value of the occurrence of accumulated values, these values will be used if the min/max space time raster datasets are not specified  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **staend** : tuple[int, int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The user defined values that indicate start, intermediate and end status in the indicator output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *start,intermediate,end*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1,2,3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register empty maps in the output space time raster dataset, otherwise they will be deleted  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse time direction in cyclic accumulation  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **minimum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input space time raster dataset that specifies the minimum values to detect the accumulation pattern  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **maximum** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input space time raster dataset that specifies the maximum values to detect the accumulation pattern  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **occurrence** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The output space time raster dataset that stores the occurrence of the accumulation pattern using the provided data range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **indicator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The output space time raster dataset that stores the indication of the start, intermediate and end of the specified data range  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, strds, *name*  
    **start** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal starting point to begin the accumulation, eg '2001-01-01'  
    **stop** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal date to stop the accumulation, eg '2009-01-01'  
    **cycle** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal cycle to restart the accumulation, eg '12 months'  
    **offset** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The temporal offset to the begin of the next cycle, eg '6 months'  
    **basename** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Basename of the new generated output maps  
    &nbsp;&nbsp;&nbsp;&nbsp;A numerical suffix separated by an underscore will be attached to create a unique identifier  
    **suffix** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Suffix to add at basename: set 'gran' for granularity, 'time' for the full time format, 'count' for numerical suffix with a specific number of digits (default %05)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gran*  
    **range** : tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The minimum and maximum value of the occurrence of accumulated values, these values will be used if the min/max space time raster datasets are not specified  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *min,max*  
    **staend** : tuple[int, int, int] | list[int] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The user defined values that indicate start, intermediate and end status in the indicator output space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *start,intermediate,end*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1,2,3*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Register empty maps in the output space time raster dataset, otherwise they will be deleted  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse time direction in cyclic accumulation  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

**t.rast.accdetect** is designed to detect accumulation pattern in
temporally accumulated space time raster datasets created by
[t.rast.accumulate](t.rast.accumulate.md). This module's input is a
space time raster dataset resulting from a
[t.rast.accumulate](t.rast.accumulate.md) run.

The **start** time and the **end** time of the pattern detection process
must be set, eg. **start="2000-03-01" end="2011-01-01"**. The **start**
and **end** time do not need to be the same as for the accumulation run
that produced the input space time raster dataset. In addition a
**cycle**, eg. "8 months", can be specified, that defines after which
time interval the accumulation pattern detection process restarts. The
**offset** option specifies the time that should be skipped between two
cycles, eg. "4 months". The **cycle** and **offset** options must be
exactly the same that were used in the accumulation process that
generated the input space time raster dataset, otherwise the
accumulation pattern detection will produce wrong results.

The **minimum** and **maximum** values for the pattern detection process
can be set either by using space time raster datasets or by using fixed
values for all raster cells and time steps.

Using space time raster datasets allows specifying minimum and maximum
values for each raster cell and each time step. For example, we want to
detect the germination (minimum value) and harvesting (maximum value)
dates for different crops in Germany using the growing-degree-day (GDD)
method for several years. Different crops may grow in different raster
cells and change with time because of crop rotation. Hence we need to
specify different GDD germination/harvesting (minimum/maximum) values
for different raster cells and different years.

The raster maps that specify the minimum and maximum values of the
actual granule will be detected using the following temporal relations:
equals, during, overlaps, overlapped and contains. First, all maps with
time stamps *equal* to the current granule of the input STRDS will be
detected, the first minimum map and the first maximum map that are found
will be used as range definitions. If no equal maps are found, then maps
with a temporal *during* relation will be detected, then maps that
temporally *overlap* the actual granules and finally, maps that have a
temporal *contain* relation will be detected. If no maps are found or
minimum/maximum STRDS are not set, then the **range** option is used,
eg. **range=480,730**.

The **base** name of of the generated maps must always be set.

This module produces two output space time raster datasets: occurrence
and indicator. The **occurrence** output STRDS stores the time in days
from the beginning of a given cycle for each raster cell and time step
that has a value within the minimum and maximum definition. These values
can be used to compute the duration of the recognized accumulation
pattern. The **indicator** output STRDS uses three integer values to
mark raster cells as beginning, intermediate state or end of an
accumulation pattern. By default, the module uses 1 to indicate the
start, 2 for the intermediate state and 3 to mark the end of the
accumulation pattern in a cycle. These default values can be changed
using the **staend** option.

## EXAMPLE

Please have a look at the [t.rast.accumulate](t.rast.accumulate.md)
example.

## SEE ALSO

*[t.rast.accumulate](t.rast.accumulate.md),
[t.rast.aggregate](t.rast.aggregate.md),
[t.rast.mapcalc](t.rast.mapcalc.md), [t.info](t.info.md),
[r.series.accumulate](r.series.accumulate.md), [g.region](g.region.md)*

## AUTHOR

Sören Gebbert, Thünen Institute of Climate-Smart Agriculture

## SOURCE CODE

Available at: [t.rast.accdetect source code](https://github.com/OSGeo/grass/tree/main/temporal/t.rast.accdetect)
([history](https://github.com/OSGeo/grass/commits/main/temporal/t.rast.accdetect))  
Latest change: Thursday Dec 18 07:11:47 2025 in commit [cf870a5](https://github.com/OSGeo/grass/commit/cf870a5e49fd2643a55de543467edf5c2e61d640)
