---
name: t.rast.what.aggr.py
description: Sample a space time raster dataset at specific vector point map returning aggregate values and write the output to stdout or to attribute table
keywords: [ temporal, sampling, raster, time, parallel ]
---

# t.rast.what.aggr.py

Sample a space time raster dataset at specific vector point map returning aggregate values and write the output to stdout or to attribute table

=== "Command line"

    **t.rast.what.aggr.py**
    [**-uac**]
    **input**=*name*
    **strds**=*name*
    [**date_column**=*name*]
    [**date**=*string*]
    [**final_date**=*string*]
    [**output**=*name*]
    [**final_date_column**=*name* [,*name*,...]]
    [**columns**=*name* [,*name*,...]]
    [**granularity**=*string*]
    **method**=*string* [,*string*,...]
    [**separator**=*character*]
    [**nprocs**=*integer*]
    [**date_format**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.rast.what.aggr.py input=name strds=name method=average
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***t.rast.what.aggr.py***",
        **input**,
        **strds**,
        **date_column**=*None*,
        **date**=*None*,
        **final_date**=*None*,
        **output**=*"-"*,
        **final_date_column**=*None*,
        **columns**=*None*,
        **granularity**=*None*,
        **method**=*"average"*,
        **separator**=*"pipe"*,
        **nprocs**=*1*,
        **date_format**=*"%Y-%m-%d"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("t.rast.what.aggr.py", input="name", strds="name", method="average")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_rast_what_aggr_py*(**input**,
        **strds**,
        **date_column**=*None*,
        **date**=*None*,
        **final_date**=*None*,
        **output**=*"-"*,
        **final_date_column**=*None*,
        **columns**=*None*,
        **granularity**=*None*,
        **method**=*"average"*,
        **separator**=*"pipe"*,
        **nprocs**=*1*,
        **date_format**=*"%Y-%m-%d"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_rast_what_aggr_py(input="name", strds="name", method="average")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **strds**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    **date_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column containing starting dates for aggregates  
    **date**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The starting date for aggregation  
    **final_date**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The end date for aggregation, requires date option  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output file or "-" in case stdout should be used  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **final_date_column**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with ending date for aggregation, requires date_columns option  
    **columns**=*name* [,*name*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s)  
    **granularity**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregation granularity, format absolute time "x years, x months, x weeks, x days, x hours, x minutes, x seconds" or an integer value for relative time  
    **method**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation to be performed on the raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, stddev, sum, variance, quart1, quart3, perc90, quantile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *average*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **nprocs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **date_format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tha date format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *%Y-%m-%d*  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Update attribute table of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Instead of creating a new vector map update the attribute table with value(s)  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Query STRDS with dates after the 'date' or 'column_date' value  
    &nbsp;&nbsp;&nbsp;&nbsp;Usually t.rast.what.aggr aggregate values before the selected dates, using a flag it will query values after the selected dates  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create new columns, it combine STRDS and method names  
    &nbsp;&nbsp;&nbsp;&nbsp;Create new columns for the selected methods, it combine STRDS and method names  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **strds** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **date_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column containing starting dates for aggregates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The starting date for aggregation  
    **final_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The end date for aggregation, requires date option  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output file or "-" in case stdout should be used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **final_date_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with ending date for aggregation, requires date_columns option  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **granularity** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregation granularity, format absolute time "x years, x months, x weeks, x days, x hours, x minutes, x seconds" or an integer value for relative time  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation to be performed on the raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, stddev, sum, variance, quart1, quart3, perc90, quantile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *average*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **date_format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tha date format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *%Y-%m-%d*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*, *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update attribute table of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Instead of creating a new vector map update the attribute table with value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Query STRDS with dates after the 'date' or 'column_date' value  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Usually t.rast.what.aggr aggregate values before the selected dates, using a flag it will query values after the selected dates  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create new columns, it combine STRDS and method names  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create new columns for the selected methods, it combine STRDS and method names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **strds** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the input space time raster dataset  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, strds, *name*  
    **date_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of the column containing starting dates for aggregates  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The starting date for aggregation  
    **final_date** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The end date for aggregation, requires date option  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for the output file or "-" in case stdout should be used  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **final_date_column** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Column with ending date for aggregation, requires date_columns option  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **columns** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **granularity** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregation granularity, format absolute time "x years, x months, x weeks, x days, x hours, x minutes, x seconds" or an integer value for relative time  
    **method** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Aggregate operation to be performed on the raster maps  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *average, median, mode, minimum, maximum, stddev, sum, variance, quart1, quart3, perc90, quantile*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *average*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *pipe*  
    **nprocs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of processes to run in parallel  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **date_format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tha date format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *%Y-%m-%d*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*, *a*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Update attribute table of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Instead of creating a new vector map update the attribute table with value(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Query STRDS with dates after the 'date' or 'column_date' value  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Usually t.rast.what.aggr aggregate values before the selected dates, using a flag it will query values after the selected dates  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create new columns, it combine STRDS and method names  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create new columns for the selected methods, it combine STRDS and method names  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.rast.what.aggr* samples a space time raster dataset at points from a
vector map and returns aggregated values either printing them to stdout
or updating the attribute table. A single date for the aggregation can
be provided with the option *date* or alteratively, different dates for
each point in the vector map can be passed through the option
*date\_column*. Either *date* or *date\_column* must be provided. The
aggregation is done by default backwards in time starting from the date
provided and with the *granularity* set. Alternatively, the data can be
aggregated forward in time by using the *a* flag. By default, the output
is printed to stdout. To write the output into the attribute table of
the vector map, *u* flag must be set and the target column should be
created beforehand (See
[v.db.addcolumn](https://grass.osgeo.org/grass-stable/manuals/v.db.addcolumn.html)).
Alternatively, *c* flag creates the columns using the name of the space
time raster dataset (strds) and the method(s) as column name(s).

## NOTES

For *method=mode* the module requires
[scipy](https://www.scipy.org/scipylib/index.html) library to be
installed.

## EXAMPLES

Average NDVI for the previous 2 months starting from 2015-05-01 (i.e.:
date="2015-05-01") for all points in the vector map.

```sh
t.rast.what.aggr input=GR_GSOM_stations strds=ndvi_16_5600m \
 date=2015-05-01 granularity="2 months"

1|2015-05-01|4480.0
2|2015-05-01|5852.66666667
3|2015-05-01|5683.33333333
4|2015-05-01|4985.0
```

Average, minimum and maximum NDVI for the previous 2 months starting
from 2015-05-01 (i.e.: date="2015-05-01") for all points in the vector
map.

```sh
t.rast.what.aggr input=GR_GSOM_stations strds=ndvi_16_5600m \
 date=2015-05-01 granularity="2 months" method=average,minimum,maximum

1|2015-05-01|4480.0|4371.0|4545.0
2|2015-05-01|5852.66666667|5618.0|6249.0
3|2015-05-01|5683.33333333|5530.0|5955.0
4|2015-05-01|4985.0|4820.0|5169.0
```

Average NDVI for the previous 2 months, starting from different dates
for each point in the vector map (i.e.: providing date\_column).

```sh
t.rast.what.aggr input=GR_GSOM_stations strds=ndvi_16_5600m \
 granularity="2 months" date_column=fechas

1|2015-01-01|*
2|2015-02-01|5254.0
3|2015-03-01|6023.66666667
4|2015-04-01|4399.66666667
```

Minimum and maximum NDVI for the previous 2 months, starting from
different dates for each point in the vector map (i.e.: providing
date\_column).

```sh
t.rast.what.aggr input=GR_GSOM_stations strds=ndvi_16_5600m \
 date_column=fechas granularity="2 months" \
 method=minimum,maximum

1|2015-01-01|*|*
2|2015-02-01|5254.0|5254.0
3|2015-03-01|5944.0|6119.0
4|2015-04-01|3786.0|4820.0
```

Minimum and maximum NDVI for the 2 months after (i.e.: set -a flag) the
date provided in *date\_column*. Note that in this example the first
point gets populated.

```sh
t.rast.what.aggr -a input=GR_GSOM_stations date_column=fechas \
 granularity="2 months" strds=ndvi_16_5600m method=minimum,maximum

1|2015-01-01|3497.0|4280.0
2|2015-02-01|4801.0|6249.0
3|2015-03-01|5530.0|5955.0
4|2015-04-01|5169.0|6390.0
```

Minimum and maximum NDVI for the previous 2 months, starting from
different dates for each point in the vector map (i.e.: providing
date\_column) and write the output into the vector atrribute's table.

```sh
# create columns
v.db.addcolumn map=GR_GSOM_stations column="ndvi_min double precision"
v.db.addcolumn map=GR_GSOM_stations column="ndvi_max double precision"

# write the aggregated values to the attribute table
t.rast.what.aggr -u input=GR_GSOM_stations strds=ndvi_16_5600m \
 date_column=fechas granularity="2 months" columns=ndvi_min,ndvi_max \
 method=minimum,maximum

# check the result
v.db.select map=GR_GSOM_stations

cat|station|name|long|lat|fechas|ndvi_min|ndvi_max
1|GRE00105244|LAMIA|22.4|38.9|2015-01-01||
2|GRE00105246|TANAGRA|23.53|38.32|2015-02-01|5254|5254
3|GRE00105240|CHIOS|26.13|38.33|2015-03-01|5944|6119
4|GRE00105242|FLORINA|21.4|40.78|2015-04-01|3786|4820
```

Automatically create the columns and populate them with the aggregated
values.

```sh
t.rast.what.aggr -u -c input=GR_GSOM_stations date_column=fechas \
 granularity="2 months" strds=ndvi_16_5600m method=minimum,maximum

v.db.select map=GR_GSOM_stations
cat|station|name|long|lat|fechas|ndvi_mean|ndvi_max|ndvi_16_5600m_minimum|ndvi_16_5600m_maximum
1|GRE00105244|LAMIA|22.4|38.9|2015-01-01||||
2|GRE00105246|TANAGRA|23.53|38.32|2015-02-01|5254|5254|5254|5254
3|GRE00105240|CHIOS|26.13|38.33|2015-03-01|5944|6119|5944|6119
4|GRE00105242|FLORINA|21.4|40.78|2015-04-01|3786|4820|3786|4820
```

## SEE ALSO

*[r.what](https://grass.osgeo.org/grass-stable/manuals/r.what.html),
[t.rast.what](https://grass.osgeo.org/grass-stable/manuals/t.rast.what.html),
[t.rast.aggregate](https://grass.osgeo.org/grass-stable/manuals/t.rast.aggregate.html)*

[GRASS GIS Wiki: temporal data
processing](https://grasswiki.osgeo.org/wiki/Temporal_data_processing)

## AUTHORS

Luca Delucchi  
Documentation by Veronica Andreo

## SOURCE CODE

Available at: [t.rast.what.aggr source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/temporal/t.rast.what.aggr)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/temporal/t.rast.what.aggr))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
