---
name: t.stac.collection.py
description: Get STAC API collection metadata
keywords: [ temporal, STAC, collection, metadata ]
---

# t.stac.collection.py

Get STAC API collection metadata

=== "Command line"

    **t.stac.collection.py**
    [**-bp**]
    **url**=*string*
    **collection_id**=*string*
    [**request_method**=*string*]
    [**settings**=*name*]
    [**format**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    t.stac.collection.py url=string collection_id=string
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***t.stac.collection.py***",
        **url**,
        **collection_id**,
        **request_method**=*"POST"*,
        **settings**=*None*,
        **format**=*"json"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("t.stac.collection.py", url="string", collection_id="string", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.t_stac_collection_py*(**url**,
        **collection_id**,
        **request_method**=*"POST"*,
        **settings**=*None*,
        **format**=*"json"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.t_stac_collection_py(url="string", collection_id="string", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;STAC API Client URL (examples at https://stacspec.org/en/about/datasets/)  
    **collection_id**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Collection ID  
    **request_method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;The HTTP method to use when making a request to the service.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GET, POST*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *POST*  
    **settings**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *json*  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Return basic information only  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Pretty print the JSON output  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;STAC API Client URL (examples at https://stacspec.org/en/about/datasets/)  
    **collection_id** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Collection ID  
    **request_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The HTTP method to use when making a request to the service.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GET, POST*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *POST*  
    **settings** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *json*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return basic information only  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pretty print the JSON output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;STAC API Client URL (examples at https://stacspec.org/en/about/datasets/)  
    **collection_id** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Collection ID  
    **request_method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The HTTP method to use when making a request to the service.  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *GET, POST*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *POST*  
    **settings** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full path to settings file (user, password)  
    &nbsp;&nbsp;&nbsp;&nbsp;'-' for standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *json, plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *json*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *b*, *p*  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return basic information only  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Pretty print the JSON output  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*t.stac.collection* is a tool for exploring SpatioTemporal Asset Catalog
(STAC) collection metadata. The tool is based on the [PySTAC\_Client
(0.8)](https://pystac-client.readthedocs.io/en/stable/) library and
allows you to search items in a STAC Catalog. The search can be done by
specifying the item ID, collection ID, datatime or by using a search
query. The full list of search parameters and documentation can be found
at [PySTAC\_Client
ItemSearch](https://pystac-client.readthedocs.io/en/stable/api.html#item-search).

## NOTES

The *t.stac.item* tool is part of the
[t.stac](https://grass.osgeo.org/grass-stable/manuals/t.stac.html)
temporal data processing framework. The tool requries that the data
provider has implement the STAC API and conforms to *Item Search*
specification.

## REQUIREMENTS

- [PySTAC
    (1.10.x)](https://pystac.readthedocs.io/en/stable/installation.html)
- [PySTAC\_Client
    (0.8)](https://pystac-client.readthedocs.io/en/stable/)
- tqdm (4.66.x)
- numpy (1.26.x)

## EXAMPLES

### Get the item metadata from a STAC API

```sh
    t.stac.catalog url="https://earth-search.aws.element84.com/v1/"
    t.stac.collection url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a"
    t.stac.item -i url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a" item_id="S2B_36QWD_20220301_0_L2A"
```

### Get the asset metadata from a STAC API

```sh
    t.stac.catalog url="https://earth-search.aws.element84.com/v1/"
    t.stac.collection url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a"
    t.stac.item -a url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a" item_id="S2B_36QWD_20220301_0_L2A"
```

### Dpwnload the asset from a STAC API

```sh
    t.stac.catalog url="https://earth-search.aws.element84.com/v1/"
    t.stac.collection url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a"
    t.stac.item -d url="https://earth-search.aws.element84.com/v1/" collection_id="sentinel-2-l2a" item_id="S2B_36QWD_20220301_0_L2A"
```

GRASS Jupyter Notebooks can be used to visualize the catalog metadata.

```python
    from grass import gs
    catalog = gs.parse_command('t.stac.catalog', url="https://earth-search.aws.element84.com/v1/")

    print(catalog)

    # Output
    {'conformsTo': ['https://api.stacspec.org/v1.0.0/core',
                'https://api.stacspec.org/v1.0.0/collections',
                'https://api.stacspec.org/v1.0.0/ogcapi-features',
                'https://api.stacspec.org/v1.0.0/item-search',
                'https://api.stacspec.org/v1.0.0/ogcapi-features#fields',
                'https://api.stacspec.org/v1.0.0/ogcapi-features#sort',
                'https://api.stacspec.org/v1.0.0/ogcapi-features#query',
                'https://api.stacspec.org/v1.0.0/item-search#fields',
                'https://api.stacspec.org/v1.0.0/item-search#sort',
                'https://api.stacspec.org/v1.0.0/item-search#query',
                'https://api.stacspec.org/v0.3.0/aggregation',
                'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core',
                'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/oas30',
                'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson'],
 'description': 'A STAC API of public datasets on AWS',
 'id': 'earth-search-aws',
 'stac_version': '1.0.0',
 'title': 'Earth Search by Element 84',
 'type': 'Catalog'}
```

### STAC Catalog plain text metadata

```sh
t.stac.catalog url=https://earth-search.aws.element84.com/v1/ format=plain

# Output
    Client Id: earth-search-aws
    Client Title: Earth Search by Element 84
    Client Description: A STAC API of public datasets on AWS
    Client STAC Extensions: []
    Client Extra Fields: {'type': 'Catalog', 'conformsTo': ['https://api.stacspec.org/v1.0.0/core', 'https://api.stacspec.org/v1.0.0/collections', 'https://api.stacspec.org/v1.0.0/ogcapi-features', 'https://api.stacspec.org/v1.0.0/item-search', 'https://api.stacspec.org/v1.0.0/ogcapi-features#fields', 'https://api.stacspec.org/v1.0.0/ogcapi-features#sort', 'https://api.stacspec.org/v1.0.0/ogcapi-features#query', 'https://api.stacspec.org/v1.0.0/item-search#fields', 'https://api.stacspec.org/v1.0.0/item-search#sort', 'https://api.stacspec.org/v1.0.0/item-search#query', 'https://api.stacspec.org/v0.3.0/aggregation', 'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core', 'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/oas30', 'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson']}
    Client catalog_type: ABSOLUTE_PUBLISHED
    ---------------------------------------------------------------------------
    Collections: 9
    sentinel-2-pre-c1-l2a: Sentinel-2 Pre-Collection 1 Level-2A
    Sentinel-2 Pre-Collection 1 Level-2A (baseline < 05.00), with data and metadata matching collection sentinel-2-c1-l2a
    Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2015-06-27T10:25:31.456000Z', None]]}}
    License: proprietary
    ---------------------------------------------------------------------------
    cop-dem-glo-30: Copernicus DEM GLO-30
    The Copernicus DEM is a Digital Surface Model (DSM) which represents the surface of the Earth including buildings, infrastructure and vegetation. GLO-30 Public provides limited worldwide coverage at 30 meters because a small subset of tiles covering specific countries are not yet released to the public by the Copernicus Programme.
    Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2021-04-22T00:00:00Z', '2021-04-22T00:00:00Z']]}}
    License: proprietary
    ---------------------------------------------------------------------------
    naip: NAIP: National Agriculture Imagery Program
    The [National Agriculture Imagery Program](https://www.fsa.usda.gov/programs-and-services/aerial-photography/imagery-programs/naip-imagery/) (NAIP) provides U.S.-wide, high-resolution aerial imagery, with four spectral bands (R, G, B, IR).  NAIP is administered by the [Aerial Field Photography Office](https://www.fsa.usda.gov/programs-and-services/aerial-photography/) (AFPO) within the [US Department of Agriculture](https://www.usda.gov/) (USDA).  Data are captured at least once every three years for each state.  This dataset represents NAIP data from 2010-present, in [cloud-optimized GeoTIFF](https://www.cogeo.org/) format.
    Extent: {'spatial': {'bbox': [[-160, 17, -67, 50]]}, 'temporal': {'interval': [['2010-01-01T00:00:00Z', '2022-12-31T00:00:00Z']]}}
    License: proprietary
    ---------------------------------------------------------------------------
    cop-dem-glo-90: Copernicus DEM GLO-90
    The Copernicus DEM is a Digital Surface Model (DSM) which represents the surface of the Earth including buildings, infrastructure and vegetation. GLO-90 provides worldwide coverage at 90 meters.
    Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2021-04-22T00:00:00Z', '2021-04-22T00:00:00Z']]}}
    License: proprietary
    ---------------------------------------------------------------------------
    landsat-c2-l2: Landsat Collection 2 Level-2
    Atmospherically corrected global Landsat Collection 2 Level-2 data from the Thematic Mapper (TM) onboard Landsat 4 and 5, the Enhanced Thematic Mapper Plus (ETM+) onboard Landsat 7, and the Operational Land Imager (OLI) and Thermal Infrared Sensor (TIRS) onboard Landsat 8 and 9.
    Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['1982-08-22T00:00:00Z', None]]}}
    License: proprietary
    ---------------------------------------------------------------------------
    sentinel-2-l2a: Sentinel-2 Level-2A
    Global Sentinel-2 data from the Multispectral Instrument (MSI) onboard Sentinel-2
    Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2015-06-27T10:25:31.456000Z', None]]}}
    License: proprietary
    ---------------------------------------------------------------------------
    sentinel-2-l1c: Sentinel-2 Level-1C
    Global Sentinel-2 data from the Multispectral Instrument (MSI) onboard Sentinel-2
    Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2015-06-27T10:25:31.456000Z', None]]}}
    License: proprietary
    ---------------------------------------------------------------------------
    sentinel-2-c1-l2a: Sentinel-2 Collection 1 Level-2A
    Sentinel-2 Collection 1 Level-2A, data from the Multispectral Instrument (MSI) onboard Sentinel-2
    Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2015-06-27T10:25:31.456000Z', None]]}}
    License: proprietary
    ---------------------------------------------------------------------------
    sentinel-1-grd: Sentinel-1 Level-1C Ground Range Detected (GRD)
    Sentinel-1 is a pair of Synthetic Aperture Radar (SAR) imaging satellites launched in 2014 and 2016 by the European Space Agency (ESA). Their 6 day revisit cycle and ability to observe through clouds makes this dataset perfect for sea and land monitoring, emergency response due to environmental disasters, and economic applications. This dataset represents the global Sentinel-1 GRD archive, from beginning to the present, converted to cloud-optimized GeoTIFF format.
    Extent: {'spatial': {'bbox': [[-180, -90, 180, 90]]}, 'temporal': {'interval': [['2014-10-10T00:28:21Z', None]]}}
    License: proprietary
    ---------------------------------------------------------------------------
```

### Basic STAC catalog metadata

```sh
    t.stac.catalog url=https://earth-search.aws.element84.com/v1/ format=plain -b

    # Output
    Client Id: earth-search-aws
    Client Title: Earth Search by Element 84
    Client Description: A STAC API of public datasets on AWS
    Client STAC Extensions: []
    Client Extra Fields: {'type': 'Catalog', 'conformsTo': ['https://api.stacspec.org/v1.0.0/core', 'https://api.stacspec.org/v1.0.0/collections', 'https://api.stacspec.org/v1.0.0/ogcapi-features', 'https://api.stacspec.org/v1.0.0/item-search', 'https://api.stacspec.org/v1.0.0/ogcapi-features#fields', 'https://api.stacspec.org/v1.0.0/ogcapi-features#sort', 'https://api.stacspec.org/v1.0.0/ogcapi-features#query', 'https://api.stacspec.org/v1.0.0/item-search#fields', 'https://api.stacspec.org/v1.0.0/item-search#sort', 'https://api.stacspec.org/v1.0.0/item-search#query', 'https://api.stacspec.org/v0.3.0/aggregation', 'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/core', 'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/oas30', 'http://www.opengis.net/spec/ogcapi-features-1/1.0/conf/geojson']}
    Client catalog_type: ABSOLUTE_PUBLISHED
    ---------------------------------------------------------------------------

```

## AUTHENTICATION

The *t.stac.catalog* tool supports authentication with the STAC API
using the *GDAL's* virtual fie system */vsi/*.

### Basic Authentication

```sh
    t.stac.catalog url="https://earth-search.aws.element84.com/v1/" settings="user:password"
```

### AWS

[AWS
S3](https://gdal.org/user/virtual_file_systems.html#vsis3-aws-s3-files)

### Google Cloud Storage

[Google Cloud
Storage](https://gdal.org/user/virtual_file_systems.html#vsigs-google-cloud-storage-files)

### Microsoft Azure

[Microsoft
Azure](https://gdal.org/user/virtual_file_systems.html#vsiaz-microsoft-azure-blob-files)

### HTTP

[HTTP](https://gdal.org/user/virtual_file_systems.html#vsicurl-http-https-ftp-files-random-access)

## SEE ALSO

*[t.stac.catalog](https://grass.osgeo.org/grass-stable/manuals/addons/t.stac.catalog.html),
[t.stac.item](https://grass.osgeo.org/grass-stable/manuals/addons/t.stac.item.html)*

## AUTHORS

Corey T. White

## Sponsors

- [OpenPlains Inc.](https://openplains.com)
- [NCSU GeoForAll Lab](https://geospatial.ncsu.edu/geoforall/)

Center for Geospatial Analytics at North Carolina State University

## SOURCE CODE

Available at: [t.stac.collection source code](https://github.com/OSGeo/grass-addons/tree/grass8/temporal/t.stac/t.stac.collection)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/temporal/t.stac/t.stac.collection))  
Latest change: Tuesday Apr 01 23:14:57 2025 in commit [814b39c](https://github.com/OSGeo/grass-addons/commit/814b39c402a9c3987ef48765eaf6f719b53570f7)
