---
name: test.raster3d.lib
description: Performs unit and integration tests for the raster3d library
keywords: [ raster3d, unit test ]
---

# test.raster3d.lib

Performs unit and integration tests for the raster3d library

=== "Command line"

    **test.raster3d.lib**
    [**-ul**]
    [**unit**=*string*]
    [**depths**=*integer*]
    [**rows**=*integer*]
    [**cols**=*integer*]
    [**tile_size**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    test.raster3d.lib
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***test.raster3d.lib***",
        **unit**=*None*,
        **depths**=*20*,
        **rows**=*5400*,
        **cols**=*10800*,
        **tile_size**=*32*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("test.raster3d.lib")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.test_raster3d_lib*(**unit**=*None*,
        **depths**=*20*,
        **rows**=*5400*,
        **cols**=*10800*,
        **tile_size**=*32*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.test_raster3d_lib()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **unit**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose the unit tests to run  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *coord, putget, large*  
    **depths**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of depths to be used for the large file put/get value test  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **rows**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of rows to be used for the large file put/get value test  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5400*  
    **cols**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of columns to be used for the large file put/get value test  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10800*  
    **tile_size**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;The tile size in kilo bytes to be used for the large file put/get value test. Set the tile size to 2048 and the number of row\*cols\*depths &gt; 130000 to reproduce the tile rle error.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **-u**  
    &nbsp;&nbsp;&nbsp;&nbsp;Run all unit tests  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Switch zip compression on  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **unit** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose the unit tests to run  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *coord, putget, large*  
    **depths** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of depths to be used for the large file put/get value test  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **rows** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of rows to be used for the large file put/get value test  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5400*  
    **cols** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of columns to be used for the large file put/get value test  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10800*  
    **tile_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The tile size in kilo bytes to be used for the large file put/get value test. Set the tile size to 2048 and the number of row\*cols\*depths &gt; 130000 to reproduce the tile rle error.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Run all unit tests  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch zip compression on  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **unit** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Choose the unit tests to run  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *coord, putget, large*  
    **depths** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of depths to be used for the large file put/get value test  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *20*  
    **rows** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of rows to be used for the large file put/get value test  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5400*  
    **cols** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The number of columns to be used for the large file put/get value test  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10800*  
    **tile_size** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;The tile size in kilo bytes to be used for the large file put/get value test. Set the tile size to 2048 and the number of row\*cols\*depths &gt; 130000 to reproduce the tile rle error.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *32*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *u*, *l*  
    &nbsp;&nbsp;&nbsp;&nbsp;**u**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Run all unit tests  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Switch zip compression on  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*test.raster3d.lib* is a module dedicated for testing the raster 3d
library functionality and to perform benchmark runs. This module is used
by the testing framework to perform library tests.

## AUTHOR

Sören Gebbert

## SOURCE CODE

Available at: [test.raster3d.lib source code](https://github.com/OSGeo/grass/tree/main/lib/raster3d/test)
([history](https://github.com/OSGeo/grass/commits/main/lib/raster3d/test))  
Latest change: Saturday Feb 22 12:35:21 2025 in commit [c12df29](https://github.com/OSGeo/grass/commit/c12df298352da495dc6b4983ffc3ca160906490b)
