---
name: v.concave.hull.py
description: Creates a concave hull around points.
keywords: [ vector, geometry, alpha shape ]
---

# v.concave.hull.py

Creates a concave hull around points.

=== "Command line"

    **v.concave.hull.py**
    **input**=*name*
    **output**=*name*
    [**threshold**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.concave.hull.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.concave.hull.py***",
        **input**,
        **output**,
        **threshold**=*7*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.concave.hull.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_concave_hull_py*(**input**,
        **output**,
        **threshold**=*7*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_concave_hull_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input points  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **threshold**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lower values make the hull more concave  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *7*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input points  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lower values make the hull more concave  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *7*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input points  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **threshold** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Lower values make the hull more concave  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *0-10*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *7*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.concave.hull* creates a concave hull around points. Contrary to a
convex hull, a concave hull can describe the shape of a point cloud.

## EXAMPLES

### Creating a convex and a concave hull

Creating a convex and a concave hull around schools\_wake in the North
Carolina sample dataset:

```sh
v.hull in=schools_wake out=schools_wake_convex
v.concave.hull in=schools_wake out=schools_wake_concave
```

Convex hull around schools:

![image-alt](v_concave_convex.png)

Concave hull around schools:

![image-alt](v_concave_concave.png)

### Creating Alpha shapes

Alpha shapes around points (left: threshold=8; right: threshold=0.5):

![image-alt](v_concave_alpha_8.png)  
![image-alt](v_concave_alpha_0_5.png)

## SEE ALSO

*[v.hull](https://grass.osgeo.org/grass-stable/manuals/v.hull.html),
[v.buffer,](https://grass.osgeo.org/grass-stable/manuals/v.buffer.html),
[v.kernel](https://grass.osgeo.org/grass-stable/manuals/v.kernel.html)*

## AUTHOR

Markus Metz

## SOURCE CODE

Available at: [v.concave.hull source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.concave.hull)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.concave.hull))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
