---
name: v.extract
description: Selects vector features from an existing vector map and creates a new vector map containing only the selected features.
keywords: [ vector, extract, select, dissolve, random ]
---

# v.extract

Selects vector features from an existing vector map and creates a new vector map containing only the selected features.

=== "Command line"

    **v.extract**
    [**-dtr**]
    **input**=*name*
    [**layer**=*string*]
    [**type**=*string* [,*string*,...]]
    [**cats**=*range*]
    [**where**=*sql_query*]
    **output**=*name*
    [**file**=*name*]
    [**random**=*integer*]
    [**new**=*integer*]
    [**dissolve_column**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.extract input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.extract***",
        **input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,area,face"*,
        **cats**=*None*,
        **where**=*None*,
        **output**,
        **file**=*None*,
        **random**=*None*,
        **new**=*-1*,
        **dissolve_column**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.extract", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_extract*(**input**,
        **layer**=*"1"*,
        **type**=*"point,line,boundary,centroid,area,face"*,
        **cats**=*None*,
        **where**=*None*,
        **output**,
        **file**=*None*,
        **random**=*None*,
        **new**=*-1*,
        **dissolve_column**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_extract(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Types to be extracted  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area,face*  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **file**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input text file with category numbers/number ranges to be extracted  
    &nbsp;&nbsp;&nbsp;&nbsp;If '-' given reads from standard input  
    **random**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of random categories matching vector objects to extract  
    &nbsp;&nbsp;&nbsp;&nbsp;Number must be smaller than unique cat count in layer  
    **new**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Desired new category value (enter -1 to keep original categories)  
    &nbsp;&nbsp;&nbsp;&nbsp;If new &gt;= 0, attributes is not copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **dissolve_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column for dissolving areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserves category values  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;Dissolve common boundaries (default is no)  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not copy attributes (see also 'new' parameter)  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Reverse selection  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Types to be extracted  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area,face*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **file** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input text file with category numbers/number ranges to be extracted  
    &nbsp;&nbsp;&nbsp;&nbsp;If '-' given reads from standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **random** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of random categories matching vector objects to extract  
    &nbsp;&nbsp;&nbsp;&nbsp;Number must be smaller than unique cat count in layer  
    **new** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Desired new category value (enter -1 to keep original categories)  
    &nbsp;&nbsp;&nbsp;&nbsp;If new &gt;= 0, attributes is not copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **dissolve_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column for dissolving areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserves category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *t*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dissolve common boundaries (default is no)  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not copy attributes (see also 'new' parameter)  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse selection  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Types to be extracted  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, boundary, centroid, area, face*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,boundary,centroid,area,face*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **file** : str | io.StringIO, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input text file with category numbers/number ranges to be extracted  
    &nbsp;&nbsp;&nbsp;&nbsp;If '-' given reads from standard input  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **random** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of random categories matching vector objects to extract  
    &nbsp;&nbsp;&nbsp;&nbsp;Number must be smaller than unique cat count in layer  
    **new** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Desired new category value (enter -1 to keep original categories)  
    &nbsp;&nbsp;&nbsp;&nbsp;If new &gt;= 0, attributes is not copied  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **dissolve_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column for dissolving areas  
    &nbsp;&nbsp;&nbsp;&nbsp;Preserves category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *d*, *t*, *r*  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Dissolve common boundaries (default is no)  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not copy attributes (see also 'new' parameter)  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Reverse selection  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.extract* allows a user to select vector objects from an existing
vector map and creates a new map containing only the selected objects.
Database tables can be queried with SQL statements, if a connection is
established. Dissolving (optional) is based on the output categories. If
2 adjacent areas have the same output category, the boundary is removed.

If **cats**, **file**, **random** or **where** options are not
specified, all features of given type and layer are extracted.
Categories are not changed in that case.

## NOTES

Only features with a category number in the selected layer will be
extracted. So if you want to extract boundaries (which are usually
without category, as that information is normally held in the area's
centroid) you must first use *[v.category](v.category.md)* to add them,
or use **layer=-1**.

## EXAMPLES

The examples are intended for the North Carolina sample dataset:

### Extract areas by category number with dissolving \#1

```sh
v.extract -d cats=1,2,3,4 input=soils_wake output=soil_groupa type=area new=0
```

produces a new vector **soil_groupa**, containing those areas from
vector **soils** which have category numbers **1 thru 4**; any common
boundaries are dissolved, and all areas in the new map will be assigned
category number 0.

### Extract areas by category number with dissolving \#2

```sh
v.extract -d cats=1-4 input=soils_wake output=soil_groupa type=area new=-1
```

produces a new vector map **soil_groupa** containing the areas from
vector **soils** which have categories **1 thru 4**. Any common
boundaries are dissolved, all areas in the new map will retain their
original category numbers 1 thru 4, since **new** was set to -1.

### Extract all areas and assign the same category to all

```sh
v.extract input=soils_wake output=soil_groupa type=area new=1
```

produces a new vector map **soil_groupa** containing all areas from
**soils**. No common boundaries are dissolved, all areas of the new map
will be assigned category number 1.

### Extract vectors with SQL

```sh
v.extract input=markveggy.shp output=markveggy.1 new=13 \
  where="(VEGTYPE = 'Wi') or (VEGTYPE = 'PS') or (PRIME_TYPE='Wi')"
```

produces a new vector map with category number 13 if the SQL statement
is fulfilled.

### Extract vector features which have the given field empty

```sh
v.extract input=lakes output=lakes_gaps where="FTYPE is NULL"
```

### Extract vector features which have the given field not empty

```sh
v.extract input=lakes output=lakes_ftype where="FTYPE not NULL"
```

### Reverse extracting (behaves like selective vector objects deleting)

Remove meteorological stations from map which are located above 1000m:

```sh
# check what to delete:
v.db.select precip_30ynormals where="elev > 1000"

# perform reverse selection
v.extract -r input=precip_30ynormals output=precip_30ynormals_lowland \
  where="elev > 1000"

# verify
v.db.select precip_30ynormals_lowland
```

### Dissolving based on column attributes

```sh
# check column names:
v.info -c zipcodes_wake

# reclass based on desired column:
v.reclass input=zipcodes_wake output=zipcodes_wake_recl_nam column=ZIPNAME

# verify:
v.info -c zipcodes_wake_recl_nam
v.db.select zipcodes_wake_recl_nam

# dissolve:
v.extract -d input=zipcodes_wake_recl_nam output=zipcodes_wake_regions
```

This produces a new vector map with common boundaries dissolved where
the reclassed attributes of adjacent (left/right) areas are identical.

### Extract 3 random areas from geology map

```sh
v.extract input=geology output=random_geology type=area random=3
```

This creates a new map with three random categories matching areas. Note
that there may be more than one feature with the same category.

## SEE ALSO

*[v.category](v.category.md), [v.dissolve](v.dissolve.md),
[v.reclass](v.reclass.md), [GRASS SQL interface](sql.md)*

## AUTHORS

R.L. Glenn, USDA, SCS, NHQ-CGIS  
GRASS 6 port by Radim Blazek

## SOURCE CODE

Available at: [v.extract source code](https://github.com/OSGeo/grass/tree/main/vector/v.extract)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.extract))  
Latest change: Saturday Dec 20 19:53:33 2025 in commit [271dc50](https://github.com/OSGeo/grass/commit/271dc5096333a5aeeb3c814b08eddb1011797fc9)
