---
name: v.extrude
description: Extrudes flat vector features to 3D vector features with defined height. Optionally the height can be derived from sampling of elevation raster map.
keywords: [ vector, geometry, sampling, 3D ]
---

# v.extrude

Extrudes flat vector features to 3D vector features with defined height.

Optionally the height can be derived from sampling of elevation raster map.

=== "Command line"

    **v.extrude**
    [**-t**]
    **input**=*name*
    [**layer**=*string*]
    [**cats**=*range*]
    [**where**=*sql_query*]
    [**type**=*string* [,*string*,...]]
    **output**=*name*
    [**zshift**=*float*]
    [**height**=*float*]
    [**height_column**=*name*]
    [**elevation**=*name*]
    [**method**=*string*]
    [**scale**=*float*]
    [**null_value**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.extrude input=name output=name height=0.0
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.extrude***",
        **input**,
        **layer**=*"-1"*,
        **cats**=*None*,
        **where**=*None*,
        **type**=*"point,line,area"*,
        **output**,
        **zshift**=*0*,
        **height**=*None*,
        **height_column**=*None*,
        **elevation**=*None*,
        **method**=*"nearest"*,
        **scale**=*1.0*,
        **null_value**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.extrude", input="name", output="name", height=0.0)
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_extrude*(**input**,
        **layer**=*"-1"*,
        **cats**=*None*,
        **where**=*None*,
        **type**=*"point,line,area"*,
        **output**,
        **zshift**=*0*,
        **height**=*None*,
        **height_column**=*None*,
        **elevation**=*None*,
        **method**=*"nearest"*,
        **scale**=*1.0*,
        **null_value**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_extrude(input="name", output="name", height=0.0)
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **cats**=*range*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **type**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **zshift**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **height**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fixed height for 3D vector features  
    **height_column**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column with feature height  
    **elevation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation raster map for height extraction  
    **method**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling interpolation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: Nearest-neighbor interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    **scale**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor sampled raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **null_value**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for sampled raster NULL values  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Trace elevation  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **zshift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **height** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fixed height for 3D vector features  
    **height_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column with feature height  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **elevation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation raster map for height extraction  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling interpolation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: Nearest-neighbor interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor sampled raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **null_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for sampled raster NULL values  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Trace elevation  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **cats** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Category values  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: 1,3,7-9,13  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, cats, *range*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **type** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input feature type  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *point, line, area*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *point,line,area*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **zshift** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Shifting value for z coordinates  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0*  
    **height** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Fixed height for 3D vector features  
    **height_column** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column with feature height  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **elevation** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Elevation raster map for height extraction  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **method** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Sampling interpolation method  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *nearest, bilinear, bicubic*  
    &nbsp;&nbsp;&nbsp;&nbsp;**nearest**: Nearest-neighbor interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bilinear**: Bilinear interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;**bicubic**: Bicubic interpolation  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *nearest*  
    **scale** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Scale factor sampled raster values  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.0*  
    **null_value** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for sampled raster NULL values  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Trace elevation  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.extrude* creates faces, kernels or 3D lines based on input 2D vector
features. Points are converted to 3D vertical lines, lines to faces and
areas to volumes (composition of closed set of faces and kernel).

If **elevation** parameter is used then 3D vector features follow the
elevation model by using individual elevation values for the vertices.
Height for vertices is interpolated from elevation raster map using
given interpolation **method**.

## NOTES

*v.extrude* extrudes vector features which means that points are
converted to vertical lines. Lines and area boundaries are extruded to a
set of faces, each segment defines one face. Area centroids are written
as kernels. Area as a composition of boundaries and centroid is stored
as a closed set of faces and kernel which define a volume.

For conversion of 2D points or lines to 3D can be used
*[v.to.3d](v.to.3d.md)* or *[v.drape](v.drape.md)*. In opposite to
*v.extrude*, these modules do not extrude vector features, they defines
z-coordinate for the features from given parameters or by sampling
elevation raster map values. It means that no feature type conversion is
applied, points remain still points in the output vector map. Same
applies for the lines.

*v.extrude* modifies only features geometry. Feature categories remain
untouched and attribute data is copied from input vector map to the
output.

By default, all features (including features without category) from
input vector map are processed (**layer=-1**). Feature selection can be
applied by **layer**, **cats** or **where** parameter.

## EXAMPLES

### 3D houses with fixed height

```sh
v.extrude input=houses output=houses3D height=5 type=area
```

### 3D houses with individual height

```sh
v.extrude input=houses output=houses3D elevation=dem height_column=height type=area
```

### Convert 2D points to 3D vertical lines with fixed height

```sh
v.extrude input=geodetic_pts output=points3D height=200 type=point
```

## SEE ALSO

*[v.transform](v.transform.md), [v.drape](v.drape.md),
[v.to.3d](v.to.3d.md)*

*[wxGUI 3D viewer](wxGUI.nviz.md)*

## AUTHORS

Jachym Cepicky,  
Updated for GRASS 7 by Martin Landa, FBK-irst, Italy and Czech Technical
University in Prague, Czech Republic

## SOURCE CODE

Available at: [v.extrude source code](https://github.com/OSGeo/grass/tree/main/vector/v.extrude)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.extrude))  
Latest change: Friday May 09 14:33:40 2025 in commit [b356c7e](https://github.com/OSGeo/grass/commit/b356c7e108fcbeca77474c8e83ebec8f1e7b3e4a)
