---
name: v.gsflow.grid.py
description: Builds grid for the MODFLOW component of GSFLOW
keywords: [ vector, stream network, hydrology, GSFLOW ]
---

# v.gsflow.grid.py

Builds grid for the MODFLOW component of GSFLOW

=== "Command line"

    **v.gsflow.grid.py**
    **basin**=*name*
    **pour_point**=*name*
    [**raster_input**=*name*]
    **dx**=*string*
    **dy**=*string*
    **output**=*name*
    [**mask_output**=*name*]
    **bc_cell**=*name*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.gsflow.grid.py basin=name pour_point=name dx=string dy=string output=name bc_cell=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.gsflow.grid.py***",
        **basin**,
        **pour_point**,
        **raster_input**=*None*,
        **dx**,
        **dy**,
        **output**,
        **mask_output**=*None*,
        **bc_cell**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.gsflow.grid.py", basin="name", pour_point="name", dx="string", dy="string", output="name", bc_cell="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_gsflow_grid_py*(**basin**,
        **pour_point**,
        **raster_input**=*None*,
        **dx**,
        **dy**,
        **output**,
        **mask_output**=*None*,
        **bc_cell**,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_gsflow_grid_py(basin="name", pour_point="name", dx="string", dy="string", output="name", bc_cell="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **basin**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Study basin, over which to build a MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **pour_point**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point, to which row and col (MODFLOW) will be added  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **raster_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster to be resampled to grid resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **dx**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell size suggestion (x / E / zonal), map units: rounds to DEM  
    **dy**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell size suggestion (y / N / meridional), map units: rounds to DEM  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **mask_output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster basin mask: inside (1) or outside (0) the watershed?  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **bc_cell**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Constant-head boundary condition cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **basin** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Study basin, over which to build a MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **pour_point** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point, to which row and col (MODFLOW) will be added  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **raster_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster to be resampled to grid resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dx** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell size suggestion (x / E / zonal), map units: rounds to DEM  
    **dy** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell size suggestion (y / N / meridional), map units: rounds to DEM  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **mask_output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster basin mask: inside (1) or outside (0) the watershed?  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **bc_cell** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Constant-head boundary condition cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **basin** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Study basin, over which to build a MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **pour_point** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Pour point, to which row and col (MODFLOW) will be added  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **raster_input** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster to be resampled to grid resolution  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **dx** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell size suggestion (x / E / zonal), map units: rounds to DEM  
    **dy** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Cell size suggestion (y / N / meridional), map units: rounds to DEM  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;MODFLOW grid  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **mask_output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster basin mask: inside (1) or outside (0) the watershed?  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **bc_cell** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Constant-head boundary condition cell  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.gsflow.grid* generates the MODFLOW grid and associated basin mask
that are used for the USGS combined groundwater (MODFLOW) and
surface-water (PRMS) model GSFLOW.

## REFERENCES

Ng, G.-H. C., A. D. Wickert, R. L. McLaughlin, J. La Frenierre, S.
Liess, and L. Sabeeri (2016), Modeling the role of groundwater and
vegetation in the hydrological response of tropical glaciated watersheds
to climate change, in AGU Fall Meeting Abstracts, H13L–1590, San
Francisco, CA.

## SEE ALSO

[v.gsflow.export](v.gsflow.export),
[v.gsflow.gravres](v.gsflow.gravres),
[v.gsflow.hruparams](v.gsflow.hruparams),
[v.gsflow.reaches](v.gsflow.reaches.md),
[v.gsflow.segments](v.gsflow.segments.md),
[v.gsflow.mapdata](v.gsflow.mapdata.md),
[r.gsflow.hydrodem](r.gsflow.hydrodem.md),
[v.stream.inbasin](v.stream.inbasin.md),
[v.stream.network](v.stream.network.md)

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [v.gsflow.grid source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.gsflow.grid)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.gsflow.grid))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
