---
name: v.histogram.py
description: Draws the histogram of values in a vector attribute column
keywords: [ vector, plot, histogram ]
---

# v.histogram.py

Draws the histogram of values in a vector attribute column

=== "Command line"

    **v.histogram.py**
    **map**=*name*
    [**layer**=*string*]
    **column**=*name*
    [**where**=*sql_query*]
    **plot_output**=*name*
    [**bins**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.histogram.py map=name column=name plot_output=-
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.histogram.py***",
        **map**,
        **layer**=*"1"*,
        **column**,
        **where**=*None*,
        **plot_output**=*"-"*,
        **bins**=*30*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.histogram.py", map="name", column="name", plot_output="-")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_histogram_py*(**map**,
        **layer**=*"1"*,
        **column**,
        **where**=*None*,
        **plot_output**=*"-"*,
        **bins**=*30*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_histogram_py(map="name", column="name", plot_output="-")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column to create histogram from  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **plot_output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for graphic output file for plot (extension decides format, - for screen)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **bins**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bins in histogram  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column to create histogram from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **plot_output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for graphic output file for plot (extension decides format, - for screen)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **bins** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bins in histogram  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Attribute column to create histogram from  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **plot_output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for graphic output file for plot (extension decides format, - for screen)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, file, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-*  
    **bins** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of bins in histogram  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *30*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.histogram* draws a histogram of the values in a vector map attribute
column. Users can use the **where** option to only select a subset of
the attribute table and can determine the number of **bins** (bars) used
for the histogram. The **plot\_output** parameter determines whether the
result is displayed on screen (default) or exported to a graphics file.

## NOTE

This is a quick and dirty solution using basic matplotlib. In future,
this should be integrated into the g.gui, possibly together with the
raster histogram tool.

## EXAMPLE

Show the histogram of median age values in the census block map:

```sh
v.histogram map=censusblk_swwake column=MEDIAN_AGE where="TOTAL_POP>0"
```

![image-alt](d_vect_colhist.png)  
Histogram of median age values in census blocks

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [v.histogram source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.histogram)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.histogram))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
