---
name: v.in.dxf
description: Converts file in DXF format to GRASS vector map.
keywords: [ vector, import, DXF, level1 ]
---

# v.in.dxf

Converts file in DXF format to GRASS vector map.

=== "Command line"

    **v.in.dxf**
    [**-etbfli1**]
    **input**=*name*
    **output**=*name*
    [**layers**=*string* [,*string*,...]]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.dxf input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.dxf***",
        **input**,
        **output**,
        **layers**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.dxf", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_dxf*(**input**,
        **output**,
        **layers**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_dxf(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to input DXF file  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **layers**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;List of DXF layers to import (default: all)  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Ignore the map extent of DXF file  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    **-f**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import polyface meshes as 3D wire frame  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;List available DXF layers and exit  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Invert selection by DXF layers (don't import layers in list)  
    **-1**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import all objects into one layer  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to input DXF file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **layers** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of DXF layers to import (default: all)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *t*, *b*, *f*, *l*, *i*, *1*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore the map extent of DXF file  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import polyface meshes as 3D wire frame  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available DXF layers and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert selection by DXF layers (don't import layers in list)  
    &nbsp;&nbsp;&nbsp;&nbsp;**1**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import all objects into one layer  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Path to input DXF file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **layers** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;List of DXF layers to import (default: all)  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*, *t*, *b*, *f*, *l*, *i*, *1*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Ignore the map extent of DXF file  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not build topology  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Advantageous when handling a large number of points  
    &nbsp;&nbsp;&nbsp;&nbsp;**f**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import polyface meshes as 3D wire frame  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;List available DXF layers and exit  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Invert selection by DXF layers (don't import layers in list)  
    &nbsp;&nbsp;&nbsp;&nbsp;**1**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import all objects into one layer  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.dxf* converts DXF format CAD files to GRASS vector format. The
following graphical objects (DXF entities) are supported:

- point
  - **DXF POINT**
- line
  - **DXF LINE**
  - **DXF POLYLINE**
  - **DXF LWPOLYLINE**
  - **DXF ARC**
  - **DXF CIRCLE**
  - **DXF TEXT**
- face
  - **DXF POLYFACE MESHES**
  - **DXF 3DFACE**

Table and column names are changed to lowercase characters for easier
SQL usage (lowercase table/column names avoid the need to quote them if
the attribute table is stored in a SQL DBMS such as PostgreSQL).

The "layer" column will contain the name(s) of the DXF input layer(s).
The DXF entity type string will be stored in the "entity" column as
uppercase.

The "handle" column can be used to store small bits of data associated
with any entity in the DXF file (i.e., entity handle or unique object
identifiers in the layer). The entity handle is a "text string of up to
16 hexadecimal digits", which is a 64-bit integer (currently not
supported by GRASS database drivers). For text type entities, the text
value will be stored in the "label" column of the GRASS vector output
map. Neither the "handle" nor "label" column is mandatory.

## REFERENCES

[AutoCad DXF](https://en.wikipedia.org/wiki/AutoCAD_DXF) (from
Wikipedia, the free encyclopedia)  
[DXF
References](http://usa.autodesk.com/adsk/servlet/item?siteID=123112&id=12272454&linkID=10809853)
(Autodesk-supplied documentation)

## SEE ALSO

*[v.out.dxf](v.out.dxf.md), [v.in.ogr](v.in.ogr.md),
[v.out.ogr](v.out.ogr.md)*

*[How-to import DXF files in
wxGUI](https://grasswiki.osgeo.org/wiki/Import_DXF) (from GRASS User
Wiki)*

## AUTHORS

Original written by Chuck Ehlschlaeger, 6/1989  
Revised by Dave Gerdes, 12/1989  
US Army Construction Engineering Research Lab

Updated for GRASS 6 and 3D support. Huidae Cho, 3/2006  
With minor additions by Benjamin Ducke (Oxford Archaeology), 4/2009

## SOURCE CODE

Available at: [v.in.dxf source code](https://github.com/OSGeo/grass/tree/main/vector/v.in.dxf)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.in.dxf))  
Latest change: Tuesday Sep 23 13:47:25 2025 in commit [00a05b0](https://github.com/OSGeo/grass/commit/00a05b047225bb450e02d561c0556e4f74f58ff4)
