---
name: v.in.gps.py
description: Import waypoints, routes, and tracks from a GPS receiver or GPS download file into a vector map.
keywords: [ vector, import, GPS ]
---

# v.in.gps.py

Import waypoints, routes, and tracks from a GPS receiver or GPS download file into a vector map.

=== "Command line"

    **v.in.gps.py**
    [**-wrtpk**]
    **input**=*name*
    **output**=*name*
    [**format**=*string*]
    [**proj**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.gps.py input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.gps.py***",
        **input**,
        **output**,
        **format**=*"gpx"*,
        **proj**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.gps.py", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_gps_py*(**input**,
        **output**,
        **format**=*"gpx"*,
        **proj**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_gps_py(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Device or file used to import data  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **format**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;GPSBabel supported output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gpx*  
    **proj**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Projection of input data (PROJ.4 style), if not set Lat/Lon WGS84 is assumed  
    **-w**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import as waypoints  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import as routes  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Import as tracks  
    **-p**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force vertices of track or route data as points  
    **-k**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not attempt projection transform from WGS84  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Device or file used to import data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GPSBabel supported output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gpx*  
    **proj** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Projection of input data (PROJ.4 style), if not set Lat/Lon WGS84 is assumed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *w*, *r*, *t*, *p*, *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import as waypoints  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import as routes  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import as tracks  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force vertices of track or route data as points  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not attempt projection transform from WGS84  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Device or file used to import data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **format** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;GPSBabel supported output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gpx*  
    **proj** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Projection of input data (PROJ.4 style), if not set Lat/Lon WGS84 is assumed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *w*, *r*, *t*, *p*, *k*  
    &nbsp;&nbsp;&nbsp;&nbsp;**w**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import as waypoints  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import as routes  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Import as tracks  
    &nbsp;&nbsp;&nbsp;&nbsp;**p**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Force vertices of track or route data as points  
    &nbsp;&nbsp;&nbsp;&nbsp;**k**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not attempt projection transform from WGS84  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.gps* allows the user to import waypoint, route, and track data
from a locally connected GPS receiver or a text file containing GPS data
of many common formats. Translation is done via the
*[GPSBabel](https://www.gpsbabel.org)* program.

This software is not intended as a primary means of navigation.

## NOTES

*v.in.gps* automatically reprojects data using the projection settings
of the current location. The default input data projection is lat/lon
WGS84. If your GPS outputs data using another projection or map datum,
you may include the *[PROJ](https://proj.org/)* parameters defining your
projection in the **proj** option and *v.in.gps* will reproject your
data accordingly. Great care must be taken to get these parameters
correct\! The automatic transform may be skipped by using the **-k**
flag in which case the data will be imported unprojected, as it appears
in the **input**.

Route and Track data may be uploaded as a series of points by using the
**-p** flag, otherwise they will be imported as lines. You can run
*v.in.gps* multiple times and merge the line and point vectors with the
*v.patch* command if you want, but take care when merging dissimilar
attribute tables.

## EXAMPLES

### GPS device connected via USB adapter

Import waypoints, tracks, routes from /dev/ttyUSB0 and save to a GRASS
vector map:

```sh
v.in.gps -w input=/dev/ttyUSB0 format=garmin output=waypoints
v.in.gps -t input=/dev/ttyUSB0 format=garmin output=tracks
v.in.gps -r input=/dev/ttyUSB0 format=garmin output=routes
```

### GPS device connected via serial adapter

Import waypoint data from a Garmin GPS connected at /dev/ttyS0 and save
to a GRASS vector map named *waypoints*:

```sh
v.in.gps -w input=/dev/ttyS0 format=garmin output=waypoints
```

### Import track data from a GPX

Import track data from a GPX text file and save to a GRASS vector map
named *tracks*.

```sh
v.in.gps -t input=gpslog.gpx format=gpx output=tracks
```

### Import route data from GPS connected at /dev/gps

Import route data as a series of points from a Garmin GPS connected at
/dev/gps and save to a GRASS vector map named *routePoints*:

```sh
v.in.gps -r -p file=/dev/gps format=garmin output=routePoints
```

## SEE ALSO

*[db.execute](https://grass.osgeo.org/grass-stable/manuals/db.execute.html),
[v.in.ascii](https://grass.osgeo.org/grass-stable/manuals/v.in.ascii.html),
[v.in.garmin](v.in.garmin.md),
[v.db.connect](https://grass.osgeo.org/grass-stable/manuals/v.db.connect.html),
[v.patch](https://grass.osgeo.org/grass-stable/manuals/v.patch.html)*
[gpsbabel](https://www.gpsbabel.org) from gpsbabel.org  
cs2cs from [PROJ](https://proj.org/)

## AUTHORS

Claudio Porta and Lucio Davide Spano, students of Computer Science at
University of Pisa (Italy).  
Commission from Faunalia Pontedera (PI)  
  
Based on *v.in.garmin* for GRASS 6.0 by Hamish Bowman  
and *v.in.garmin.sh* for GRASS 5 by Andreas Lange

## SOURCE CODE

Available at: [v.in.gps source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.in.gps)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.in.gps))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
