---
name: v.in.wfs2.py
description: Downloads and imports data from WFS server.
keywords: [ vector, import, wfs ]
---

# v.in.wfs2.py

Downloads and imports data from WFS server.

=== "Command line"

    **v.in.wfs2.py**
    [**-rc**]
    **url**=*string*
    **layers**=*string* [,*string*,...]
    **output**=*name*
    [**srs**=*integer*]
    [**region**=*string*]
    [**wfs_version**=*string*]
    [**maximum_features**=*integer*]
    [**urlparams**=*string*]
    [**driver**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.in.wfs2.py url=string layers=string output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.in.wfs2.py***",
        **url**,
        **layers**,
        **output**,
        **srs**=*4326*,
        **region**=*None*,
        **wfs_version**=*"1.1.0"*,
        **maximum_features**=*None*,
        **urlparams**=*None*,
        **driver**=*"WFS_GRASS"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.in.wfs2.py", url="string", layers="string", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_in_wfs2_py*(**url**,
        **layers**,
        **output**,
        **srs**=*4326*,
        **region**=*None*,
        **wfs_version**=*"1.1.0"*,
        **maximum_features**=*None*,
        **urlparams**=*None*,
        **driver**=*"WFS_GRASS"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_in_wfs2_py(url="string", layers="string", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **url**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of WFS server  
    **layers**=*string* [,*string*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Layers to request from server  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **srs**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG number of source projection for request  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4326*  
    **region**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Named region to request data for (only with r flag)  
    **wfs_version**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;WFS standard  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1.1.0,  1.0.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.1.0*  
    **maximum_features**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of features to download  
    &nbsp;&nbsp;&nbsp;&nbsp;(default: unlimited)  
    **urlparams**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Addition query parameters for server (only with GRASS driver)  
    **driver**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;WFS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *WFS_GRASS,  WFS_OSWLib*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *WFS_GRASS*  
    **-r**  
    &nbsp;&nbsp;&nbsp;&nbsp;Restrict fetch to features which touch the region  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Get capabilities  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of WFS server  
    **layers** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layers to request from server  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **srs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG number of source projection for request  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4326*  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Named region to request data for (only with r flag)  
    **wfs_version** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WFS standard  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1.1.0,  1.0.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.1.0*  
    **maximum_features** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of features to download  
    &nbsp;&nbsp;&nbsp;&nbsp;(default: unlimited)  
    **urlparams** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Addition query parameters for server (only with GRASS driver)  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WFS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *WFS_GRASS,  WFS_OSWLib*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *WFS_GRASS*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restrict fetch to features which touch the region  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get capabilities  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **url** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;URL of WFS server  
    **layers** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layers to request from server  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **srs** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;EPSG number of source projection for request  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *4326*  
    **region** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Named region to request data for (only with r flag)  
    **wfs_version** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WFS standard  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *1.1.0,  1.0.0*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1.1.0*  
    **maximum_features** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum number of features to download  
    &nbsp;&nbsp;&nbsp;&nbsp;(default: unlimited)  
    **urlparams** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Addition query parameters for server (only with GRASS driver)  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WFS driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *WFS_GRASS,  WFS_OSWLib*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *WFS_GRASS*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *r*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**r**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Restrict fetch to features which touch the region  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Get capabilities  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.in.wfs2* imports OGC WFS maps (Web Feature Service) from external
servers.

## EXAMPLES

Parks in Canada:

```sh
v.in.wfs2 url=http://www2.dmsolutions.ca/cgi-bin/mswfs_gmap output=parks srs=42304 layers=park wfs_version=1.1.0
```

## SEE ALSO

*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html),
[r.in.wms](https://grass.osgeo.org/grass-stable/manuals/r.in.wms.html),
[v.in.ogr](https://grass.osgeo.org/grass-stable/manuals/v.in.ogr.html)*

## AUTHOR

Stepan Turek

## SOURCE CODE

Available at: [v.in.wfs2 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.in.wfs2)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.in.wfs2))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
