---
name: v.isochrones.py
description: Creates isochrones from a road map and starting points
keywords: [ vector, network, isochrones ]
---

# v.isochrones.py

Creates isochrones from a road map and starting points

=== "Command line"

    **v.isochrones.py**
    [**-i**]
    **map**=*name*
    **roads_layer**=*string*
    [**node_layer**=*string*]
    **cost_column**=*name*
    **start_points**=*name*
    **isochrones**=*name*
    **time_steps**=*float* [,*float*,...]
    [**timemap**=*name*]
    [**offroad_speed**=*float*]
    [**memory**=*integer*]
    [**max_distance**=*float*]
    **method**=*string*
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.isochrones.py map=name roads_layer=1 cost_column=name start_points=name isochrones=name time_steps=0.0 method=v.net.iso
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.isochrones.py***",
        **map**,
        **roads_layer**=*"1"*,
        **node_layer**=*"2"*,
        **cost_column**,
        **start_points**,
        **isochrones**,
        **time_steps**,
        **timemap**=*None*,
        **offroad_speed**=*5.0*,
        **memory**=*300*,
        **max_distance**=*None*,
        **method**=*"v.net.iso"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.isochrones.py", map="name", roads_layer="1", cost_column="name", start_points="name", isochrones="name", time_steps=0.0, method="v.net.iso")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_isochrones_py*(**map**,
        **roads_layer**=*"1"*,
        **node_layer**=*"2"*,
        **cost_column**,
        **start_points**,
        **isochrones**,
        **time_steps**,
        **timemap**=*None*,
        **offroad_speed**=*5.0*,
        **memory**=*300*,
        **max_distance**=*None*,
        **method**=*"v.net.iso"*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_isochrones_py(map="name", roads_layer="1", cost_column="name", start_points="name", isochrones="name", time_steps=0.0, method="v.net.iso")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Roads with speed attribute  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **roads_layer**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number of the roads with relevant attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **node_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number of the nodes on the network (for method=v.net.iso)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **cost_column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of speed attribute column (in km/h) or cost column (in minutes)  
    **start_points**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with starting points for isochrones  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **isochrones**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map with isochrone polygons (Output prefix with flag -i)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **time_steps**=*float* [,*float*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Time steps of isochrones (in minutes)  
    **timemap**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional output raster map with continuous time from starting points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    **offroad_speed**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Speed for off-road areas (in km/h &gt; 0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5.0*  
    **memory**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Amount of memory (in MB) use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **max_distance**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance (m) from network to include into isochrones  
    **method**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Method to use for isochrone calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *v.net.iso, r.cost*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *v.net.iso*  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create individual isochrone map for each starting point  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Roads with speed attribute  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **roads_layer** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number of the roads with relevant attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **node_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number of the nodes on the network (for method=v.net.iso)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **cost_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of speed attribute column (in km/h) or cost column (in minutes)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **start_points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with starting points for isochrones  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **isochrones** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map with isochrone polygons (Output prefix with flag -i)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **time_steps** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time steps of isochrones (in minutes)  
    **timemap** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional output raster map with continuous time from starting points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **offroad_speed** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Speed for off-road areas (in km/h &gt; 0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5.0*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Amount of memory (in MB) use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **max_distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance (m) from network to include into isochrones  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method to use for isochrone calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *v.net.iso, r.cost*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *v.net.iso*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create individual isochrone map for each starting point  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Roads with speed attribute  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **roads_layer** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number of the roads with relevant attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **node_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number of the nodes on the network (for method=v.net.iso)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **cost_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of speed attribute column (in km/h) or cost column (in minutes)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **start_points** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with starting points for isochrones  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **isochrones** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector map with isochrone polygons (Output prefix with flag -i)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **time_steps** : float | list[float] | str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Time steps of isochrones (in minutes)  
    **timemap** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Optional output raster map with continuous time from starting points  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **offroad_speed** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Speed for off-road areas (in km/h &gt; 0)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *5.0*  
    **memory** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Amount of memory (in MB) use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *300*  
    **max_distance** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum distance (m) from network to include into isochrones  
    **method** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Method to use for isochrone calculation  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *v.net.iso, r.cost*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *v.net.iso*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create individual isochrone map for each starting point  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.isochrones* creates a vector polygon map of isochrones
(**isochrones**) based on a roads map (**map**) with speed or cost
attribute (**cost\_column**), one or several starting points
(**start\_points**) and time steps (in minutes) for the isochrones
(**time\_steps**). The module is actually a front-end to different GRASS
GIS modules, and the user can chose the approach with the **method**
option (see the notes section for details).

The spatial precision of the analysis is defined by the current
computational region. The user can define this with
*[g.region](https://grass.osgeo.org/grass-stable/manuals/g.region.html)*.
Care should be taken to not define a too high resolution for the spatial
extent covered. Otherwise the user might be confronted with memory
issues.

## NOTES

Two approaches are currently implemented in the module:

The first (default) approach is based on
*[v.net.iso](https://grass.osgeo.org/grass-stable/manuals/v.net.iso.html)*.
The output of that module is then used to assign isochrone values to all
pixels based on the nearest road segment that is within a given distance
(**max\_distance**). The **-i** flag allows to calculate a separate
isochrone map for each starting point. For this approach, the input road
map currently has to be prepared by adding all nodes (using
*[v.net](https://grass.osgeo.org/grass-stable/manuals/v.net.html)* with
'operation=nodes' and the '-c' flag. For each starting point, the
algorithm then finds the closest node on the network and calculates the
isochrones from there. This allows to use the same network for many
analyses without having to go through the time of adding the starting
points at each run. In addition, a **cost\_column** has to be present in
the attribute table containing for each line segment the time of
traversal in minutes (i.e. length/speed).

The second approach is based on
*[r.cost](https://grass.osgeo.org/grass-stable/manuals/r.cost.html)*. It
transforms the roads to raster (here **cost\_column** has to point to an
attribute column containing speed in km/h), assigning a user chosen
**offroad\_speed** to all offroad pixels, calculates time cost from the
starting points and then transforms the result into discrete vector
polygons based on the time steps chosen. Optionally, the user can chose
to keep the a raster output of
*[r.cost](https://grass.osgeo.org/grass-stable/manuals/r.cost.html)*
(**timemap**). Current region settings are used to define the maximal
extension and the resolution at which the cost map is calculated. The
**memory** option allows to decide how much memory the
*[r.cost](https://grass.osgeo.org/grass-stable/manuals/r.cost.html)*
module can use (see the r.cost man page for more details). One big
advantage of the this second approach is that the road network does not
have to be topologically clean in order to get meaningful results.

## EXAMPLE

```sh
v.net -c input=roadsmajor operation=nodes output=myroads
v.db.addcolumn myroads col="speed int"
v.db.addcolumn myroads col="length double precision"
v.db.addcolumn myroads col="cost double precision"
v.db.update myroads col=speed value=120 where="ROAD_NAME='US-1'"
v.db.update myroads col=speed value=90 where="(ROAD_NAME like 'US%' AND ROAD_NAME <> 'US-1') OR ROAD_NAME like 'I-%'"
v.db.update myroads col=speed value=50 where="speed is null"
v.to.db myroads op=length col=length
v.db.update myroads col=cost qcol="(length/(speed*1000))*60"

g.region vector=myroads res=50 -a -p

echo "634637|224663" | v.in.ascii input=- output=start x=1 y=2

v.isochrones map=myroads cost_column=cost start_points=start isochrones=isochrones_vnetiso time_steps=15,30,60 \
    max_distance=1000 method=v.net.iso
```

![image-alt](v_isochrones_net.png)  
15, 30 and 60 minute isochrones from the start point using method
v.net.iso

```sh
v.isochrones map=myroads cost_column=speed start_points=start isochrones=isochrones_rcost time_steps=15,30,60 \
    method=r.cost memory=1000
```

![image-alt](v_isochrones_cost.png)  
15, 30 and 60 minute isochrones from the start point using method r.cost

## SEE ALSO

*[r.cost](https://grass.osgeo.org/grass-stable/manuals/r.cost.html),
[v.net.iso](https://grass.osgeo.org/grass-stable/manuals/v.net.iso.html)*

## AUTHOR

Moritz Lennert

## SOURCE CODE

Available at: [v.isochrones source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.isochrones)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.isochrones))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
