---
name: v.krige.py
description: Performs ordinary or block kriging for vector maps.
keywords: [ vector, interpolation, raster, kriging ]
---

# v.krige.py

Performs ordinary or block kriging for vector maps.

=== "Command line"

    **v.krige.py**
    **input**=*name*
    **column**=*name*
    [**output**=*name*]
    [**package**=*string*]
    [**model**=*string* [,*string*,...]]
    [**block**=*integer*]
    [**range**=*integer*]
    [**nugget**=*integer*]
    [**psill**=*integer*]
    [**kappa**=*float*]
    [**output_var**=*name*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.krige.py input=name column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.krige.py***",
        **input**,
        **column**,
        **output**=*None*,
        **package**=*"gstat"*,
        **model**=*None*,
        **block**=*None*,
        **range**=*None*,
        **nugget**=*None*,
        **psill**=*None*,
        **kappa**=*None*,
        **output_var**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.krige.py", input="name", column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_krige_py*(**input**,
        **column**,
        **output**=*None*,
        **package**=*"gstat"*,
        **model**=*None*,
        **block**=*None*,
        **range**=*None*,
        **nugget**=*None*,
        **psill**=*None*,
        **kappa**=*None*,
        **output_var**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_krige_py(input="name", column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of point vector map containing sample data  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column with numerical value to be interpolated  
    **output**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;If omitted, will be &lt;input name&gt;_kriging  
    **package**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;R package to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *gstat*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gstat*  
    **model**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Variogram model(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to test all models (requires automap)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Nug, Exp, Sph, Gau, Exc, Mat, Ste, Cir, Lin, Bes, Pen, Per, Hol, Log, Pow, Spl, Leg, Err, Int*  
    **block**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Block size (square block)  
    &nbsp;&nbsp;&nbsp;&nbsp;Block size. Used by block kriging.  
    **range**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **nugget**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Nugget value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **psill**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Partial sill value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **kappa**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kappa value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **output_var**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output variance raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;If omitted, will be &lt;input name&gt;_kriging.var  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of point vector map containing sample data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column with numerical value to be interpolated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **output** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;If omitted, will be &lt;input name&gt;_kriging  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **package** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;R package to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *gstat*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gstat*  
    **model** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Variogram model(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to test all models (requires automap)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Nug, Exp, Sph, Gau, Exc, Mat, Ste, Cir, Lin, Bes, Pen, Per, Hol, Log, Pow, Spl, Leg, Err, Int*  
    **block** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Block size (square block)  
    &nbsp;&nbsp;&nbsp;&nbsp;Block size. Used by block kriging.  
    **range** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **nugget** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Nugget value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **psill** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Partial sill value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **kappa** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kappa value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **output_var** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output variance raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;If omitted, will be &lt;input name&gt;_kriging.var  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of point vector map containing sample data  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column with numerical value to be interpolated  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **output** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;If omitted, will be &lt;input name&gt;_kriging  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **package** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;R package to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *gstat*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *gstat*  
    **model** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Variogram model(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Leave empty to test all models (requires automap)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *Nug, Exp, Sph, Gau, Exc, Mat, Ste, Cir, Lin, Bes, Pen, Per, Hol, Log, Pow, Spl, Leg, Err, Int*  
    **block** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Block size (square block)  
    &nbsp;&nbsp;&nbsp;&nbsp;Block size. Used by block kriging.  
    **range** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Range value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **nugget** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Nugget value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **psill** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Partial sill value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **kappa** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Kappa value  
    &nbsp;&nbsp;&nbsp;&nbsp;Automatically fixed if not set  
    **output_var** : str | type(np.ndarray) | type(np.array) | type(gs.array.array), *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output variance raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;If omitted, will be &lt;input name&gt;_kriging.var  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, raster, *name*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | np.ndarray | tuple[np.ndarray] | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned. If an array type (e.g., *np.ndarray*) is used for one of the raster outputs, the result will be an array and will have the shape corresponding to the computational region. If an array type is used for more than one raster output, the result will be a tuple of arrays.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.krige* allows performing Kriging operations in GRASS GIS environment,
using R software functions in background.

## NOTES

*v.krige* is just a front-end to R. The options and parameters are the
same offered by packages *automap* and *gstat*.

Kriging, like other interpolation methods, is fully dependent on input
data features. Exploratory analysis of data is encouraged to find out
outliers, trends, anisotropies, uneven distributions and consequently
choose the kriging algorithm that will give the most acceptable result.
Good knowledge of the dataset is more valuable than hundreds of
parameters or powerful hardware. See Isaaks and Srivastava's book,
exhaustive and clear even if a bit outdated.

Auto-fit variogram option will update partial sill, nugget, range and
kappa values with fitted ones. Enabling the values will pass them to
auto-fit and thus preserve from modification and thus they might differ
from fitted ones. Sill value can be tetermined by summing partial sill
with nugget.

### Dependencies

- **R software \>= 2.x**

- **rpy2**  
    Python binding to R. Note\! `rpy` version 1 is not supported.

- **R packages automap, gstat, rgrass7 and rgeos.**  
    automap is optional (provides automatic variogram fit).

Install Rpy2 via pip(3):

```sh
sudo pip3 install Rpy2
```

Install the following packages via R command line (or your preferred
GUI):

```R
  install.packages("rgeos", dep=T)
  install.packages("rgdal", dep=T)
  install.packages("gstat", dep=T)
  install.packages("rgrass7", dep=T)
  install.packages("automap", dep=T)
```

#### Notes for Debian GNU/Linux

Install the dependiencies. **Attention\! python-rpy IS NOT SUITABLE.**
(compare also installation via pip above):

```sh
  aptitude install R python-rpy2
```

To install R packages, use either R's functions listed above (as root or
as user), either the Debian packages \[5\], add to repositories' list
for 32bit or 64bit (pick up the suitable line):

```sh
  deb http://debian.cran.r-project.org/cran2deb/debian-i386 testing/
  deb http://debian.cran.r-project.org/cran2deb/debian-amd64 testing/
```

and get the packages via aptitude:

```sh
  aptitude install r-cran-gstat r-cran-rgrass7
```

#### Notes for Windows

Compile GRASS GIS following this
[guide](https://trac.osgeo.org/grass/wiki/CompileOnWindows). You could
also use Linux in a virtual machine. Or install Linux in a separate
partition of the HD. This is not as painful as it appears, there are
lots of guides over the Internet to help you.

### Computation time issues

Please note that although high number of input data points and/or high
region resolution contribute to a better output, both will also slow
down the kriging calculation.

## EXAMPLES

Kriging example based on elevation map ([North Carolina sample data
set](https://grass.osgeo.org/download/data/)).

**Part 1: random sampling** of 2000 vector points from known elevation
map. Each point will receive the elevation value from the elevation
raster, as if it came from a point survey.

```sh
# reduce resolution for this example
g.region raster=elevation -p res=100
v.random output=rand2k_elev npoints=2000
v.db.addtable map=rand2k_elev columns="elevation double precision"
v.what.rast map=rand2k_elev raster=elevation column=elevation
```

**Part 2: remove points lacking elevation attributes**. Points sampled
at the border of the elevation map didn't receive any value. v.krige has
no preferred action to cope with no data values, so the user must check
for them and decide what to do (remove points, fill with the value of
the nearest point, fill with the global/local mean...). In the following
line of code, points with no data are removed from the map.

```sh
v.extract input=rand2k_elev output=rand2k_elev_filt where="elevation not NULL"
```

Check the result of previous line ("number of NULL attributes" must be
0):

```sh
v.univar map=rand2k_elev_filt type=point column=elevation
```

**Part 3: reconstruct DEM through kriging**. The simplest way to run
*v.krige* from CLI is using automatic variogram fit (note: requires R's
automap package). Output map name is optional, the modules creates it
automatically appending "\_kriging" to the input map name and also
checks for overwrite. If output\_var is specified, the variance map is
also created. Automatic variogram fit is provided by R package automap.
The variogram models tested by the fitting functions are: exponential,
spherical, Gaussian, Matern, M.Stein's parametrisation. A wider range of
models is available from gstat package and can be tested on the GUI via
the variogram plotting. If a model is specified in the CLI, also partial
sill, nugget and range values are to be provided, otherwise an error is
raised (see second example of *v.krige* command).

```sh
# automatic variogram fit
v.krige input=rand2k_elev_filt column=elevation \
        output=rand2k_elev_kriging output_var=rand2k_elev_kriging_var

# define variogram model, create variance map as well
v.krige input=rand2k_elev_filt column=elevation \
        output=rand2k_elev_filt_kriging output_var=rand2k_elev_filt_kriging_var \
        model=Mat psill=2500 nugget=0 range=1000
```

Or run wxGUI, to interactively fit the variogram and explore options:

```sh
v.krige
```

**Calculate prediction error**:

```sh
r.mapcalc "rand2k_elev_kriging_pe = sqrt(rand2k_elev_kriging_var)"
r.univar map=elevation
r.univar map=rand2k_elev_kriging
r.univar map=rand2k_elev_kriging_pe
```

The results show high errors, as the kriging techniques (ordinary and
block kriging) are unable to handle a dataset with a trend, like the one
used in this example: elevation is higher in the southwest corner and
lower on northeast corner. Universal kriging can give far better results
in these cases as it can handle the trend. It is available in R package
gstat and will be part in a future v.krige release.

## SEE ALSO

R package [gstat](https://cran.r-project.org/package=gstat), maintained
by Edzer J. Pebesma and others

R package [rgrass7](https://cran.r-project.org/package=rgrass7),
maintained by Roger Bivand

The [Short Introduction to Geostatistical and Spatial Data Analysis with
GRASS GIS and R statistical data
language](https://grasswiki.osgeo.org/wiki/R_statistics) at the GRASS
Wiki (includes installation tips). It contains a subsection about
**rgrass7**.

v.krige's [wiki
page](https://grasswiki.osgeo.org/wiki/V.krige_GSoC_2009)

Overview: [Interpolation and
Resampling](https://grasswiki.osgeo.org/wiki/Interpolation) in GRASS GIS

## REFERENCES

Isaaks and Srivastava, 1989: "An Introduction to Applied Geostatistics"
(ISBN 0-19-505013-4)

## AUTHOR

Anne Ghisla, Google Summer of Code 2009

## SOURCE CODE

Available at: [v.krige source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.krige)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.krige))  
Latest change: Thursday Mar 20 21:36:57 2025 in commit [7286ecf](https://github.com/OSGeo/grass-addons/commit/7286ecf7af235bfd089fb9b1b82fb383cf95f3fc)
