---
name: v.lidar.mcc.py
description: Reclassifies points of a LiDAR point cloud as ground / non-ground using a multiscale curvature based classification algorithm.
keywords: [ vector, lidar, classification ]
---

# v.lidar.mcc.py

Reclassifies points of a LiDAR point cloud as ground / non-ground using a multiscale curvature based classification algorithm.

=== "Command line"

    **v.lidar.mcc.py**
    [**-n**]
    **input**=*name*
    **ground**=*name*
    **nonground**=*name*
    [**nl**=*integer*]
    [**t**=*float*]
    [**j**=*float*]
    [**f**=*float*]
    [**s**=*integer*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.lidar.mcc.py input=name ground=name nonground=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.lidar.mcc.py***",
        **input**,
        **ground**,
        **nonground**,
        **nl**=*3*,
        **t**=*0.3*,
        **j**=*0.1*,
        **f**=*2*,
        **s**=*10*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.lidar.mcc.py", input="name", ground="name", nonground="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_lidar_mcc_py*(**input**,
        **ground**,
        **nonground**,
        **nl**=*3*,
        **t**=*0.3*,
        **j**=*0.1*,
        **f**=*2*,
        **s**=*10*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_lidar_mcc_py(input="name", ground="name", nonground="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Input point layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector point map  
    **ground**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output ground return points  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector point map containing points classified as ground return  
    **nonground**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output non-ground return points  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector point map containing points NOT classified as ground return  
    **nl**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of scale domains (nl)  
    &nbsp;&nbsp;&nbsp;&nbsp;nl  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **t**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Curvature tolerance threshold (t)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **j**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence threshold (j)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **f**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tension parameter (f)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **s**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spline steps parameter (s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Filter negative outliers (default is positive)  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input point layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector point map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **ground** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output ground return points  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector point map containing points classified as ground return  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **nonground** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output non-ground return points  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector point map containing points NOT classified as ground return  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **nl** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of scale domains (nl)  
    &nbsp;&nbsp;&nbsp;&nbsp;nl  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **t** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Curvature tolerance threshold (t)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **j** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence threshold (j)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **f** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tension parameter (f)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **s** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spline steps parameter (s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Filter negative outliers (default is positive)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input point layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Input vector point map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **ground** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output ground return points  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector point map containing points classified as ground return  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **nonground** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output non-ground return points  
    &nbsp;&nbsp;&nbsp;&nbsp;Output vector point map containing points NOT classified as ground return  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **nl** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of scale domains (nl)  
    &nbsp;&nbsp;&nbsp;&nbsp;nl  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *3*  
    **t** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Curvature tolerance threshold (t)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.3*  
    **j** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Convergence threshold (j)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.1*  
    **f** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Tension parameter (f)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *2*  
    **s** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Spline steps parameter (s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Filter negative outliers (default is positive)  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.lidar.mcc* is a modified implementation of the Multiscale Curvature
Classification (MCC) algorithm proposed by Evans & Hudak 2007.

The aim of the MCC-procedure is to filter non-ground returns caused by
vegetation cover from point clouds produced with any kind of LiDAR
instrument (e.g. also instruments without intensity information).  

The basic principle of the algorithm is to classify those points as
non-ground points which deviate more than a user-defined threshold
(**t**) from a surface which was interpolated from the full point cloud
as a thin plate (here implemented with a bilinear spline interpolation
with Tykhonov regularization through
*[v.outlier](https://grass.osgeo.org/grass-stable/manuals/v.outlier.html)*).
Tension (**f**) and spline steps (**s**) parameter are passed to the
relevant parameters in
*[v.outlier](https://grass.osgeo.org/grass-stable/manuals/v.outlier.html)*.

On each scale domain *v.lidar.mcc* calls
*[v.outlier](https://grass.osgeo.org/grass-stable/manuals/v.outlier.html)*
repeatedly until the algorithm converges, i.e. less than the amount of
points (percentage of input points to the iteration) defined in the
convergence threshold (**j**) are classified as non-ground points. Scale
domains are defined in relation to the current region. With a number of
scale domains **(nl)** greater than 1 scale domains are distributed
evenly "around" the current region. With the default number of three
scale domains, the first scale domaine uses half the resolution of the
current region, scale domain two uses the current region and scale
domain three uses 1,5 times the resolution of the current region.

## NOTES

The optimal settings for the parameters of *v.lidar.mcc* depend very
much on the resolution of the current region and the density of the
LiDAR data, as well as terrain and vegetation. Therefore, a bit of try
and error is usually required in order to find the optimal settings. In
general spline steps (**s**) and curvature tolerance threshold (**t**)
parameters have most influence on the results, where larger spline steps
and a lower curvature tolerance threshold lead to more points clasified
as non-ground points, but possibly also to increased clasification
errors in complex terrain.

The algorithm by Evans & Hudak 2007 was developed for filtering LiDAR
data in dense forest areas where not necessarily all pixels have a
ground return point which is why a simple local minimum filering often
is not sufficient.

In principle the algorithm works also on shrub-vegetation, however due
to the lower vegetation type the curvature threshold will have to be
lowered. In this case special attention should be payed to edges and
peaks in the terrain which may be affected by low curvature tolerance
thresholds. Therfore using a smaller cell size and wider spline steps is
recommended for filtering lower structures like shrubs.

The effect and output of the filtering process can be visually inspected
already during iterations when the resulting layer with non-ground
points is displayed while the classification is running.  
However, especially the first runs on scale domains with a small pixels
size can be relatively time consuming.

## EXAMPLES

Classifying ground points in a LIDAR point cloud:

```sh
# region settings (using an existing raster)
g.region raster=elev_lid792_1m

# import
v.in.lidar -tr input=points.las output=points

# classification
v.lidar.mcc points ground=ground_points nonground=non_ground_points
```

![Ground and non ground points](v_lidar_mcc.png)  
*Figure: Ground points (green) and non ground points (red)*

## SEE ALSO

*[v.surf.bspline](https://grass.osgeo.org/grass-stable/manuals/v.surf.bspline.html),
[v.outlier](https://grass.osgeo.org/grass-stable/manuals/v.outlier.html),
[v.lidar.edgedetection](https://grass.osgeo.org/grass-stable/manuals/v.lidar.edgedetection.html)*

## REFERENCES

Evans, J. S. & Hudak, A. T. 2007: A Multiscale Curvature Algorithm for
Classifying Discrete Return LiDAR in Forested Environments. IEEE
TRANSACTIONS ON GEOSCIENCE AND REMOTE SENSING 45(4): 1029 - 1038.
<https://www.fs.usda.gov/rm/pubs_other/rmrs_2007_evans_j001.pdf>  
<https://sourceforge.net/p/mcclidar/wiki/Home/>

## AUTHOR

Stefan Blumentrath, Norwegian Institute for Nature Research (NINA),
Oslo, Norway

## SOURCE CODE

Available at: [v.lidar.mcc source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.lidar.mcc)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.lidar.mcc))  
Latest change: Thursday Feb 20 20:36:19 2025 in commit [158e314](https://github.com/OSGeo/grass-addons/commit/158e314c788f983e3a448ec1b1ba3f226b5ca3e9)
