---
name: v.profile.points.py
description: Creates a profile (transect) from points
keywords: [ vector, points, profile, transect, lidar, point cloud ]
---

# v.profile.points.py

Creates a profile (transect) from points

=== "Command line"

    **v.profile.points.py**
    [**-z**]
    [**line_input**=*name*]
    [**coordinates**=*east,north* [,*east,north*,...]]
    [**point_input**=*name*]
    [**file_input**=*name*]
    **output**=*name*
    [**width**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.profile.points.py line_input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.profile.points.py***",
        **line_input**=*None*,
        **coordinates**=*None*,
        **point_input**=*None*,
        **file_input**=*None*,
        **output**,
        **width**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.profile.points.py", line_input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_profile_points_py*(**line_input**=*None*,
        **coordinates**=*None*,
        **point_input**=*None*,
        **file_input**=*None*,
        **output**,
        **width**=*None*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_profile_points_py(line_input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **line_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with a single line (with 2 points)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line prepared ahead  
    **coordinates**=*east,north* [,*east,north*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Line coordinates (x,y,x,y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Two pairs of coordinates as an alternative to a vector line  
    **point_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with points  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **file_input**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;LAS (or LAZ) file with a point cloud  
    &nbsp;&nbsp;&nbsp;&nbsp;File to be imported using v.in.lidar  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **width**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of profile in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default with is 5% of the profile length  
    **-z**  
    &nbsp;&nbsp;&nbsp;&nbsp;Start the z coordinates at 0 instead of the actual height  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **line_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with a single line (with 2 points)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line prepared ahead  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line coordinates (x,y,x,y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Two pairs of coordinates as an alternative to a vector line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **point_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with points  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **file_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;LAS (or LAZ) file with a point cloud  
    &nbsp;&nbsp;&nbsp;&nbsp;File to be imported using v.in.lidar  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of profile in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default with is 5% of the profile length  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Start the z coordinates at 0 instead of the actual height  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **line_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with a single line (with 2 points)  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector line prepared ahead  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **coordinates** : list[tuple[float, float]] | tuple[float, float] | list[float] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Line coordinates (x,y,x,y)  
    &nbsp;&nbsp;&nbsp;&nbsp;Two pairs of coordinates as an alternative to a vector line  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, coords, *east,north*  
    **point_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector map with points  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **file_input** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;LAS (or LAZ) file with a point cloud  
    &nbsp;&nbsp;&nbsp;&nbsp;File to be imported using v.in.lidar  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **width** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width of profile in map units  
    &nbsp;&nbsp;&nbsp;&nbsp;Default with is 5% of the profile length  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *z*  
    &nbsp;&nbsp;&nbsp;&nbsp;**z**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Start the z coordinates at 0 instead of the actual height  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.profile.points* creates profile (transect) from vector point map or a
lidar point cloud stored in a LAS file.

![image-alt](v_profile_points.png)  
*Figure: Profile (transect) of a lidar point cloud, closer points are
darker, further points are lighter*

### Workflow in GUI

First Map Display should contain some base layers such as point density
raster or digital elevation model. First Map Display should contain the
resulting profile or profiles. Optionally a grid overlay can be added.
The "Zoom to selected map layers" button in the Map Display toolbar
should be used to zoom to the newly created profile. The **coordinates**
option in the Line tab can be activated, deactivated, or cleared during
the work as need.

[![image-alt](v_profile_points_workspace.png)](v_profile_points_workspace.png)  
*Figure: Creating the profile in GUI: running module from the top left
window; selecting line points in the Map Display in the top right;
resulting profile in the bottom.*

## NOTES

ASCII files such as CSV can be profiled after import and raster maps can
be profiles after conversion to vector points. It is advantageous to
limit the import or the conversion just to the area of interest to avoid
unnecessary overhead.

## EXAMPLE

```sh
v.profile.points input_file=.../points.las output=points_profile width=5 \
    coord=2090904,731231,2091435,731252
```

## AUTHOR

Vaclav Petras, [NCSU GeoForAll
Lab](https://geospatial.ncsu.edu/geoforall/)

## SOURCE CODE

Available at: [v.profile.points source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.profile.points)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.profile.points))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
