---
name: v.stream.profiler.py
description: Build a linked stream network: each link knows its downstream link
keywords: [ vector, stream network, hydrology, geomorphology ]
---

# v.stream.profiler.py

Build a linked stream network: each link knows its downstream link

=== "Command line"

    **v.stream.profiler.py**
    **cat**=*string*
    **streams**=*name*
    [**outstream**=*name*]
    [**direction**=*string*]
    [**elevation**=*name*]
    [**accumulation**=*name*]
    [**slope**=*name*]
    [**units**=*string*]
    [**accum_mult**=*float*]
    [**window**=*name*]
    [**plots**=*string* [,*string*,...]]
    [**outfile_original**=*string*]
    [**outfile_smoothed**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.stream.profiler.py cat=string streams=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.stream.profiler.py***",
        **cat**,
        **streams**,
        **outstream**=*None*,
        **direction**=*"downstream"*,
        **elevation**=*None*,
        **accumulation**=*None*,
        **slope**=*None*,
        **units**=*None*,
        **accum_mult**=*1*,
        **window**=*None*,
        **plots**=*None*,
        **outfile_original**=*None*,
        **outfile_smoothed**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.stream.profiler.py", cat="string", streams="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_stream_profiler_py*(**cat**,
        **streams**,
        **outstream**=*None*,
        **direction**=*"downstream"*,
        **elevation**=*None*,
        **accumulation**=*None*,
        **slope**=*None*,
        **units**=*None*,
        **accum_mult**=*1*,
        **window**=*None*,
        **plots**=*None*,
        **outfile_original**=*None*,
        **outfile_smoothed**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_stream_profiler_py(cat="string", streams="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **cat**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Starting line segment category  
    **streams**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector input of stream network created by r.stream.extract  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **outstream**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector output stream  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **direction**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Which directon to march: up or down  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *upstream, downstream*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *downstream*  
    **elevation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Topography (DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **accumulation**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow accumulation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **slope**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of slope created by r.slope.area  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **units**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow accumulation units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m2,  km2,  cumecs,  cfs*  
    **accum_mult**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiplier to convert flow accumulation to your chosen unit  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **window**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Averaging distance [map units]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    **plots**=*string* [,*string*,...]  
    &nbsp;&nbsp;&nbsp;&nbsp;Plots to generate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *LongProfile, SlopeAccum, SlopeDistance, AccumDistance*  
    **outfile_original**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;output file for data on original grid  
    **outfile_smoothed**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;output file for data on smoothed grid  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **cat** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Starting line segment category  
    **streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector input of stream network created by r.stream.extract  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **outstream** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector output stream  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **direction** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Which directon to march: up or down  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *upstream, downstream*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *downstream*  
    **elevation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Topography (DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **accumulation** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow accumulation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slope** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of slope created by r.slope.area  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow accumulation units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m2,  km2,  cumecs,  cfs*  
    **accum_mult** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiplier to convert flow accumulation to your chosen unit  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **window** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Averaging distance [map units]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plots** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plots to generate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *LongProfile, SlopeAccum, SlopeDistance, AccumDistance*  
    **outfile_original** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;output file for data on original grid  
    **outfile_smoothed** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;output file for data on smoothed grid  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **cat** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Starting line segment category  
    **streams** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector input of stream network created by r.stream.extract  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **outstream** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector output stream  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **direction** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Which directon to march: up or down  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *upstream, downstream*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *downstream*  
    **elevation** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Topography (DEM)  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **accumulation** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow accumulation raster  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **slope** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Map of slope created by r.slope.area  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **units** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Flow accumulation units  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *m2,  km2,  cumecs,  cfs*  
    **accum_mult** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Multiplier to convert flow accumulation to your chosen unit  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **window** : str | np.ndarray, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Averaging distance [map units]  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input raster map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **plots** : str | list[str], *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Plots to generate  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *LongProfile, SlopeAccum, SlopeDistance, AccumDistance*  
    **outfile_original** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;output file for data on original grid  
    **outfile_smoothed** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;output file for data on smoothed grid  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.stream.profiler* builds and exports plots and data sets of river long
profiles, slope-accumulation (e.g., slope-area), and more for
topographic analysis. It currently works only in a downstream-directed
walk, for a single channel, from the chosen segment until the
downstream-most point in the network. It takes in the adjacency
structure supplied by [v.stream.network](v.stream.network).

## REFERENCES

None (yet)

## SEE ALSO

*[v.stream.network](https://grass.osgeo.org/grass-stable/manuals/addons/v.stream.network.html)*

## AUTHOR

Andrew D. Wickert

## SOURCE CODE

Available at: [v.stream.profiler source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/vector/v.stream.profiler)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/vector/v.stream.profiler))  
Latest change: Friday Nov 21 23:30:51 2025 in commit [f365f4c](https://github.com/OSGeo/grass-addons/commit/f365f4cd9a20a2566cebc5dc60a566b93cec21c6)
