---
name: v.voronoi
description: Creates a Voronoi diagram constrained to the extents of the current region from an input vector map containing points or centroids.
keywords: [ vector, geometry, triangulation, skeleton ]
---

# v.voronoi

Creates a Voronoi diagram constrained to the extents of the current region from an input vector map containing points or centroids.

=== "Command line"

    **v.voronoi**
    [**-aslt**]
    **input**=*name*
    [**layer**=*string*]
    **output**=*name*
    [**smoothness**=*float*]
    [**thin**=*float*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.voronoi input=name output=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.voronoi***",
        **input**,
        **layer**=*"-1"*,
        **output**,
        **smoothness**=*0.25*,
        **thin**=*-1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.voronoi", input="name", output="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_voronoi*(**input**,
        **layer**=*"-1"*,
        **output**,
        **smoothness**=*0.25*,
        **thin**=*-1*,
        **flags**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_voronoi(input="name", output="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **input**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    **smoothness**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor for output smoothness  
    &nbsp;&nbsp;&nbsp;&nbsp;Applies to input areas only. Smaller values produce smoother output but can cause numerical instability.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **thin**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum dangle length of skeletons  
    &nbsp;&nbsp;&nbsp;&nbsp;Applies only to skeleton extraction. Default = -1 will extract the center line.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **-a**  
    &nbsp;&nbsp;&nbsp;&nbsp;Create Voronoi diagram for input areas  
    **-s**  
    &nbsp;&nbsp;&nbsp;&nbsp;Extract skeletons for input areas  
    **-l**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output tessellation as a graph (lines), not areas  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **smoothness** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor for output smoothness  
    &nbsp;&nbsp;&nbsp;&nbsp;Applies to input areas only. Smaller values produce smoother output but can cause numerical instability.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **thin** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum dangle length of skeletons  
    &nbsp;&nbsp;&nbsp;&nbsp;Applies only to skeleton extraction. Default = -1 will extract the center line.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *s*, *l*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create Voronoi diagram for input areas  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extract skeletons for input areas  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output tessellation as a graph (lines), not areas  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **input** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of input vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name ('-1' for all layers)  
    &nbsp;&nbsp;&nbsp;&nbsp;A single vector map can be connected to multiple database tables. This number determines which table to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **output** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name for output vector map  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, vector, *name*  
    **smoothness** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Factor for output smoothness  
    &nbsp;&nbsp;&nbsp;&nbsp;Applies to input areas only. Smaller values produce smoother output but can cause numerical instability.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.25*  
    **thin** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum dangle length of skeletons  
    &nbsp;&nbsp;&nbsp;&nbsp;Applies only to skeleton extraction. Default = -1 will extract the center line.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *-1*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *a*, *s*, *l*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**a**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Create Voronoi diagram for input areas  
    &nbsp;&nbsp;&nbsp;&nbsp;**s**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Extract skeletons for input areas  
    &nbsp;&nbsp;&nbsp;&nbsp;**l**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Output tessellation as a graph (lines), not areas  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Do not create attribute table  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.voronoi* creates a Voronoi diagram (Thiessen polygons) from points or
centroids.

The bounds of the output map are limited by the current region (see
*[g.region](g.region.md)*).

The *-a* flag can be used to create a Voronoi diagram for areas.

The *-s* flag can be used to extract the center line of areas or
skeletons of areas with *thin* \>= 0. Smaller values for the *thin*
option will preserve more detail, while negative values will extract
only the center line.

## NOTES

*v.voronoi* suffers from numerical instability, results can sometimes
contain many artefacts. When creating Voronoi diagrams for areas or
skeletons for areas, it is highly recommended to simplify the areas
first with *[v.generalize](v.generalize.md)*.

Voronoi diagrams may be used for nearest-neighbor flood filling. Give
the centroids attributes (start with
*[v.db.addcolumn](v.db.addcolumn.md)*), then optionally convert the
result to a raster map with *[v.to.rast](v.to.rast.md)*.

The extraction of skeletons and center lines with the *-s* flag is a
brute force approach. Faster and more accurate algorithms to extract
skeletons from areas exist but are not yet implemented. In the meantime,
skeletons and center lines can be simplified with the Douglas-Peucker
algorithm: *[v.generalize method=douglas](v.generalize.md)*.

## EXAMPLE

### Voronoi diagram for points

This example uses the hospitals in the North Carolina dataset.

```sh
g.region -p raster=elev_state_500m
v.voronoi input=hospitals output=hospitals_voronoi
```

Result:

![Voronoi diagram for hospitals in North Carolina](v_voronoi_points.png)  
*Voronoi diagram for hospitals in North Carolina*

### Voronoi diagram for areas

This example uses urban areas in the North Carolina dataset.

```sh
g.region -p n=162500 s=80000 w=727000 e=846000 res=500
v.voronoi input=urbanarea output=urbanarea_voronoi -a
```

Result:

![Voronoi diagram for urban areas in North Carolina](v_voronoi_areas.png)  
*Voronoi diagram for urban areas in North Carolina*

### Skeletons and center lines of areas

This example uses urban areas in the North Carolina dataset.

```sh
g.region -p n=161000 s=135500 w=768500 e=805500 res=500
v.voronoi input=urbanarea output=urbanarea_centerline -s
v.voronoi input=urbanarea output=urbanarea_skeleton -s thin=2000
```

Result:

![Skeleton and center line for urban areas in North Carolina](v_voronoi_skeleton.png)  
*Skeleton (blue) and center line (red) for urban areas in North Carolina*

## REFERENCES

*Steve J. Fortune, (1987). A Sweepline Algorithm for Voronoi Diagrams,
Algorithmica 2, 153-174 ([DOI](https://doi.org/10.1007/BF01840357)).*

## SEE ALSO

*[g.region](g.region.md), [v.delaunay](v.delaunay.md),
[v.hull](v.hull.md)*

[Voronoi diagram
(Wikipedia)](https://en.wikipedia.org/wiki/Voronoi_diagram)

## AUTHORS

James Darrell McCauley, Purdue University  
GRASS 5 update, improvements: [Andrea Aime](mailto:aaime@libero.it),
Modena, Italy  
GRASS 5.7 update: Radim Blazek  
Markus Metz

## SOURCE CODE

Available at: [v.voronoi source code](https://github.com/OSGeo/grass/tree/main/vector/v.voronoi)
([history](https://github.com/OSGeo/grass/commits/main/vector/v.voronoi))  
Latest change: Sunday Jul 27 05:53:30 2025 in commit [da40958](https://github.com/OSGeo/grass/commit/da409580ef15011f3bac379c76d41101c9e36347)
