---
name: v.what.vect.py
description: Uploads vector values at positions of vector points to the table.
keywords: [ vector, sampling, database, position, querying, attribute table ]
---

# v.what.vect.py

Uploads vector values at positions of vector points to the table.

=== "Command line"

    **v.what.vect.py**
    **map**=*name*
    [**layer**=*string*]
    **column**=*name*
    **query_map**=*name*
    [**query_layer**=*string*]
    **query_column**=*name*
    [**dmax**=*float*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    v.what.vect.py map=name column=name query_map=name query_column=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***v.what.vect.py***",
        **map**,
        **layer**=*"1"*,
        **column**,
        **query_map**,
        **query_layer**=*"1"*,
        **query_column**,
        **dmax**=*0.0*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("v.what.vect.py", map="name", column="name", query_map="name", query_column="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.v_what_vect_py*(**map**,
        **layer**=*"1"*,
        **column**,
        **query_map**,
        **query_layer**=*"1"*,
        **query_column**,
        **dmax**=*0.0*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.v_what_vect_py(map="name", column="name", query_map="name", query_column="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for which to edit attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be updated with the query result  
    **query_map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    **query_layer**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **query_column**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be queried  
    **dmax**=*float*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum query distance in map units (meters for ll)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for which to edit attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be updated with the query result  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **query_map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **query_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **query_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **dmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum query distance in map units (meters for ll)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector points map for which to edit attributes  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be updated with the query result  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **query_map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of vector map to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Or data source for direct OGR access  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *name*  
    **query_layer** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Layer number or name  
    &nbsp;&nbsp;&nbsp;&nbsp;Vector features can have category values in different layers. This number determines which layer to use. When used with direct OGR access this is the layer name.  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, layer  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *1*  
    **query_column** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute column to be queried  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbcolumn, *name*  
    **dmax** : float, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Maximum query distance in map units (meters for ll)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *0.0*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*v.what.vect* transfers attributes from the **query_map**'s attribute
table into the **map**'s attribute table. The module can be used to
transfer attributes from the table of a polygon map into the attribute
table of a point vector map, as well as the other way around, i.e., from
a point map into the attribute table of a polygon map (See examples).
The script is based on *v.distance*.

## NOTES

The upload **column** into which the query results are stored must be
present in **map**. Use *v.db.addcolumn* to add one if needed.

Use the **dmax** parameter to control the query distance tolerance,
i.e., how far **map**'s points/centroids can be from the **query_map**
features. For further options, use *v.distance*.

In case of a multipoint input **map** with several points having the
same category number, it can happen that the query result is NULL if the
same category number falls into different **query_map** polygons.

When transferring attributes from a point map into a polygon map,
**dmax** has to be larger than zero, i.e., it will be determined by the
distance between query points and polygon centroids. Importantly,
distance is in meters for latitude-longitude projects.

In case that one or both input vector maps are 3D, features need to
touch also in the 3rd dimension (z coordinate) in order to transfer
attributes.

## EXAMPLES

In this example, the 'hospitals' point map in the North Carolina dataset
is copied to the current mapset, a new attribute column is added and the
urban names from the 'urbanarea' polygon map are transferred to hospital
points locations in 'myhospitals' map:

```sh
g.copy vect=hospitals,myhospitals
v.db.addcolumn myhospitals column="urb_name varchar(25)"
v.what.vect myhospitals query_map=urbanarea column=urb_name query_column=NAME
# verification:
v.db.select myhospitals
```

In this example, city names, population data and others from
[Geonames.org country files](https://download.geonames.org/export/dump/)
are transferred to selected EU CORINE landuse/landcover classes
("Continuous urban fabric", 111, and "Discontinuous urban fabric", 112).
Note: The example is in UTM projection to which the input maps have been
projected beforehand.

```sh
# extract populated places from geonames
v.extract geonames_IT where="featurecla='P'" output=geonames_IT_cities
# add new column
v.db.addcol corine_code111_112_cities column="gnameid double precision"
# transfer geonameid (3000m maximal distance between points and centroids)
v.what.vect corine_code111_112_cities query_map=geonames_IT_cities column=gnameid \
            query_column=geonameid dmax=3000
# now gnameid can be used for v.db.join to join further
# attributes from geonames.org
```

## SEE ALSO

*[v.db.addcolumn](v.db.addcolumn.md), [v.db.select](v.db.select.md),
[v.distance](v.distance.md), [v.rast.stats](v.rast.stats.md),
[v.what.rast](v.what.rast.md), [v.what.rast3](v.what.rast3.md),
[v.vect.stats](v.vect.stats.md)*

## AUTHOR

Markus Neteler

## SOURCE CODE

Available at: [v.what.vect source code](https://github.com/OSGeo/grass/tree/main/scripts/v.what.vect)
([history](https://github.com/OSGeo/grass/commits/main/scripts/v.what.vect))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
