<style>
.img-list {
    margin: 0;
    padding: 0;
    list-style-type: none;
}

.img-list li {
    padding: 5px;
    overflow: auto;
}

.img-list li:hover {
    background-color: #eee;
}

.img-list li a {
    color: initial;
    text-decoration: none;
    display: block;
}

.img-list li img {
    width: 10%;
    float: left;
    margin: 0 15px 0 0;
    background: white;
    object-fit: scale-down;
}

.img-list li img.default-img {
    max-height: 5ex;
    background-color: var(--gs-primary-color);
    padding: 5px;
}

.img-list li .desc {
    margin: 0px;
}

.img-list li .name {
    margin: 5px;
    display: block;
    color: #409940;
    font-weight: bold;
    font-style: italic;
}
</style>
Go to <a href="vectorintro.html">vector introduction</a> | <a href="topics.html">topics</a> <p>
# Vector tools
<ul class="img-list"><li><a href="v.buffer.html"><img class="linkimg" src="v_buffer_area.png"></a><a href="v.buffer.html"><span class="name">v.buffer</span> <span class="desc">Creates a buffer around vector features of given type.</span></a></li><li><a href="v.build.all.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.build.all.html"><span class="name">v.build.all</span> <span class="desc">Rebuilds topology on all vector maps in the current mapset.</span></a></li><li><a href="v.build.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.build.html"><span class="name">v.build</span> <span class="desc">Creates topology for vector map. Optionally also checks for topological errors.</span></a></li><li><a href="v.build.polylines.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.build.polylines.html"><span class="name">v.build.polylines</span> <span class="desc">Builds polylines from lines or boundaries.</span></a></li><li><a href="v.category.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.category.html"><span class="name">v.category</span> <span class="desc">Attaches, deletes or reports vector categories to/from/of map geometry.</span></a></li><li><a href="v.centroids.html"><img class="linkimg" src="v_centroids.png"></a><a href="v.centroids.html"><span class="name">v.centroids</span> <span class="desc">Adds missing centroids to closed boundaries.</span></a></li><li><a href="v.class.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.class.html"><span class="name">v.class</span> <span class="desc">Classifies attribute data, e.g. for thematic mapping</span></a></li><li><a href="v.clean.html"><img class="linkimg" src="v_clean.png"></a><a href="v.clean.html"><span class="name">v.clean</span> <span class="desc">Toolset for cleaning topology of vector map.</span></a></li><li><a href="v.clip.html"><img class="linkimg" src="v_clip_poly.png"></a><a href="v.clip.html"><span class="name">v.clip</span> <span class="desc">Extracts features of input map which overlay features of clip map.</span></a></li><li><a href="v.cluster.html"><img class="linkimg" src="v_cluster_4_methods.png"></a><a href="v.cluster.html"><span class="name">v.cluster</span> <span class="desc">Performs cluster identification.</span></a></li><li><a href="v.colors.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.colors.html"><span class="name">v.colors</span> <span class="desc">Creates/modifies the color table associated with a vector map.</span></a></li><li><a href="v.colors.out.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.colors.out.html"><span class="name">v.colors.out</span> <span class="desc">Exports the color table associated with a vector map.</span></a></li><li><a href="v.db.addcolumn.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.addcolumn.html"><span class="name">v.db.addcolumn</span> <span class="desc">Adds one or more columns to the attribute table connected to a given vector map.</span></a></li><li><a href="v.db.addtable.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.addtable.html"><span class="name">v.db.addtable</span> <span class="desc">Creates and connects a new attribute table to a given layer of an existing vector map.</span></a></li><li><a href="v.db.connect.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.connect.html"><span class="name">v.db.connect</span> <span class="desc">Prints/sets DB connection for a vector map to attribute table.</span></a></li><li><a href="v.db.dropcolumn.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.dropcolumn.html"><span class="name">v.db.dropcolumn</span> <span class="desc">Drops a column from the attribute table connected to a given vector map.</span></a></li><li><a href="v.db.droprow.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.droprow.html"><span class="name">v.db.droprow</span> <span class="desc">Removes a vector feature from a vector map through attribute selection.</span></a></li><li><a href="v.db.droptable.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.droptable.html"><span class="name">v.db.droptable</span> <span class="desc">Removes existing attribute table of a vector map.</span></a></li><li><a href="v.db.join.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.join.html"><span class="name">v.db.join</span> <span class="desc">Joins a database table to a vector map table.</span></a></li><li><a href="v.db.reconnect.all.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.reconnect.all.html"><span class="name">v.db.reconnect.all</span> <span class="desc">Reconnects attribute tables for all vector maps from the current mapset to a new database.</span></a></li><li><a href="v.db.renamecolumn.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.renamecolumn.html"><span class="name">v.db.renamecolumn</span> <span class="desc">Renames a column in the attribute table connected to a given vector map.</span></a></li><li><a href="v.db.select.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.select.html"><span class="name">v.db.select</span> <span class="desc">Prints vector map attributes.</span></a></li><li><a href="v.db.univar.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.univar.html"><span class="name">v.db.univar</span> <span class="desc">Calculates univariate statistics on selected table column for a GRASS vector map.</span></a></li><li><a href="v.db.update.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.db.update.html"><span class="name">v.db.update</span> <span class="desc">Updates a column in the attribute table connected to a vector map.</span></a></li><li><a href="v.decimate.html"><img class="linkimg" src="v_decimate_count.png"></a><a href="v.decimate.html"><span class="name">v.decimate</span> <span class="desc">Decimates a point cloud Copies points from one vector to another while applying different decimations</span></a></li><li><a href="v.delaunay.html"><img class="linkimg" src="v_delaunay.png"></a><a href="v.delaunay.html"><span class="name">v.delaunay</span> <span class="desc">Creates a Delaunay triangulation from an input vector map containing points or centroids.</span></a></li><li><a href="v.dissolve.html"><img class="linkimg" src="v_dissolve_towns.png"></a><a href="v.dissolve.html"><span class="name">v.dissolve</span> <span class="desc">Dissolves adjacent or overlapping features sharing a common category number or attribute.</span></a></li><li><a href="v.distance.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.distance.html"><span class="name">v.distance</span> <span class="desc">Finds the nearest element in vector map 'to' for elements in vector map 'from'.</span></a></li><li><a href="v.drape.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.drape.html"><span class="name">v.drape</span> <span class="desc">Converts 2D vector features to 3D by sampling of elevation raster map.</span></a></li><li><a href="v.edit.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.edit.html"><span class="name">v.edit</span> <span class="desc">Edits a vector map, allows adding, deleting and modifying selected vector features.</span></a></li><li><a href="v.external.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.external.html"><span class="name">v.external</span> <span class="desc">Creates a new pseudo-vector map as a link to an OGR-supported layer or a PostGIS feature table.</span></a></li><li><a href="v.external.out.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.external.out.html"><span class="name">v.external.out</span> <span class="desc">Defines vector output format.</span></a></li><li><a href="v.extract.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.extract.html"><span class="name">v.extract</span> <span class="desc">Selects vector features from an existing vector map and creates a new vector map containing only the selected features.</span></a></li><li><a href="v.extrude.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.extrude.html"><span class="name">v.extrude</span> <span class="desc">Extrudes flat vector features to 3D vector features with defined height. Optionally the height can be derived from sampling of elevation raster map.</span></a></li><li><a href="v.fill.holes.html"><img class="linkimg" src="v_fill_holes.png"></a><a href="v.fill.holes.html"><span class="name">v.fill.holes</span> <span class="desc">Fill holes in areas by keeping only outer boundaries</span></a></li><li><a href="v.generalize.html"><img class="linkimg" src="v_generalize_smooth.png"></a><a href="v.generalize.html"><span class="name">v.generalize</span> <span class="desc">Performs vector based generalization.</span></a></li><li><a href="v.hull.html"><img class="linkimg" src="v_hull.png"></a><a href="v.hull.html"><span class="name">v.hull</span> <span class="desc">Produces a 2D/3D convex hull for a given vector map.</span></a></li><li><a href="v.import.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.import.html"><span class="name">v.import</span> <span class="desc">Imports vector data into a GRASS vector map using OGR library and reprojects on the fly.</span></a></li><li><a href="v.in.ascii.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.ascii.html"><span class="name">v.in.ascii</span> <span class="desc">Creates a vector map from an ASCII points file or ASCII vector file.</span></a></li><li><a href="v.in.db.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.db.html"><span class="name">v.in.db</span> <span class="desc">Creates new vector (points) map from database table containing coordinates.</span></a></li><li><a href="v.in.dxf.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.dxf.html"><span class="name">v.in.dxf</span> <span class="desc">Converts file in DXF format to GRASS vector map.</span></a></li><li><a href="v.in.e00.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.e00.html"><span class="name">v.in.e00</span> <span class="desc">Imports E00 file into a vector map.</span></a></li><li><a href="v.in.geonames.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.geonames.html"><span class="name">v.in.geonames</span> <span class="desc">Imports geonames.org country files into a vector points map.</span></a></li><li><a href="v.in.lidar.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.lidar.html"><span class="name">v.in.lidar</span> <span class="desc">Converts LAS LiDAR point clouds to a GRASS vector map with libLAS.</span></a></li><li><a href="v.in.lines.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.lines.html"><span class="name">v.in.lines</span> <span class="desc">Imports ASCII x,y[,z] coordinates as a series of lines.</span></a></li><li><a href="v.in.mapgen.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.mapgen.html"><span class="name">v.in.mapgen</span> <span class="desc">Imports Mapgen or Matlab-ASCII vector maps into GRASS.</span></a></li><li><a href="v.in.ogr.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.ogr.html"><span class="name">v.in.ogr</span> <span class="desc">Imports vector data into a GRASS vector map using OGR library.</span></a></li><li><a href="v.in.region.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.region.html"><span class="name">v.in.region</span> <span class="desc">Creates a vector polygon from the current region extent.</span></a></li><li><a href="v.in.wfs.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.in.wfs.html"><span class="name">v.in.wfs</span> <span class="desc">Imports GetFeature from a WFS server.</span></a></li><li><a href="v.info.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.info.html"><span class="name">v.info</span> <span class="desc">Outputs basic information about a vector map.</span></a></li><li><a href="v.kcv.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.kcv.html"><span class="name">v.kcv</span> <span class="desc">Randomly partition points into test/train sets.</span></a></li><li><a href="v.kernel.html"><img class="linkimg" src="v_kernel.png"></a><a href="v.kernel.html"><span class="name">v.kernel</span> <span class="desc">Generates a raster density map from vector points map. Density is computed using a moving kernel. Optionally generates a vector density map on a vector network.</span></a></li><li><a href="v.label.html"><img class="linkimg" src="v_label_sa.jpg"></a><a href="v.label.html"><span class="name">v.label</span> <span class="desc">Creates paint labels for a vector map from attached attributes.</span></a></li><li><a href="v.label.sa.html"><img class="linkimg" src="v_label_sa.jpg"></a><a href="v.label.sa.html"><span class="name">v.label.sa</span> <span class="desc">Create optimally placed labels for vector map(s)</span></a></li><li><a href="v.lidar.correction.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.lidar.correction.html"><span class="name">v.lidar.correction</span> <span class="desc">Corrects the v.lidar.growing output. It is the last of the three algorithms for LIDAR filtering.</span></a></li><li><a href="v.lidar.edgedetection.html"><img class="linkimg" src="v_lidar_edgedetection.png"></a><a href="v.lidar.edgedetection.html"><span class="name">v.lidar.edgedetection</span> <span class="desc">Detects the object's edges from a LIDAR data set.</span></a></li><li><a href="v.lidar.growing.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.lidar.growing.html"><span class="name">v.lidar.growing</span> <span class="desc">Building contour determination and Region Growing algorithm for determining the building inside</span></a></li><li><a href="v.lrs.create.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.lrs.create.html"><span class="name">v.lrs.create</span> <span class="desc">Creates a linear reference system.</span></a></li><li><a href="v.lrs.label.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.lrs.label.html"><span class="name">v.lrs.label</span> <span class="desc">Creates stationing from input lines, and linear reference system.</span></a></li><li><a href="v.lrs.segment.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.lrs.segment.html"><span class="name">v.lrs.segment</span> <span class="desc">Creates points/segments from input lines, linear reference system and positions read from stdin or a file.</span></a></li><li><a href="v.lrs.where.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.lrs.where.html"><span class="name">v.lrs.where</span> <span class="desc">Finds line id and real km+offset for given points in vector map using linear reference system.</span></a></li><li><a href="v.mkgrid.html"><img class="linkimg" src="v_mkgrid.png"></a><a href="v.mkgrid.html"><span class="name">v.mkgrid</span> <span class="desc">Creates a vector map of a user-defined grid.</span></a></li><li><a href="v.neighbors.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.neighbors.html"><span class="name">v.neighbors</span> <span class="desc">Neighborhood analysis tool for vector point maps. Makes each cell value a function of the attribute values assigned to the vector points or centroids in a radius around it, and stores new cell values in an output raster map.</span></a></li><li><a href="v.net.alloc.html"><img class="linkimg" src="v_net_alloc.png"></a><a href="v.net.alloc.html"><span class="name">v.net.alloc</span> <span class="desc">Allocates subnets for nearest centers. Center node must be opened (costs >= 0). Costs of center node are used in calculation.</span></a></li><li><a href="v.net.allpairs.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.net.allpairs.html"><span class="name">v.net.allpairs</span> <span class="desc">Computes the shortest path between all pairs of nodes in the network.</span></a></li><li><a href="v.net.bridge.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.net.bridge.html"><span class="name">v.net.bridge</span> <span class="desc">Computes bridges and articulation points in the network.</span></a></li><li><a href="v.net.centrality.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.net.centrality.html"><span class="name">v.net.centrality</span> <span class="desc">Computes degree, centrality, betweeness, closeness and eigenvector centrality measures in the network.</span></a></li><li><a href="v.net.components.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.net.components.html"><span class="name">v.net.components</span> <span class="desc">Computes strongly and weakly connected components in the network.</span></a></li><li><a href="v.net.connectivity.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.net.connectivity.html"><span class="name">v.net.connectivity</span> <span class="desc">Computes vertex connectivity between two sets of nodes in the network.</span></a></li><li><a href="v.net.distance.html"><img class="linkimg" src="vnetdistance.png"></a><a href="v.net.distance.html"><span class="name">v.net.distance</span> <span class="desc">Computes shortest distance via the network between the given sets of features. Finds the shortest paths from each 'from' point to the nearest 'to' feature and various information about this relation are uploaded to the attribute table.</span></a></li><li><a href="v.net.flow.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.net.flow.html"><span class="name">v.net.flow</span> <span class="desc">Computes the maximum flow between two sets of nodes in the network.</span></a></li><li><a href="v.net.iso.html"><img class="linkimg" src="vnetiso.png"></a><a href="v.net.iso.html"><span class="name">v.net.iso</span> <span class="desc">Splits subnets for nearest centers by cost isolines. Splits net to bands between cost isolines (direction from center). Center node must be opened (costs >= 0). Costs of center node are used in calculation.</span></a></li><li><a href="v.net.html"><img class="linkimg" src="vnetiso.png"></a><a href="v.net.html"><span class="name">v.net</span> <span class="desc">Performs network maintenance.</span></a></li><li><a href="v.net.path.html"><img class="linkimg" src="vnetpath.png"></a><a href="v.net.path.html"><span class="name">v.net.path</span> <span class="desc">Finds shortest path on vector network.</span></a></li><li><a href="v.net.salesman.html"><img class="linkimg" src="vnetsalesman.png"></a><a href="v.net.salesman.html"><span class="name">v.net.salesman</span> <span class="desc">Creates a cycle connecting given nodes (Traveling salesman problem). Note that TSP is NP-hard, heuristic algorithm is used by this module and created cycle may be sub optimal</span></a></li><li><a href="v.net.spanningtree.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.net.spanningtree.html"><span class="name">v.net.spanningtree</span> <span class="desc">Computes minimum spanning tree for the network.</span></a></li><li><a href="v.net.steiner.html"><img class="linkimg" src="vnetsteiner.png"></a><a href="v.net.steiner.html"><span class="name">v.net.steiner</span> <span class="desc">Creates Steiner tree for the network and given terminals. Note that 'Minimum Steiner Tree' problem is NP-hard and heuristic algorithm is used in this module so the result may be sub optimal.</span></a></li><li><a href="v.net.timetable.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.net.timetable.html"><span class="name">v.net.timetable</span> <span class="desc">Finds shortest path using timetables.</span></a></li><li><a href="v.net.visibility.html"><img class="linkimg" src="v_net_visibility.png"></a><a href="v.net.visibility.html"><span class="name">v.net.visibility</span> <span class="desc">Performs visibility graph construction.</span></a></li><li><a href="v.normal.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.normal.html"><span class="name">v.normal</span> <span class="desc">Tests for normality for vector points.</span></a></li><li><a href="v.out.ascii.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.out.ascii.html"><span class="name">v.out.ascii</span> <span class="desc">Exports a vector map to a GRASS ASCII vector representation. By default only features with category are exported. To export all features use 'layer=-1'.</span></a></li><li><a href="v.out.dxf.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.out.dxf.html"><span class="name">v.out.dxf</span> <span class="desc">Exports vector map to DXF file format.</span></a></li><li><a href="v.out.lidar.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.out.lidar.html"><span class="name">v.out.lidar</span> <span class="desc">Exports vector points as LAS point cloud Converts LAS LiDAR point clouds to a GRASS vector map with libLAS</span></a></li><li><a href="v.out.ogr.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.out.ogr.html"><span class="name">v.out.ogr</span> <span class="desc">Exports a vector map layer to any of the supported OGR vector formats. By default a vector map layer is exported to OGC GeoPackage format.</span></a></li><li><a href="v.out.pov.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.out.pov.html"><span class="name">v.out.pov</span> <span class="desc">Converts GRASS x,y,z points to POV-Ray x,z,y format.</span></a></li><li><a href="v.out.svg.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.out.svg.html"><span class="name">v.out.svg</span> <span class="desc">Exports a vector map to SVG file.</span></a></li><li><a href="v.out.vtk.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.out.vtk.html"><span class="name">v.out.vtk</span> <span class="desc">Converts a vector map to VTK ASCII output.</span></a></li><li><a href="v.outlier.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.outlier.html"><span class="name">v.outlier</span> <span class="desc">Removes outliers from vector point data.</span></a></li><li><a href="v.overlay.html"><img class="linkimg" src="v_overlay_op_or.png"></a><a href="v.overlay.html"><span class="name">v.overlay</span> <span class="desc">Overlays two vector maps offering clip, intersection, difference, symmetrical difference, union operators.</span></a></li><li><a href="v.pack.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.pack.html"><span class="name">v.pack</span> <span class="desc">Exports a vector map as GRASS specific archive file</span></a></li><li><a href="v.parallel.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.parallel.html"><span class="name">v.parallel</span> <span class="desc">Creates parallel line to input vector lines.</span></a></li><li><a href="v.patch.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.patch.html"><span class="name">v.patch</span> <span class="desc">Creates a new vector map by combining other vector maps.</span></a></li><li><a href="v.perturb.html"><img class="linkimg" src="v_perturb_normal.png"></a><a href="v.perturb.html"><span class="name">v.perturb</span> <span class="desc">Random location perturbations of vector points.</span></a></li><li><a href="v.profile.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.profile.html"><span class="name">v.profile</span> <span class="desc">Vector map profiling tool</span></a></li><li><a href="v.proj.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.proj.html"><span class="name">v.proj</span> <span class="desc">Re-projects a vector map from one project to the current project.</span></a></li><li><a href="v.qcount.html"><img class="linkimg" src="v_qcount_1.png"></a><a href="v.qcount.html"><span class="name">v.qcount</span> <span class="desc">Indices for quadrat counts of vector point lists.</span></a></li><li><a href="v.random.html"><img class="linkimg" src="vrandom_z.png"></a><a href="v.random.html"><span class="name">v.random</span> <span class="desc">Generates random 2D/3D vector points.</span></a></li><li><a href="v.rast.stats.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.rast.stats.html"><span class="name">v.rast.stats</span> <span class="desc">Calculates univariate statistics from a raster map based on a vector map and uploads statistics to new attribute columns.</span></a></li><li><a href="v.reclass.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.reclass.html"><span class="name">v.reclass</span> <span class="desc">Changes vector category values for an existing vector map according to results of SQL queries or a value in attribute table column.</span></a></li><li><a href="v.rectify.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.rectify.html"><span class="name">v.rectify</span> <span class="desc">Rectifies a vector by computing a coordinate transformation for each object in the vector based on the control points.</span></a></li><li><a href="v.report.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.report.html"><span class="name">v.report</span> <span class="desc">Reports geometry statistics for vector maps.</span></a></li><li><a href="v.sample.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.sample.html"><span class="name">v.sample</span> <span class="desc">Samples a raster map at vector point locations.</span></a></li><li><a href="v.segment.html"><img class="linkimg" src="v_segment_subline.jpg"></a><a href="v.segment.html"><span class="name">v.segment</span> <span class="desc">Creates points/segments from input vector lines and positions.</span></a></li><li><a href="v.select.html"><img class="linkimg" src="v_select_op_equals.png"></a><a href="v.select.html"><span class="name">v.select</span> <span class="desc">Selects features from vector map (A) by features from other vector map (B).</span></a></li><li><a href="v.split.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.split.html"><span class="name">v.split</span> <span class="desc">Splits vector lines to shorter segments.</span></a></li><li><a href="v.support.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.support.html"><span class="name">v.support</span> <span class="desc">Updates vector map metadata.</span></a></li><li><a href="v.surf.bspline.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.surf.bspline.html"><span class="name">v.surf.bspline</span> <span class="desc">Performs bicubic or bilinear spline interpolation with Tykhonov regularization.</span></a></li><li><a href="v.surf.idw.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.surf.idw.html"><span class="name">v.surf.idw</span> <span class="desc">Provides surface interpolation from vector point data by Inverse Distance Squared Weighting.</span></a></li><li><a href="v.surf.rst.html"><img class="linkimg" src="vsurfrst_benchmark.png"></a><a href="v.surf.rst.html"><span class="name">v.surf.rst</span> <span class="desc">Performs surface interpolation from vector points map by splines. Spatial approximation and topographic analysis from given point or isoline data in vector format to floating point raster format using regularized spline with tension.</span></a></li><li><a href="v.timestamp.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.timestamp.html"><span class="name">v.timestamp</span> <span class="desc">Modifies a timestamp for a vector map. Print/add/remove a timestamp for a vector map.</span></a></li><li><a href="v.to.3d.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.to.3d.html"><span class="name">v.to.3d</span> <span class="desc">Performs transformation of 2D vector features to 3D.</span></a></li><li><a href="v.to.db.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.to.db.html"><span class="name">v.to.db</span> <span class="desc">Populates attribute values from vector features.</span></a></li><li><a href="v.to.lines.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.to.lines.html"><span class="name">v.to.lines</span> <span class="desc">Converts vector polygons or points to lines.</span></a></li><li><a href="v.to.points.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.to.points.html"><span class="name">v.to.points</span> <span class="desc">Creates points along input lines in new vector map with 2 layers.</span></a></li><li><a href="v.to.rast.html"><img class="linkimg" src="v_to_rast3_test.png"></a><a href="v.to.rast.html"><span class="name">v.to.rast</span> <span class="desc">Converts (rasterize) a vector map into a raster map.</span></a></li><li><a href="v.to.rast3.html"><img class="linkimg" src="v_to_rast3_test.png"></a><a href="v.to.rast3.html"><span class="name">v.to.rast3</span> <span class="desc">Converts a vector map (only points) into a 3D raster map.</span></a></li><li><a href="v.transform.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.transform.html"><span class="name">v.transform</span> <span class="desc">Performs an affine transformation (shift, scale and rotate) on vector map.</span></a></li><li><a href="v.type.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.type.html"><span class="name">v.type</span> <span class="desc">Changes type of vector features.</span></a></li><li><a href="v.univar.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.univar.html"><span class="name">v.univar</span> <span class="desc">Calculates univariate statistics of vector map features. Variance and standard deviation is calculated only for points if specified.</span></a></li><li><a href="v.unpack.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.unpack.html"><span class="name">v.unpack</span> <span class="desc">Imports a GRASS specific vector archive file (packed with v.pack) as a vector map</span></a></li><li><a href="v.vect.stats.html"><img class="linkimg" src="v_vect_stats.png"></a><a href="v.vect.stats.html"><span class="name">v.vect.stats</span> <span class="desc">Count points in areas, calculate statistics from point attributes.</span></a></li><li><a href="v.vol.rst.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.vol.rst.html"><span class="name">v.vol.rst</span> <span class="desc">Interpolates point data to a 3D raster map using regularized spline with tension (RST) algorithm.</span></a></li><li><a href="v.voronoi.html"><img class="linkimg" src="v_voronoi_areas.png"></a><a href="v.voronoi.html"><span class="name">v.voronoi</span> <span class="desc">Creates a Voronoi diagram constrained to the extents of the current region from an input vector map containing points or centroids.</span></a></li><li><a href="v.what.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.what.html"><span class="name">v.what</span> <span class="desc">Queries a vector map at given locations.</span></a></li><li><a href="v.what.rast.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.what.rast.html"><span class="name">v.what.rast</span> <span class="desc">Uploads raster values at positions of vector points to the table.</span></a></li><li><a href="v.what.rast3.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.what.rast3.html"><span class="name">v.what.rast3</span> <span class="desc">Uploads 3D raster values at positions of vector points to the table.</span></a></li><li><a href="v.what.strds.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.what.strds.html"><span class="name">v.what.strds</span> <span class="desc">Uploads space time raster dataset values at positions of vector points to the table.</span></a></li><li><a href="v.what.vect.html"><img class="default-img" src="grass_logo.svg"></a><a href="v.what.vect.html"><span class="name">v.what.vect</span> <span class="desc">Uploads vector values at positions of vector points to the table.</span></a></li></ul>