---
name: d.histogram
description: Displays a histogram in the form of a pie or bar chart for a user-specified raster map.
keywords: [ display, histogram, statistics ]
---

# d.histogram

Displays a histogram in the form of a pie or bar chart for a user-specified raster map.

=== "Command line"

    **d.histogram**
    [**-nc**]
    **map**=*name*
    [**style**=*string*]
    [**color**=*name*]
    [**bgcolor**=*name*]
    [**nsteps**=*integer*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.histogram map=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.histogram***",
        **map**,
        **style**=*"bar"*,
        **color**=*"black"*,
        **bgcolor**=*"white"*,
        **nsteps**=*255*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.histogram", map="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_histogram*(**map**,
        **style**=*"bar"*,
        **color**=*"black"*,
        **bgcolor**=*"white"*,
        **nsteps**=*255*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_histogram(map="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **map**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map for which histogram will be displayed  
    **style**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Indicate if a pie or bar chart is desired  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *pie, bar*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bar*  
    **color**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for text and axes  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bgcolor**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **nsteps**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to divide the data range into (fp maps only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255*  
    **-n**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display information for null cells  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Report for ranges defined in cats file (fp maps only)  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **map** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map for which histogram will be displayed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Indicate if a pie or bar chart is desired  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *pie, bar*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bar*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for text and axes  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **nsteps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to divide the data range into (fp maps only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display information for null cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Report for ranges defined in cats file (fp maps only)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **map** : str | np.ndarray, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Raster map for which histogram will be displayed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *name*  
    **style** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Indicate if a pie or bar chart is desired  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *pie, bar*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *bar*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Color for text and axes  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name or R:G:B triplet  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *black*  
    **bgcolor** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color  
    &nbsp;&nbsp;&nbsp;&nbsp;Either a standard color name, R:G:B triplet, or "none"  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, color, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **nsteps** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Number of steps to divide the data range into (fp maps only)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *255*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *n*, *c*  
    &nbsp;&nbsp;&nbsp;&nbsp;**n**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display information for null cells  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Report for ranges defined in cats file (fp maps only)  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*d.histogram* displays the category-value distribution for a
user-specified raster map layer, in the form of a bar chart or a pie
chart. The display will be displayed in the active display frame on the
graphics monitor, using the colors in the raster map layer's color
table. The program determines the raster map's category value
distribution by counting cells.

## NOTES

*d.histogram* respects the current geographic region settings and the
current raster mask (if mask is active).

*d.histogram* uses the colors in the map's color look-up table (i.e.,
the map's *colr* or *colr2* file).

## EXAMPLES

Running the command below will generate the bar graph shown in the
figure:

```sh
g.region raster=elevation -p
d.mon wx0
d.histogram map=elevation
```

![d.histogram bar graph example](d_histogram_bar.png)  
*Figure: Bar graph histogram for elevation map*

Running the command below will generate the pie graph shown in the
figure:

```sh
g.region raster=landuse96_28m -p
d.histogram map=landuse96_28m style=pie
```

![d.histogram pie graph example](d_histogram_pie.png)  
*Figure: Pie graph histogram for landuse map*

## SEE ALSO

*[d.colortable](d.colortable.md), [d.frame](d.frame.md),
[d.graph](d.graph.md), [d.linegraph](d.linegraph.md), [d.mon](d.mon.md),
[d.polar](d.polar.md), [g.region](g.region.md), [r.stats](r.stats.md)*

## AUTHOR

Dave Johnson  
DBA Systems, Inc.  
10560 Arrowhead Drive  
Fairfax, Virginia 22030

## SOURCE CODE

Available at: [d.histogram source code](https://github.com/OSGeo/grass/tree/main/display/d.histogram)
([history](https://github.com/OSGeo/grass/commits/main/display/d.histogram))  
Latest change: Friday Sep 05 13:38:04 2025 in commit [6112ef0](https://github.com/OSGeo/grass/commit/6112ef0fc4c12145eb4ef69e842c77f9bbd7308e)
