---
name: d.mon2.py
description: Starts a graphics display monitor which can be controlled from the command line.
keywords: [ display, CLI ]
---

# d.mon2.py

Starts a graphics display monitor which can be controlled from the command line.

=== "Command line"

    **d.mon2.py**
    [**-cbd**]
    [**width**=*integer*]
    [**height**=*integer*]
    [**handler**=*string*]
    [**tempfile**=*string*]
    [**percent**=*integer*]
    [**color**=*string*]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    d.mon2.py
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***d.mon2.py***",
        **width**=*800*,
        **height**=*600*,
        **handler**=*"wximgview"*,
        **tempfile**=*None*,
        **percent**=*10*,
        **color**=*"white"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("d.mon2.py")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.d_mon2_py*(**width**=*800*,
        **height**=*600*,
        **handler**=*"wximgview"*,
        **tempfile**=*None*,
        **percent**=*10*,
        **color**=*"white"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.d_mon2_py()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **width**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width for display monitor if not set by GRASS_RENDER_WIDTH  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800*  
    **height**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for display monitor if not set by GRASS_RENDER_HEIGHT  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600*  
    **handler**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Window program to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ximgview, wximgview, wxpyimgview, qiv, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *wximgview*  
    **tempfile**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name and location of temp file  
    **percent**=*integer*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of CPU time to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **color**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color, either a standard GRASS color or R:G:B triplet (separated by colons)  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Use the Cario driver to render images  
    **-b**  
    &nbsp;&nbsp;&nbsp;&nbsp;output Bourne shell code to set up display  
    **-d**  
    &nbsp;&nbsp;&nbsp;&nbsp;output DOS code to set up display  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width for display monitor if not set by GRASS_RENDER_WIDTH  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800*  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for display monitor if not set by GRASS_RENDER_HEIGHT  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600*  
    **handler** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Window program to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ximgview, wximgview, wxpyimgview, qiv, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *wximgview*  
    **tempfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name and location of temp file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input  
    **percent** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of CPU time to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color, either a standard GRASS color or R:G:B triplet (separated by colons)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *b*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the Cario driver to render images  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;output Bourne shell code to set up display  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;output DOS code to set up display  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **width** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Width for display monitor if not set by GRASS_RENDER_WIDTH  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *800*  
    **height** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Height for display monitor if not set by GRASS_RENDER_HEIGHT  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *600*  
    **handler** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Window program to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *ximgview, wximgview, wxpyimgview, qiv, none*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *wximgview*  
    **tempfile** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name and location of temp file  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input  
    **percent** : int, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Percentage of CPU time to use  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *10*  
    **color** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Background color, either a standard GRASS color or R:G:B triplet (separated by colons)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: color  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *white*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *c*, *b*, *d*  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use the Cario driver to render images  
    &nbsp;&nbsp;&nbsp;&nbsp;**b**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;output Bourne shell code to set up display  
    &nbsp;&nbsp;&nbsp;&nbsp;**d**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;output DOS code to set up display  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

This is just a little experiment to see if we can make the ximgview,
wximgview, and wxpyimgview programs a bit simpler to start up.

Add this to your `~/.grass.bashrc` file:

```sh
  if [ `echo "$GRASS_VERSION" | cut -f1 -d.` -eq 7 ] ; then
     alias d.mon='eval `d.mon.py -b`'
  fi
```

By default the temporary file will be stored in $MAPSET/.tmp/ and
cleared at the end of the session. You can put it somewhere else with
the **tempfile** option. For example, when working remotely with PuTTY
(ssh without tunnelled X) + Apache:

```sh
   alias d.mon='eval `d.mon.py -b handler=none tempfile=/var/www/grassmap.png`'
```

then just hit reload in your web browser whenever a refresh is needed.

## AUTHOR

Hamish Bowman  
Dunedin, New Zealand

## SOURCE CODE

Available at: [d.mon2 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/display/d.mon2)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/display/d.mon2))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
