---
name: db.columns
description: List all columns for a given table.
keywords: [ database, attribute table ]
---

# db.columns

List all columns for a given table.

=== "Command line"

    **db.columns**
    [**-e**]
    **table**=*name*
    [**driver**=*name*]
    [**database**=*name*]
    [**separator**=*character*]
    **format**=*name*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.columns table=name format=plain
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***db.columns***",
        **table**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **separator**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("db.columns", table="name", format="json")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_columns*(**table**,
        **driver**=*"sqlite"*,
        **database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **separator**=*None*,
        **format**=*"plain"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_columns(table="name", format="json")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    **driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **separator**=*character*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    **format**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json, list*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Configurable plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**list**: Output in list format  
    **-e**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print type information about the columns  
    &nbsp;&nbsp;&nbsp;&nbsp;Print the name and the type of all the columns for a given table.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json, list*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Configurable plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**list**: Output in list format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print type information about the columns  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the name and the type of all the columns for a given table.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of attribute table  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database driver  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of database  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **separator** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Field separator  
    &nbsp;&nbsp;&nbsp;&nbsp;Special characters: pipe, comma, space, tab, newline  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, separator, *character*  
    **format** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output format  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *plain, csv, json, list*  
    &nbsp;&nbsp;&nbsp;&nbsp;**plain**: Configurable plain text output  
    &nbsp;&nbsp;&nbsp;&nbsp;**csv**: CSV (Comma Separated Values)  
    &nbsp;&nbsp;&nbsp;&nbsp;**json**: JSON (JavaScript Object Notation)  
    &nbsp;&nbsp;&nbsp;&nbsp;**list**: Output in list format  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *plain*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *e*  
    &nbsp;&nbsp;&nbsp;&nbsp;**e**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print type information about the columns  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Print the name and the type of all the columns for a given table.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.columns* lists all columns for a given table. Connection to databases
are supported through dbf, shp, odbc and pg drivers.

## NOTE

If parameters for database connection are already set with
[db.connect](db.connect.md), they are taken as default values and do not
need to be specified each time.

## EXAMPLES

### List columns

List of columns in shell:

```sh
db.columns table=zipcodes_wake format=list
```

```text
cat
OBJECTID
WAKE_ZIPCO
PERIMETER
ZIPCODE_
ZIPCODE_ID
ZIPNAME
ZIPNUM
ZIPCODE
NAME
SHAPE_Leng
SHAPE_Area
```

List of columns in Python:

```python
from grass.tools import Tools

columns = Tools().db_columns(table="zipcodes_wake", format="json")
print(list(columns))
```

```text
['cat', 'OBJECTID', 'WAKE_ZIPCO', 'PERIMETER', 'ZIPCODE_', 'ZIPCODE_ID', 'ZIPNAME', 'ZIPNUM', 'ZIPCODE', 'NAME', 'SHAPE_Leng', 'SHAPE_Area']
```

### List detailed column information

List column types in plain format:

```sh
db.columns -e table=zipcodes_wake
```

```text
cat: INTEGER
OBJECTID: INTEGER
WAKE_ZIPCO: DOUBLE PRECISION
PERIMETER: DOUBLE PRECISION
ZIPCODE_: DOUBLE PRECISION
ZIPCODE_ID: DOUBLE PRECISION
ZIPNAME: CHARACTER
ZIPNUM: DOUBLE PRECISION
ZIPCODE: CHARACTER
NAME: CHARACTER
SHAPE_Leng: DOUBLE PRECISION
SHAPE_Area: DOUBLE PRECISION
```

List column types in JSON format:

```sh
db.columns -e table=zipcodes_wake format=json
```

```json
[
    {
        "name": "cat",
        "sql_type": "INTEGER",
        "is_number": true
    },
    {
        "name": "OBJECTID",
        "sql_type": "INTEGER",
        "is_number": true
    },
    {
        "name": "WAKE_ZIPCO",
        "sql_type": "DOUBLE PRECISION",
        "is_number": true
    },

    ...
]
```

Create an SQL-like column list:

```sh
db.columns -e table=zipcodes_wake format=list separator=comma
```

```text
cat INTEGER,OBJECTID INTEGER,WAKE_ZIPCO DOUBLE PRECISION,PERIMETER DOUBLE PRECISION,ZIPCODE_ DOUBLE PRECISION,ZIPCODE_ID DOUBLE PRECISION,ZIPNAME CHARACTER,ZIPNUM DOUBLE PRECISION,ZIPCODE CHARACTER,NAME CHARACTER,SHAPE_Leng DOUBLE PRECISION,SHAPE_Area DOUBLE PRECISION
```

List column types in CSV format:

```sh
db.columns -e table=zipcodes_wake format=csv
```

```text
name,sql_type,is_number
cat,INTEGER,true
OBJECTID,INTEGER,true
WAKE_ZIPCO,DOUBLE PRECISION,true
PERIMETER,DOUBLE PRECISION,true
ZIPCODE_,DOUBLE PRECISION,true
ZIPCODE_ID,DOUBLE PRECISION,true
ZIPNAME,CHARACTER,false
ZIPNUM,DOUBLE PRECISION,true
ZIPCODE,CHARACTER,false
NAME,CHARACTER,false
SHAPE_Leng,DOUBLE PRECISION,true
SHAPE_Area,DOUBLE PRECISION,true
```

### List columns of a PostgreSQL attribute table

```sh
db.columns table=zipcodes_wake driver=pg database=grassdb
```

If the database parameters are already set, the columns can be listed
directly:

```sh
db.columns table=zipcodes_wake
```

## SEE ALSO

*[db.connect](db.connect.md), [db.describe](db.describe.md),
[db.drivers](db.drivers.md), [db.droptable](db.droptable.md),
[db.execute](db.execute.md), [db.login](db.login.md),
[db.tables](db.tables.md), [GRASS SQL interface](sql.md)*

[GRASS SQL interface](sql.md)

## AUTHOR

Radim Blazek, ITC-Irst, Trento, Italy

## SOURCE CODE

Available at: [db.columns source code](https://github.com/OSGeo/grass/tree/main/db/db.columns)
([history](https://github.com/OSGeo/grass/commits/main/db/db.columns))  
Latest change: Saturday Jan 31 03:52:33 2026 in commit [5dd1f90](https://github.com/OSGeo/grass/commit/5dd1f9083055d3047f66dba6c3aec01c50dbdf2d)
