---
name: db.copy
description: Copy a table. Either 'from_table' (optionally with 'where') can be used or 'select' option, but not 'from_table' and 'select' at the same time.
keywords: [ database, attribute table, SQL ]
---

# db.copy

Copy a table.

Either 'from_table' (optionally with 'where') can be used or 'select' option, but not 'from_table' and 'select' at the same time.

=== "Command line"

    **db.copy**
    [**from_driver**=*name*]
    [**from_database**=*name*]
    [**from_table**=*name*]
    [**to_driver**=*name*]
    [**to_database**=*name*]
    **to_table**=*name*
    [**where**=*sql_query*]
    [**select**=*string*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    db.copy to_table=name
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***db.copy***",
        **from_driver**=*"sqlite"*,
        **from_database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **from_table**=*None*,
        **to_driver**=*"sqlite"*,
        **to_database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **to_table**,
        **where**=*None*,
        **select**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("db.copy", to_table="name")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.db_copy*(**from_driver**=*"sqlite"*,
        **from_database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **from_table**=*None*,
        **to_driver**=*"sqlite"*,
        **to_database**=*"$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db"*,
        **to_table**,
        **where**=*None*,
        **select**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.db_copy(to_table="name")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **from_driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input driver name  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **from_database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input database name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **from_table**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input table name (only, if 'select' is not used)  
    **to_driver**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output driver name  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **to_database**=*name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output database name  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **to_table**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Output table name  
    **where**=*sql_query*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    **select**=*string*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full select statement (only, if 'from_table' and 'where' is not used)  
    &nbsp;&nbsp;&nbsp;&nbsp;E.g.: SELECT dedek FROM starobince WHERE obec = 'Frimburg'  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **from_driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input driver name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **from_database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input database name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **from_table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input table name (only, if 'select' is not used)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **to_driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output driver name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **to_database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output database name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **to_table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, dbtable, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **select** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full select statement (only, if 'from_table' and 'where' is not used)  
    &nbsp;&nbsp;&nbsp;&nbsp;E.g.: SELECT dedek FROM starobince WHERE obec = 'Frimburg'  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **from_driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input driver name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **from_database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input database name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **from_table** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Input table name (only, if 'select' is not used)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbtable, *name*  
    **to_driver** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output driver name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbdriver, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *dbf, ogr, sqlite*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *sqlite*  
    **to_database** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output database name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, dbname, *name*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db*  
    **to_table** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Output table name  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: output, dbtable, *name*  
    **where** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;WHERE conditions of SQL statement without 'where' keyword  
    &nbsp;&nbsp;&nbsp;&nbsp;Example: income &lt; 1000 and population &gt;= 10000  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, sql_query, *sql_query*  
    **select** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Full select statement (only, if 'from_table' and 'where' is not used)  
    &nbsp;&nbsp;&nbsp;&nbsp;E.g.: SELECT dedek FROM starobince WHERE obec = 'Frimburg'  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*db.copy* allows the user to copy a table between two databases.
Databases can be connected through different drivers (see examples
below).

## NOTES

Attribute tables can be copied using *db.copy* and, when to be
associated to a vector map, assigned to the map with
*[v.db.connect](v.db.connect.md)*. Current connection settings are saved
in the file *\$LOCATION/vector_map/dbln*.

## EXAMPLES

### From DBF to PostgreSQL

*Storing table 'geonames.dbf' (in current directory) into PostgreSQL
through ODBC:*  

```sh
db.copy from_driver=dbf from_database='$GISDBASE/$LOCATION_NAME/PERMANENT/dbf' \
  from_table=geonames to_driver=pg to_database="host=pgserver,dbname=testdb" \
  to_table=geonames
```

### From PostgreSQL to DBF

```sh
db.copy from_driver=pg  from_database="host=pgserver.example.org,dbname=testdb" \
  from_table=origtable to_driver=dbf \
  to_database='$GISDBASE/$LOCATION_NAME/$MAPSET/dbf' to_table=origtable
```

### From PostgreSQL to PostgreSQL with condition

```sh
db.copy from_driver=pg  from_database="host=localhost,dbname=testdb" \
  from_table=geonames to_driver=pg to_database="host=localhost,dbname=testdb" \
  to_table=selection where="cat < 500"
```

### From DBF to SQLite

```sh
db.copy from_driver=dbf from_database='$GISDBASE/$LOCATION_NAME/PERMANENT/dbf' \
   from_table=geonames_features to_driver=sqlite \
   to_database='$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db' to_table=geonames_features

# convenient viewer:
sqlitebrowser $HOME/grassdata/nc_spm_08/user1/sqlite/sqlite.db
```

### From SQLite to DBF

```sh
db.copy from_driver=sqlite from_database='$GISDBASE/$LOCATION_NAME/$MAPSET/sqlite/sqlite.db' \
   from_table=ammprv to_driver=dbf to_database='$GISDBASE/$LOCATION_NAME/$MAPSET/dbf/' \
   to_table=ammprv
```

## SEE ALSO

*[db.connect](db.connect.md), [db.drivers](db.drivers.md),
[db.login](db.login.md), [v.db.connect](v.db.connect.md),
[v.clean](v.clean.md)*

[GRASS SQL interface](sql.md)

## AUTHOR

Radim Blazek, ITC-irst, Trento, Italy

## SOURCE CODE

Available at: [db.copy source code](https://github.com/OSGeo/grass/tree/main/db/db.copy)
([history](https://github.com/OSGeo/grass/commits/main/db/db.copy))  
Latest change: Friday Feb 07 19:16:09 2025 in commit [a82a39f](https://github.com/OSGeo/grass/commit/a82a39f673b97fafcfce1604dc3e6015cb96487a)
