# Tools

GRASS offers a comprehensive set of tools for geospatial processing, modeling,
analysis, and visualization. These tools are categorized by data type,
with prefixes indicating their respective categories. Use the table below to explore
the main tool categories:

| Prefix | Category                          | Description                        |
|--------|-----------------------------------|------------------------------------|
| `g.`   | [General](general.md)             | General GIS management tools       |
| `r.`   | [Raster](raster.md)               | Raster data processing tools       |
| `r3.`  | [3D raster](raster3d.md)          | 3D Raster data processing tools    |
| `v.`   | [Vector](vector.md)               | Vector data processing tools       |
| `i.`   | [Imagery](imagery.md)             | Imagery processing tools           |
| `t.`   | [Temporal](temporal.md)           | Temporal data processing tools     |
| `db.`  | [Database](database.md)           | Database management tools          |
| `d.`   | [Display](display.md)             | Display and visualization tools    |
| `m.`   | [Miscellaneous](miscellaneous.md) | Miscellaneous tools                |

### Display tools (d.)

| Name | Description |
|--------|-------------|
| [d.background](d.background.md) | Fills the graphics display frame with user defined color. |
| [d.barscale](d.barscale.md) | Displays a barscale on the graphics monitor. |
| [d.colorlist](d.colorlist.md) | Outputs a list of all available display colors. |
| [d.colortable](d.colortable.md) | Displays the color table associated with a raster map layer. |
| [d.correlate](d.correlate.md) | Prints a graph of the correlation between raster maps (in pairs). |
| [d.erase](d.erase.md) | Erases the contents of the active graphics display frame with user defined color. |
| [d.font](d.font.md) | Selects the font in which text will be displayed on the user's graphics monitor. |
| [d.fontlist](d.fontlist.md) | Lists the available fonts. |
| [d.frame](d.frame.md) | Manages display frames on the user's graphics monitor. |
| [d.geodesic](d.geodesic.md) | Displays a geodesic line, tracing the shortest distance between two geographic points along a great circle, in a longitude/latitude data set. |
| [d.graph](d.graph.md) | Program for generating and displaying simple graphics on the display monitor. |
| [d.grid](d.grid.md) | Overlays a user-specified grid in the active display frame on the graphics monitor. |
| [d.his](d.his.md) | Displays the result obtained by combining hue, intensity, and saturation (HIS) values from user-specified input raster map layers. |
| [d.histogram](d.histogram.md) | Displays a histogram in the form of a pie or bar chart for a user-specified raster map. |
| [d.info](d.info.md) | Displays information about the active display monitor. Display monitors are maintained by d.mon. |
| [d.labels](d.labels.md) | Displays text labels (created with v.label) to the active frame on the graphics monitor. |
| [d.legend](d.legend.md) | Displays a legend for a 2D or 3D raster map in the active frame of the graphics monitor. |
| [d.legend.vect](d.legend.vect.md) | Displays a vector legend in the active graphics frame. |
| [d.linegraph](d.linegraph.md) | Generates and displays simple line graphs in the active graphics monitor display frame. |
| [d.mon](d.mon.md) | Controls graphics display monitors from the command line. |
| [d.northarrow](d.northarrow.md) | Displays a north arrow on the graphics monitor. |
| [d.out.file](d.out.file.md) | Saves the contents of the active display monitor to a graphics file. |
| [d.path](d.path.md) | Finds shortest path for selected starting and ending node. |
| [d.polar](d.polar.md) | Draws polar diagram of angle map such as aspect or flow directions |
| [d.profile](d.profile.md) | Plots profile of a transect. |
| [d.rast.arrow](d.rast.arrow.md) | Draws arrows representing cell aspect direction for a raster map containing aspect data. |
| [d.rast.edit](d.rast.edit.md) | Edits cell values in a raster map. |
| [d.rast.leg](d.rast.leg.md) | Displays a raster map and its legend on a graphics window |
| [d.rast](d.rast.md) | Displays user-specified raster map in the active graphics frame. |
| [d.rast.num](d.rast.num.md) | Overlays cell category values on a raster map displayed in the active graphics frame. |
| [d.redraw](d.redraw.md) | Redraws the content of currently selected monitor. |
| [d.rgb](d.rgb.md) | Displays three user-specified raster maps as red, green, and blue overlays in the active graphics frame. |
| [d.rhumbline](d.rhumbline.md) | Displays the rhumbline joining two longitude/latitude coordinates. |
| [d.shade](d.shade.md) | Drapes a color raster over an shaded relief or aspect map. |
| [d.text](d.text.md) | Draws text in the active display frame on the graphics monitor using the current font. |
| [d.title](d.title.md) | Create a TITLE for a raster map in a form suitable for display with d.text. |
| [d.to.rast](d.to.rast.md) | Saves the contents of the active display monitor to a raster map. |
| [d.vect.chart](d.vect.chart.md) | Displays charts of vector data in the active frame on the graphics monitor. |
| [d.vect](d.vect.md) | Displays user-specified vector map in the active graphics frame. |
| [d.vect.thematic](d.vect.thematic.md) | Displays a thematic vector map in the active graphics frame. |
| [d.what.rast](d.what.rast.md) | Allows the user to interactively query raster map layers at user-selected locations. |
| [d.what.vect](d.what.vect.md) | Allows the user to interactively query vector map layers at user-selected locations. |
| [d.where](d.where.md) | Identifies the geographic coordinates associated with point locations given in display coordinates. |

### Database tools (db.)

| Name | Description |
|--------|-------------|
| [db.columns](db.columns.md) | List all columns for a given table. |
| [db.connect](db.connect.md) | Prints/sets general DB connection for current mapset. |
| [db.copy](db.copy.md) | Copy a table. Either 'from_table' (optionally with 'where') can be used or 'select' option, but not 'from_table' and 'select' at the same time. |
| [db.createdb](db.createdb.md) | Creates an empty database. |
| [db.databases](db.databases.md) | Lists all databases for a given driver and location. |
| [db.describe](db.describe.md) | Describes a table in detail. |
| [db.drivers](db.drivers.md) | Lists all database drivers. |
| [db.dropcolumn](db.dropcolumn.md) | Drops a column from selected attribute table. |
| [db.dropdb](db.dropdb.md) | Removes an existing database. |
| [db.droptable](db.droptable.md) | Drops an attribute table. |
| [db.execute](db.execute.md) | Executes any SQL statement. For SELECT statements use 'db.select'. |
| [db.in.ogr](db.in.ogr.md) | Imports attribute tables in various formats. |
| [db.login](db.login.md) | Sets user/password for DB driver/database. |
| [db.out.ogr](db.out.ogr.md) | Exports attribute tables into various formats. |
| [db.select](db.select.md) | Selects data from attribute table. Performs SQL query statement(s). |
| [db.tables](db.tables.md) | Lists all tables for a given database. |
| [db.test](db.test.md) | Test database driver, database must exist and set by db.connect. |
| [db.univar](db.univar.md) | Calculates univariate statistics on selected table column. |

### General tools (g.)

| Name | Description |
|--------|-------------|
| [g.access](g.access.md) | Controls access to the current mapset for other users on the system. If no option given, prints current status. |
| [g.copy](g.copy.md) | Creates copies of maps and other elements Copies available data files in the current mapset search path to the user's current mapset. |
| [g.dirseps](g.dirseps.md) | Internal GRASS utility for converting directory separator characters. Converts any directory separator characters in the input string to or from native host format, and writes the changed path to standard output. Useful in scripts for Windows compatibility. |
| [g.download.location](g.download.location.md) | Download GRASS project (location) from the web Get GRASS project from an URL or file path |
| [g.download.project](g.download.project.md) | Download GRASS project from the web Get GRASS project from an URL or file path |
| [g.extension.all](g.extension.all.md) | Rebuilds or removes all locally installed GRASS Addons extensions. By default only extensions built against different GIS Library are rebuilt. |
| [g.extension](g.extension.md) | Maintains GRASS Addons extensions in local GRASS installation. Downloads and installs extensions from GRASS Addons repository or other source into the local GRASS installation or removes installed extensions. |
| [g.filename](g.filename.md) | Prints GRASS data base file names. |
| [g.findetc](g.findetc.md) | Searches for GRASS support files. |
| [g.findfile](g.findfile.md) | Searches for GRASS data base files and sets variables for the shell. |
| [g.gisenv](g.gisenv.md) | Outputs and modifies the user's current GRASS variable settings. Prints all defined GRASS variables if no option is given. |
| [g.gui.animation](g.gui.animation.md) | Tool for animating a series of raster and vector maps or a space time raster or vector dataset. |
| [g.gui.datacatalog](g.gui.datacatalog.md) | Tool for browsing, modifying and managing GRASS maps. |
| [g.gui.dbmgr](g.gui.dbmgr.md) | Launches graphical attribute table manager. |
| [g.gui.gcp](g.gui.gcp.md) | Georectifies a map and allows managing Ground Control Points. |
| [g.gui.gmodeler](g.gui.gmodeler.md) | Graphical Modeler. Allows interactively creating, editing and managing models. |
| [g.gui.iclass](g.gui.iclass.md) | Tool for supervised classification of imagery data. Generates spectral signatures for an image by allowing the user to outline regions of interest. |
| [g.gui.image2target](g.gui.image2target.md) | Georectifies a map and allows managing Ground Control Points for 3D correction. |
| [g.gui.mapswipe](g.gui.mapswipe.md) | Interactively compares two maps by swiping a visibility bar. |
| [g.gui](g.gui.md) | Launches a GRASS graphical user interface (GUI) session. Optionally updates default user interface settings. |
| [g.gui.photo2image](g.gui.photo2image.md) | Corrects scanning distortions of a paper photo. |
| [g.gui.psmap](g.gui.psmap.md) | Tool for creating hardcopy map outputs. |
| [g.gui.rdigit](g.gui.rdigit.md) | Interactive editing and digitizing of raster maps. |
| [g.gui.rlisetup](g.gui.rlisetup.md) | Configuration tool for r.li modules. |
| [g.gui.timeline](g.gui.timeline.md) | Allows comparing temporal datasets by displaying their temporal extents in a plot. |
| [g.gui.tplot](g.gui.tplot.md) | Plots the values of temporal datasets. |
| [g.gui.vdigit](g.gui.vdigit.md) | Interactive editing and digitization of vector maps. |
| [g.list](g.list.md) | Lists available GRASS data base files of the user-specified data type optionally using the search pattern. |
| [g.manual](g.manual.md) | Displays the manual pages of GRASS modules. |
| [g.mapset](g.mapset.md) | Changes or reports current mapset. Optionally, creates new mapset or lists available mapsets in given project (location). |
| [g.mapsets](g.mapsets.md) | Modifies or reports the user's current mapset search path. Affects the user's access to data existing under the other mapsets in the current project. |
| [g.message](g.message.md) | Prints a message, warning, progress info, or fatal error in the GRASS way. This module should be used in scripts for messages served to user. |
| [g.mkfontcap](g.mkfontcap.md) | Generates the font configuration file by scanning various directories for fonts. |
| [g.parser](g.parser.md) | Provides automated parser, GUI, and help support for GRASS scripts. |
| [g.pnmcomp](g.pnmcomp.md) | Overlays multiple PPM image files. |
| [g.ppmtopng](g.ppmtopng.md) | Converts between PPM/PGM and PNG image formats. |
| [g.proj](g.proj.md) | Prints or modifies GRASS projection information files (in various co-ordinate system descriptions). Can also be used to create new GRASS projects. |
| [g.region](g.region.md) | Manages the boundary definitions for the geographic region. |
| [g.remove](g.remove.md) | Removes data base element files from the user's current mapset using the search pattern. |
| [g.rename](g.rename.md) | Renames data base element files in the user's current mapset. |
| [g.search.modules](g.search.modules.md) | Search in GRASS modules using keywords |
| [g.tempfile](g.tempfile.md) | Creates a temporary file and prints it's file name. |
| [g.version](g.version.md) | Displays GRASS version info. Optionally also prints build or copyright information. |

### Imagery tools (i.)

| Name | Description |
|--------|-------------|
| [i.albedo](i.albedo.md) | Computes broad band albedo from surface reflectance. |
| [i.aster.toar](i.aster.toar.md) | Calculates Top of Atmosphere Radiance/Reflectance/Brightness Temperature from ASTER DN. |
| [i.atcorr](i.atcorr.md) | Performs atmospheric correction using the 6S algorithm. 6S - Second Simulation of Satellite Signal in the Solar Spectrum. |
| [i.band.library](i.band.library.md) | Prints available semantic label information used for multispectral data. |
| [i.biomass](i.biomass.md) | Computes biomass growth, precursor of crop yield calculation. |
| [i.cca](i.cca.md) | Canonical components analysis (CCA) program for image processing. |
| [i.cluster](i.cluster.md) | Generates spectral signatures for land cover types in an image using a clustering algorithm. The resulting signature file is used as input for i.maxlik, to generate an unsupervised image classification. |
| [i.colors.enhance](i.colors.enhance.md) | Performs auto-balancing of colors for RGB images. |
| [i.eb.eta](i.eb.eta.md) | Actual evapotranspiration for diurnal period (Bastiaanssen, 1995). |
| [i.eb.evapfr](i.eb.evapfr.md) | Computes evaporative fraction and root zone soil moisture. |
| [i.eb.hsebal01](i.eb.hsebal01.md) | Computes sensible heat flux iteration SEBAL 01. |
| [i.eb.netrad](i.eb.netrad.md) | Net radiation approximation (Bastiaanssen, 1995). |
| [i.eb.soilheatflux](i.eb.soilheatflux.md) | Soil heat flux approximation (Bastiaanssen, 1995). |
| [i.emissivity](i.emissivity.md) | Computes emissivity from NDVI, generic method for sparse land. |
| [i.evapo.mh](i.evapo.mh.md) | Computes evapotranspiration calculation modified or original Hargreaves formulation, 2001. |
| [i.evapo.pm](i.evapo.pm.md) | Computes potential evapotranspiration calculation with hourly Penman-Monteith. |
| [i.evapo.pt](i.evapo.pt.md) | Computes evapotranspiration calculation Priestley and Taylor formulation, 1972. |
| [i.evapo.time](i.evapo.time.md) | Computes temporal integration of satellite ET actual (ETa) following the daily ET reference (ETo) from meteorological station(s). |
| [i.fft](i.fft.md) | Fast Fourier Transform (FFT) for image processing. |
| [i.gensig](i.gensig.md) | Generates statistics for i.maxlik from raster map. |
| [i.gensigset](i.gensigset.md) | Generates statistics for i.smap from raster map. |
| [i.group](i.group.md) | Creates, edits, and lists groups of imagery data. |
| [i.his.rgb](i.his.rgb.md) | Transforms raster maps from HIS (Hue-Intensity-Saturation) color space to RGB (Red-Green-Blue) color space. |
| [i.ifft](i.ifft.md) | Inverse Fast Fourier Transform (IFFT) for image processing. |
| [i.image.mosaic](i.image.mosaic.md) | Mosaics several images and extends colormap. |
| [i.in.spotvgt](i.in.spotvgt.md) | Imports SPOT VGT NDVI data into a raster map. |
| [i.landsat.acca](i.landsat.acca.md) | Performs Landsat TM/ETM+ Automatic Cloud Cover Assessment (ACCA). |
| [i.landsat.toar](i.landsat.toar.md) | Calculates top-of-atmosphere radiance or reflectance and temperature for Landsat MSS/TM/ETM+/OLI |
| [i.maxlik](i.maxlik.md) | Classifies the cell spectral reflectances in imagery data. Classification is based on the spectral signature information generated by either i.cluster, g.gui.iclass, or i.gensig. |
| [i.modis.qc](i.modis.qc.md) | Extracts quality control parameters from MODIS QC layers. |
| [i.oif](i.oif.md) | Calculates Optimum-Index-Factor table for spectral bands |
| [i.ortho.camera](i.ortho.camera.md) | Select and modify the imagery group camera reference file. |
| [i.ortho.elev](i.ortho.elev.md) | Select or modify the target elevation model. |
| [i.ortho.init](i.ortho.init.md) | Interactively creates or modifies entries in a camera initial exposure station file for imagery group referenced by a sub-block. |
| [i.ortho.photo](i.ortho.photo.md) | Menu driver for the photo imagery programs. |
| [i.ortho.rectify](i.ortho.rectify.md) | Orthorectifies an image by using the image to photo coordinate transformation matrix. |
| [i.ortho.target](i.ortho.target.md) | Select or modify the imagery group target. |
| [i.ortho.transform](i.ortho.transform.md) | Computes a coordinate transformation based on the control points. |
| [i.pansharpen](i.pansharpen.md) | Image fusion algorithms to sharpen multispectral with high-res panchromatic channels |
| [i.pca](i.pca.md) | Principal components analysis (PCA) for image processing. |
| [i.rectify](i.rectify.md) | Rectifies an image by computing a coordinate transformation for each pixel in the image based on the control points. |
| [i.rgb.his](i.rgb.his.md) | Transforms raster maps from RGB (Red-Green-Blue) color space to HIS (Hue-Intensity-Saturation) color space. |
| [i.segment](i.segment.md) | Identifies segments (objects) from imagery data. |
| [i.signatures](i.signatures.md) | Manage imagery classification signature files |
| [i.smap](i.smap.md) | Performs contextual image classification using sequential maximum a posteriori (SMAP) estimation. |
| [i.spectral](i.spectral.md) | Displays spectral response at user specified locations in group or images. |
| [i.target](i.target.md) | Targets an imagery group to a GRASS location and mapset. |
| [i.tasscap](i.tasscap.md) | Performs Tasseled Cap (Kauth Thomas) transformation. |
| [i.topo.corr](i.topo.corr.md) | Computes topographic correction of reflectance. |
| [i.vi](i.vi.md) | Calculates different types of vegetation indices. Uses red and nir bands mostly, and some indices require additional bands. |
| [i.zc](i.zc.md) | Zero-crossing "edge detection" raster function for image processing. |

### Miscellaneous tools (m.)

| Name | Description |
|--------|-------------|
| [m.cogo](m.cogo.md) | A simple utility for converting bearing and distance measurements to coordinates and vice versa. It assumes a cartesian coordinate system |
| [m.measure](m.measure.md) | Measures the lengths and areas of features. |
| [m.nviz.image](m.nviz.image.md) | Creates a 3D rendering of GIS data. Renders surfaces (raster data), 2D/3D vector data, and volumes (3D raster data) in 3D. |
| [m.nviz.script](m.nviz.script.md) | Creates fly-through script to run in NVIZ. |
| [m.proj](m.proj.md) | Converts coordinates from one projection to another (cs2cs frontend). |
| [m.transform](m.transform.md) | Computes a coordinate transformation based on the control points. |

### PostScript tools (ps.)

| Name | Description |
|--------|-------------|
| [ps.map](ps.map.md) | Produces hardcopy PostScript map output. |

### Raster tools (r.)

| Name | Description |
|--------|-------------|
| [r.basins.fill](r.basins.fill.md) | Generates watershed subbasins raster map. |
| [r.blend](r.blend.md) | Blends color components of two raster maps by a given ratio. |
| [r.buffer.lowmem](r.buffer.lowmem.md) | Creates a raster map showing buffer zones surrounding cells that contain non-NULL category values. This is the low-memory alternative to the classic r.buffer module. |
| [r.buffer](r.buffer.md) | Creates a raster map showing buffer zones surrounding cells that contain non-NULL category values. |
| [r.buildvrt](r.buildvrt.md) | Build a VRT (Virtual Raster) from the list of input raster maps. |
| [r.carve](r.carve.md) | Generates stream channels. Takes vector stream data, transforms it to raster and subtracts depth from the output DEM. |
| [r.category](r.category.md) | Manages category values and labels associated with user-specified raster map layers. |
| [r.circle](r.circle.md) | Creates a raster map containing concentric rings around a given point. |
| [r.clump](r.clump.md) | Recategorizes data in a raster map by grouping cells that form physically discrete areas into unique categories. |
| [r.coin](r.coin.md) | Tabulates the mutual occurrence (coincidence) of categories for two raster map layers. |
| [r.colors](r.colors.md) | Creates/modifies the color table associated with a raster map. |
| [r.colors.out](r.colors.out.md) | Exports the color table associated with a raster map. |
| [r.colors.stddev](r.colors.stddev.md) | Sets color rules based on stddev from a raster map's mean value. |
| [r.composite](r.composite.md) | Combines red, green and blue raster maps into a single composite raster map. |
| [r.compress](r.compress.md) | Compresses and decompresses raster maps. |
| [r.contour](r.contour.md) | Produces a vector map of specified contours from a raster map. |
| [r.cost](r.cost.md) | Creates a raster map showing the cumulative cost of moving between different geographic locations on an input raster map whose cell category values represent cost. |
| [r.covar](r.covar.md) | Outputs a covariance/correlation matrix for user-specified raster map layer(s). |
| [r.cross](r.cross.md) | Creates a cross product of the category values from multiple raster map layers. |
| [r.describe](r.describe.md) | Prints terse list of category values found in a raster map layer. |
| [r.distance](r.distance.md) | Locates the closest points between objects in two raster maps. |
| [r.drain](r.drain.md) | Traces a flow through an elevation model or cost surface on a raster map. |
| [r.external](r.external.md) | Links GDAL supported raster data as a pseudo GRASS raster map. |
| [r.external.out](r.external.out.md) | Redirects raster output to file utilizing GDAL library rather than storing in GRASS raster format. |
| [r.fill.dir](r.fill.dir.md) | Filters and generates a depressionless elevation map and a flow direction map from a given elevation raster map. |
| [r.fill.stats](r.fill.stats.md) | Rapidly fills 'no data' cells (NULLs) of a raster map with interpolated values (IDW). |
| [r.fillnulls](r.fillnulls.md) | Fills no-data areas in raster maps using spline interpolation. |
| [r.flow](r.flow.md) | Constructs flowlines. Computes flowlines, flowpath lengths, and flowaccumulation (contributing areas) from a elevation raster map. |
| [r.geomorphon](r.geomorphon.md) | Calculates geomorphons (terrain forms) and associated geometry using machine vision approach. |
| [r.grow.distance](r.grow.distance.md) | Generates a raster map containing distances to nearest raster features and/or the value of the nearest non-null cell. |
| [r.grow](r.grow.md) | Generates a raster map layer with contiguous areas grown by one cell. |
| [r.gwflow](r.gwflow.md) | Numerical calculation program for transient, confined and unconfined groundwater flow in two dimensions. |
| [r.his](r.his.md) | Generates red, green and blue (RGB) raster map layers combining hue, intensity and saturation (HIS) values from user-specified input raster map layers. |
| [r.horizon](r.horizon.md) | Computes horizon angle height from a digital elevation model. The module has two different modes of operation: 1. Computes the entire horizon around a single point whose coordinates are given with the 'coord' option. The horizon height (in radians). 2. Computes one or more raster maps of the horizon height in a single direction. The input for this is the angle (in degrees), which is measured counterclockwise with east=0, north=90 etc. The output is the horizon height in radians. |
| [r.import](r.import.md) | Imports raster data into a GRASS raster map using GDAL library and reprojects on the fly. |
| [r.in.ascii](r.in.ascii.md) | Converts a GRASS ASCII raster file to binary raster map. |
| [r.in.aster](r.in.aster.md) | Georeference, rectify, and import Terra-ASTER imagery and relative DEMs using gdalwarp. |
| [r.in.bin](r.in.bin.md) | Import a binary raster file into a GRASS raster map layer. |
| [r.in.gdal](r.in.gdal.md) | Imports raster data into a GRASS raster map using GDAL library. |
| [r.in.gridatb](r.in.gridatb.md) | Imports GRIDATB.FOR map file (TOPMODEL) into a GRASS raster map. |
| [r.in.lidar](r.in.lidar.md) | Creates a raster map from LAS LiDAR points using univariate statistics. |
| [r.in.mat](r.in.mat.md) | Imports a binary MAT-File(v4) to a GRASS raster. |
| [r.in.png](r.in.png.md) | Imports non-georeferenced PNG format image. |
| [r.in.poly](r.in.poly.md) | Creates raster maps from ASCII polygon/line/point data files. |
| [r.in.srtm](r.in.srtm.md) | Imports SRTM HGT files into raster map. |
| [r.in.wms](r.in.wms.md) | Downloads and imports data from OGC WMS and OGC WMTS web mapping servers. |
| [r.in.xyz](r.in.xyz.md) | Creates a raster map from an assemblage of many coordinates using univariate statistics. |
| [r.info](r.info.md) | Outputs basic information about a raster map. |
| [r.kappa](r.kappa.md) | Calculates error matrix and kappa parameter for accuracy assessment of classification result. |
| [r.lake](r.lake.md) | Fills lake at given point to given level. |
| [r.latlong](r.latlong.md) | Creates a latitude/longitude raster map. |
| [r.li.cwed](r.li.cwed.md) | Calculates contrast weighted edge density index on a raster map |
| [r.li.daemon](r.li.daemon.md) | Support module for r.li landscape index calculations. |
| [r.li.dominance](r.li.dominance.md) | Calculates dominance's diversity index on a raster map |
| [r.li.edgedensity](r.li.edgedensity.md) | Calculates edge density index on a raster map, using a 4 neighbour algorithm |
| [r.li](r.li.md) | Landscape structure analysis package overview |
| [r.li.mpa](r.li.mpa.md) | Calculates mean pixel attribute index on a raster map |
| [r.li.mps](r.li.mps.md) | Calculates mean patch size index on a raster map, using a 4 neighbour algorithm |
| [r.li.padcv](r.li.padcv.md) | Calculates coefficient of variation of patch area on a raster map |
| [r.li.padrange](r.li.padrange.md) | Calculates range of patch area size on a raster map |
| [r.li.padsd](r.li.padsd.md) | Calculates standard deviation of patch area a raster map |
| [r.li.patchdensity](r.li.patchdensity.md) | Calculates patch density index on a raster map, using a 4 neighbour algorithm |
| [r.li.patchnum](r.li.patchnum.md) | Calculates patch number index on a raster map, using a 4 neighbour algorithm. |
| [r.li.pielou](r.li.pielou.md) | Calculates Pielou's diversity index on a raster map |
| [r.li.renyi](r.li.renyi.md) | Calculates Renyi's diversity index on a raster map |
| [r.li.richness](r.li.richness.md) | Calculates richness index on a raster map |
| [r.li.shannon](r.li.shannon.md) | Calculates Shannon's diversity index on a raster map |
| [r.li.shape](r.li.shape.md) | Calculates shape index on a raster map |
| [r.li.simpson](r.li.simpson.md) | Calculates Simpson's diversity index on a raster map |
| [r.mapcalc](r.mapcalc.md) | Raster map calculator. |
| [r.mapcalc.simple](r.mapcalc.simple.md) | Calculates a new raster map from a simple r.mapcalc expression. |
| [r.mask](r.mask.md) | Creates a raster mask for limiting raster operation. |
| [r.mask.status](r.mask.status.md) | Reports presence or absence of a raster mask Provides information about the presence of a 2D raster mask as text output or return code |
| [r.mfilter](r.mfilter.md) | Performs raster map matrix filter. |
| [r.mode](r.mode.md) | Finds the mode of values in a cover map within areas assigned the same category value in a user-specified base map. |
| [r.neighbors](r.neighbors.md) | Makes each cell category value a function of the category values assigned to the cells around it, and stores new cell values in an output raster map layer. |
| [r.null](r.null.md) | Manages NULL-values of given raster map. |
| [r.object.geometry](r.object.geometry.md) | Calculates geometry parameters for raster objects. |
| [r.out.ascii](r.out.ascii.md) | Converts a raster map layer into a GRASS ASCII text file. |
| [r.out.bin](r.out.bin.md) | Exports a GRASS raster to a binary array. |
| [r.out.gdal](r.out.gdal.md) | Exports GRASS raster maps into GDAL supported formats. |
| [r.out.gridatb](r.out.gridatb.md) | Exports GRASS raster map to GRIDATB.FOR map file (TOPMODEL). |
| [r.out.mat](r.out.mat.md) | Exports a GRASS raster to a binary MAT-File. |
| [r.out.mpeg](r.out.mpeg.md) | Converts raster map series to MPEG movie. |
| [r.out.png](r.out.png.md) | Export a GRASS raster map as a non-georeferenced PNG image. |
| [r.out.pov](r.out.pov.md) | Converts a raster map layer into a height-field file for POV-Ray. |
| [r.out.ppm](r.out.ppm.md) | Converts a GRASS raster map to a PPM image file. |
| [r.out.ppm3](r.out.ppm3.md) | Converts 3 GRASS raster layers (R,G,B) to a PPM image file. |
| [r.out.vrml](r.out.vrml.md) | Exports a raster map to the Virtual Reality Modeling Language (VRML). |
| [r.out.vtk](r.out.vtk.md) | Converts raster maps into the VTK-ASCII format. |
| [r.out.xyz](r.out.xyz.md) | Exports a raster map to a text file as x,y,z values based on cell centers. |
| [r.pack](r.pack.md) | Exports a raster map as GRASS specific archive file |
| [r.param.scale](r.param.scale.md) | Extracts terrain parameters from a DEM. Uses a multi-scale approach by taking fitting quadratic parameters to any size window (via least squares). |
| [r.patch](r.patch.md) | Creates a composite raster map layer by using known category values from one (or more) map layer(s) to fill in areas of "no data" in another map layer. |
| [r.path](r.path.md) | Traces paths from starting points following input directions. |
| [r.plane](r.plane.md) | Creates raster plane map given dip (inclination), aspect (azimuth) and one point. |
| [r.profile](r.profile.md) | Outputs the raster map layer values lying on user-defined line(s). |
| [r.proj](r.proj.md) | Re-projects a raster map from given project to the current project. |
| [r.quant](r.quant.md) | Produces the quantization file for a floating-point map. |
| [r.quantile](r.quantile.md) | Compute quantiles using two passes. |
| [r.random.cells](r.random.cells.md) | Generates random cell values with spatial dependence. |
| [r.random](r.random.md) | Creates randomly placed raster cells or vector points Creates a raster map and vector point map containing randomly located cells and points. |
| [r.random.surface](r.random.surface.md) | Generates random surface(s) with spatial dependence. |
| [r.reclass.area](r.reclass.area.md) | Reclasses a raster map greater or less than user specified area size (in hectares). |
| [r.reclass](r.reclass.md) | Reclassify raster map based on category values. Creates a new raster map whose category values are based upon a reclassification of the categories in an existing raster map. |
| [r.recode](r.recode.md) | Recodes categorical raster maps. |
| [r.region](r.region.md) | Sets the boundary definitions for a raster map. |
| [r.regression.line](r.regression.line.md) | Calculates linear regression from two raster maps: y = a + b*x. |
| [r.regression.multi](r.regression.multi.md) | Calculates multiple linear regression from raster maps. |
| [r.relief](r.relief.md) | Creates shaded relief map from an elevation map (DEM). |
| [r.report](r.report.md) | Reports statistics for raster maps. |
| [r.resamp.bspline](r.resamp.bspline.md) | Performs bilinear or bicubic spline interpolation with Tykhonov regularization. |
| [r.resamp.filter](r.resamp.filter.md) | Resamples raster map layers using an analytic kernel. |
| [r.resamp.interp](r.resamp.interp.md) | Resamples raster map to a finer grid using interpolation. |
| [r.resamp.rst](r.resamp.rst.md) | Reinterpolates and optionally computes topographic analysis from input raster map to a new raster map (possibly with different resolution) using regularized spline with tension and smoothing. |
| [r.resamp.stats](r.resamp.stats.md) | Resamples raster map layers to a coarser grid using aggregation. |
| [r.resample](r.resample.md) | GRASS raster map layer data resampling capability. |
| [r.rescale.eq](r.rescale.eq.md) | Rescales histogram equalized the range of category values in a raster map layer. |
| [r.rescale](r.rescale.md) | Rescales the range of category values in a raster map layer. |
| [r.rgb](r.rgb.md) | Splits a raster map into red, green and blue maps. |
| [r.ros](r.ros.md) | Generates rate of spread raster maps. Generates three, or four raster map layers showing the base (perpendicular) rate of spread (ROS), the maximum (forward) ROS, the direction of the maximum ROS, and optionally the maximum potential spotting distance for fire spread simulation. |
| [r.semantic.label](r.semantic.label.md) | Manages semantic label information assigned to a single raster map or to a list of raster maps. |
| [r.series.accumulate](r.series.accumulate.md) | Makes each output cell value a accumulationfunction of the values assigned to the corresponding cells in the input raster map layers. |
| [r.series.interp](r.series.interp.md) | Interpolates raster maps located (temporal or spatial) in between input raster maps at specific sampling positions. |
| [r.series](r.series.md) | Makes each output cell value a function of the values assigned to the corresponding cells in the input raster map layers. |
| [r.shade](r.shade.md) | Drapes a color raster over an shaded relief or aspect map. |
| [r.sim.sediment](r.sim.sediment.md) | Sediment transport and erosion/deposition simulation using path sampling method (SIMWE). |
| [r.sim.water](r.sim.water.md) | Overland flow hydrologic simulation using path sampling method (SIMWE). |
| [r.slope.aspect](r.slope.aspect.md) | Generates raster maps of slope, aspect, curvatures and partial derivatives from an elevation raster map. Aspect is calculated counterclockwise from east. |
| [r.smooth.edgepreserve](r.smooth.edgepreserve.md) | Smoothing with anisotropic diffusion |
| [r.solute.transport](r.solute.transport.md) | Numerical calculation program for transient, confined and unconfined solute transport in two dimensions |
| [r.spread](r.spread.md) | Simulates elliptically anisotropic spread. Generates a raster map of the cumulative time of spread, given raster maps containing the rates of spread (ROS), the ROS directions and the spread origins. It optionally produces raster maps to contain backlink UTM coordinates for tracing spread paths. Usable for fire spread simulations. |
| [r.spreadpath](r.spreadpath.md) | Recursively traces the least cost path backwards to cells from which the cumulative cost was determined. |
| [r.statistics](r.statistics.md) | Calculates category or object oriented statistics. |
| [r.stats](r.stats.md) | Generates area statistics for raster map. |
| [r.stats.quantile](r.stats.quantile.md) | Compute category quantiles using two passes. |
| [r.stats.zonal](r.stats.zonal.md) | Calculates category or object oriented statistics (accumulator-based statistics). |
| [r.stream.extract](r.stream.extract.md) | Performs stream network extraction. |
| [r.sun](r.sun.md) | Solar irradiance and irradiation model. Computes direct (beam), diffuse and reflected solar irradiation raster maps for given day, latitude, surface and atmospheric conditions. Solar parameters (e.g. sunrise, sunset times, declination, extraterrestrial irradiance, daylight length) are saved in the map history file. Alternatively, a local time can be specified to compute solar incidence angle and/or irradiance raster maps. The shadowing effect of the topography is optionally incorporated. |
| [r.sunhours](r.sunhours.md) | Calculates solar elevation, solar azimuth, and sun hours. Solar elevation: the angle between the direction of the geometric center of the sun's apparent disk and the (idealized) horizon. Solar azimuth: the angle from due north in clockwise direction. |
| [r.sunmask](r.sunmask.md) | Calculates cast shadow areas from sun position and elevation raster map. Either exact sun position (A) is specified, or date/time to calculate the sun position (B) by r.sunmask itself. |
| [r.support](r.support.md) | Allows creation and/or modification of raster map layer support files. |
| [r.support.stats](r.support.stats.md) | Update raster map statistics |
| [r.surf.area](r.surf.area.md) | Prints estimation of surface area for raster map. |
| [r.surf.contour](r.surf.contour.md) | Generates surface raster map from rasterized contours. |
| [r.surf.fractal](r.surf.fractal.md) | Creates a fractal surface of a given fractal dimension. |
| [r.surf.gauss](r.surf.gauss.md) | Generates a raster map using gaussian random number generator. Mean and standard deviation of gaussian deviates can be expressed by the user. |
| [r.surf.idw](r.surf.idw.md) | Provides surface interpolation from raster point data by Inverse Distance Squared Weighting. |
| [r.surf.random](r.surf.random.md) | Produces a raster surface map of uniform random deviates with defined range. |
| [r.terraflow](r.terraflow.md) | Performs flow computation for massive grids. |
| [r.texture](r.texture.md) | Generate images with textural features from a raster map. |
| [r.thin](r.thin.md) | Thins non-null cells that denote linear features in a raster map layer. |
| [r.tile](r.tile.md) | Splits a raster map into tiles. |
| [r.tileset](r.tileset.md) | Produces tilings of the source projection for use in the destination region and projection. |
| [r.timestamp](r.timestamp.md) | Modifies a timestamp for a raster map. Print/add/remove a timestamp for a raster map. |
| [r.to.rast3](r.to.rast3.md) | Converts 2D raster map slices to one 3D raster volume map. |
| [r.to.rast3elev](r.to.rast3elev.md) | Creates a 3D volume map based on 2D elevation and value raster maps. |
| [r.to.vect](r.to.vect.md) | Converts a raster map into a vector map. |
| [r.topidx](r.topidx.md) | Creates a topographic index (wetness index) raster map from an elevation raster map. |
| [r.topmodel](r.topmodel.md) | Simulates TOPMODEL which is a physically based hydrologic model. |
| [r.transect](r.transect.md) | Outputs raster map layer values lying along user defined transect line(s). |
| [r.univar](r.univar.md) | Calculates univariate statistics from the non-null cells of a raster map. Statistics include number of cells counted, minimum and maximum cell values, range, arithmetic mean, population variance, standard deviation, coefficient of variation, and sum. |
| [r.unpack](r.unpack.md) | Imports a GRASS specific raster archive file (packed with r.pack) as a raster map |
| [r.uslek](r.uslek.md) | Computes USLE Soil Erodibility Factor (K). |
| [r.usler](r.usler.md) | Computes USLE R factor, Rainfall erosivity index. |
| [r.viewshed](r.viewshed.md) | Computes the viewshed of a point on an elevation raster map. Default format: NULL (invisible), vertical angle wrt viewpoint (visible). |
| [r.volume](r.volume.md) | Calculates the volume of data "clumps". Optionally produces a GRASS vector points map containing the calculated centroids of these clumps. |
| [r.walk](r.walk.md) | Creates a raster map showing the anisotropic cumulative cost of moving between different geographic locations on an input raster map whose cell category values represent cost. |
| [r.water.outlet](r.water.outlet.md) | Creates watershed basins from a drainage direction map. |
| [r.watershed](r.watershed.md) | Calculates hydrological parameters and RUSLE factors. |
| [r.what.color](r.what.color.md) | Queries colors for a raster map layer. |
| [r.what](r.what.md) | Queries raster maps on their category values and category labels. |

### 3D raster tools (r3.)

| Name | Description |
|--------|-------------|
| [r3.colors](r3.colors.md) | Creates/modifies the color table associated with a 3D raster map. |
| [r3.colors.out](r3.colors.out.md) | Exports the color table associated with a 3D raster map. |
| [r3.cross.rast](r3.cross.rast.md) | Creates cross section 2D raster map from 3D raster map based on 2D elevation map |
| [r3.flow](r3.flow.md) | Computes 3D flow lines and 3D flow accumulation. |
| [r3.gradient](r3.gradient.md) | Computes gradient of a 3D raster map and outputs gradient components as three 3D raster maps. |
| [r3.gwflow](r3.gwflow.md) | Numerical calculation program for transient, confined groundwater flow in three dimensions. |
| [r3.in.ascii](r3.in.ascii.md) | Converts a 3D ASCII raster text file into a (binary) 3D raster map. |
| [r3.in.bin](r3.in.bin.md) | Imports a binary raster file into a GRASS 3D raster map. |
| [r3.in.lidar](r3.in.lidar.md) | Creates a 3D raster map from LAS LiDAR points using univariate statistics. |
| [r3.in.v5d](r3.in.v5d.md) | Import 3-dimensional Vis5D files. |
| [r3.in.xyz](r3.in.xyz.md) | Create a 3D raster map from an assemblage of many coordinates using univariate statistics |
| [r3.info](r3.info.md) | Outputs basic information about a user-specified 3D raster map layer. |
| [r3.mapcalc](r3.mapcalc.md) | Raster map calculator. |
| [r3.mask](r3.mask.md) | Establishes the current working 3D raster mask. |
| [r3.mkdspf](r3.mkdspf.md) | Creates a display file from an existing 3D raster map according to specified threshold levels. |
| [r3.neighbors](r3.neighbors.md) | Makes each voxel value a function of the values assigned to the voxels around it, and stores new voxel values in an output 3D raster map |
| [r3.null](r3.null.md) | Explicitly create the 3D NULL-value bitmap file. |
| [r3.out.ascii](r3.out.ascii.md) | Converts a 3D raster map layer into a ASCII text file. |
| [r3.out.bin](r3.out.bin.md) | Exports a GRASS 3D raster map to a binary array. |
| [r3.out.netcdf](r3.out.netcdf.md) | Export a 3D raster map as netCDF file. |
| [r3.out.v5d](r3.out.v5d.md) | Exports GRASS 3D raster map to 3-dimensional Vis5D file. |
| [r3.out.vtk](r3.out.vtk.md) | Converts 3D raster maps into the VTK-ASCII format. |
| [r3.retile](r3.retile.md) | Retiles an existing 3D raster map with user defined x, y and z tile size. |
| [r3.stats](r3.stats.md) | Generates volume statistics for 3D raster maps. |
| [r3.support](r3.support.md) | Allows creation and/or modification of 3D raster map layer support files. |
| [r3.timestamp](r3.timestamp.md) | Modifies a timestamp for a 3D raster map. Print/add/remove a timestamp for a 3D raster map. |
| [r3.to.rast](r3.to.rast.md) | Converts 3D raster maps to 2D raster maps |
| [r3.univar](r3.univar.md) | Calculates univariate statistics from the non-null cells of a 3D raster map. Statistics include number of cells counted, minimum and maximum cell values, range, arithmetic mean, population variance, standard deviation, coefficient of variation, and sum. |

### Temporal tools (t.)

| Name | Description |
|--------|-------------|
| [t.connect](t.connect.md) | Prints/sets general temporal GIS database connection for current mapset. |
| [t.copy](t.copy.md) | Creates a copy of a space time raster dataset. |
| [t.create](t.create.md) | Creates a space time dataset. |
| [t.info](t.info.md) | Lists information about space time datasets and maps. |
| [t.list](t.list.md) | Lists space time datasets and maps registered in the temporal database. |
| [t.merge](t.merge.md) | Merges several space time datasets into a single space time dataset. |
| [t.rast.accdetect](t.rast.accdetect.md) | Detects accumulation patterns in temporally accumulated space time raster datasets created by t.rast.accumulate. |
| [t.rast.accumulate](t.rast.accumulate.md) | Computes cyclic accumulations of a space time raster dataset. |
| [t.rast.aggregate.ds](t.rast.aggregate.ds.md) | Aggregates data of an existing space time raster dataset using the time intervals of a second space time dataset. |
| [t.rast.aggregate](t.rast.aggregate.md) | Aggregates temporally the maps of a space time raster dataset by a user defined granularity. |
| [t.rast.algebra](t.rast.algebra.md) | Apply temporal and spatial operations on space time raster datasets using temporal raster algebra. |
| [t.rast.colors](t.rast.colors.md) | Creates/modifies the color table associated with each raster map of the space time raster dataset. |
| [t.rast.contour](t.rast.contour.md) | Produces a space time vector dataset of specified contours from a space time raster dataset. |
| [t.rast.export](t.rast.export.md) | Exports space time raster dataset. |
| [t.rast.extract](t.rast.extract.md) | Extracts a subset of a space time raster datasets. |
| [t.rast.gapfill](t.rast.gapfill.md) | Replaces gaps in a space time raster dataset with interpolated raster maps. |
| [t.rast.import](t.rast.import.md) | Imports space time raster dataset. |
| [t.rast.list](t.rast.list.md) | Lists registered maps of a space time raster dataset. |
| [t.rast.mapcalc](t.rast.mapcalc.md) | Performs spatio-temporal mapcalc expressions on temporally sampled maps of space time raster datasets. |
| [t.rast.neighbors](t.rast.neighbors.md) | Performs a neighborhood analysis for each map in a space time raster dataset. |
| [t.rast.out.vtk](t.rast.out.vtk.md) | Exports space time raster dataset as VTK time series. |
| [t.rast.series](t.rast.series.md) | Performs different aggregation algorithms from r.series on all or a subset of raster maps in a space time raster dataset. |
| [t.rast.to.rast3](t.rast.to.rast3.md) | Converts a space time raster dataset into a 3D raster map. |
| [t.rast.to.vect](t.rast.to.vect.md) | Converts a space time raster dataset into a space time vector dataset |
| [t.rast.univar](t.rast.univar.md) | Calculates univariate statistics from the non-null cells for each registered raster map of a space time raster dataset. |
| [t.rast.what](t.rast.what.md) | Sample a space time raster dataset at specific vector point coordinates and write the output to stdout using different layouts |
| [t.rast3d.algebra](t.rast3d.algebra.md) | Apply temporal and spatial operations on space time 3D raster datasets using temporal 3D raster algebra. |
| [t.rast3d.extract](t.rast3d.extract.md) | Extracts a subset of a space time 3D raster dataset. |
| [t.rast3d.list](t.rast3d.list.md) | Lists registered maps of a space time raster3d dataset. |
| [t.rast3d.mapcalc](t.rast3d.mapcalc.md) | Performs r3.mapcalc expressions on maps of sampled space time 3D raster datasets. |
| [t.rast3d.univar](t.rast3d.univar.md) | Calculates univariate statistics from the non-null cells for each registered 3D raster map of a space time 3D raster dataset. |
| [t.register](t.register.md) | Assigns timestamps and registers raster, vector and raster3d maps in a space time dataset. |
| [t.remove](t.remove.md) | Removes space time datasets from temporal database. |
| [t.rename](t.rename.md) | Renames a space time dataset |
| [t.sample](t.sample.md) | Samples the input space time dataset(s) with a sample space time dataset and print the result to stdout. |
| [t.select](t.select.md) | Select maps from space time datasets by topological relationships to other space time datasets using temporal algebra. |
| [t.shift](t.shift.md) | Shifts temporally the maps of a space time dataset. |
| [t.snap](t.snap.md) | Snaps temporally the maps of a space time dataset. |
| [t.support](t.support.md) | Modifies the metadata of a space time dataset. |
| [t.topology](t.topology.md) | Lists temporal topology of a space time dataset. |
| [t.unregister](t.unregister.md) | Unregisters raster, vector and raster3d maps from the temporal database or a specific space time dataset. |
| [t.upgrade](t.upgrade.md) | Upgrades the version of the temporal database. |
| [t.vect.algebra](t.vect.algebra.md) | Apply temporal and spatial operations on space time vector datasets using temporal vector algebra. |
| [t.vect.db.select](t.vect.db.select.md) | Prints attributes of vector maps registered in a space time vector dataset. |
| [t.vect.export](t.vect.export.md) | Exports a space time vector dataset as GRASS specific archive file. |
| [t.vect.extract](t.vect.extract.md) | Extracts a subset of a space time vector dataset. |
| [t.vect.import](t.vect.import.md) | Imports a space time vector dataset from a GRASS specific archive file. |
| [t.vect.list](t.vect.list.md) | Lists registered maps of a space time vector dataset. |
| [t.vect.observe.strds](t.vect.observe.strds.md) | Observes specific locations in a space time raster dataset over a period of time using vector points. |
| [t.vect.univar](t.vect.univar.md) | Calculates univariate statistics of attributes for each registered vector map of a space time vector dataset |
| [t.vect.what.strds](t.vect.what.strds.md) | Stores raster map values at spatial and temporal positions of vector points as vector attributes. |

### Vector tools (v.)

| Name | Description |
|--------|-------------|
| [v.buffer](v.buffer.md) | Creates a buffer around vector features of given type. |
| [v.build.all](v.build.all.md) | Rebuilds topology on all vector maps in the current mapset. |
| [v.build](v.build.md) | Creates topology for vector map. Optionally also checks for topological errors. |
| [v.build.polylines](v.build.polylines.md) | Builds polylines from lines or boundaries. |
| [v.category](v.category.md) | Attaches, deletes or reports vector categories to/from/of map geometry. |
| [v.centroids](v.centroids.md) | Adds missing centroids to closed boundaries. |
| [v.class](v.class.md) | Classifies attribute data, e.g. for thematic mapping |
| [v.clean](v.clean.md) | Toolset for cleaning topology of vector map. |
| [v.clip](v.clip.md) | Extracts features of input map which overlay features of clip map. |
| [v.cluster](v.cluster.md) | Performs cluster identification. |
| [v.colors](v.colors.md) | Creates/modifies the color table associated with a vector map. |
| [v.colors.out](v.colors.out.md) | Exports the color table associated with a vector map. |
| [v.db.addcolumn](v.db.addcolumn.md) | Adds one or more columns to the attribute table connected to a given vector map. |
| [v.db.addtable](v.db.addtable.md) | Creates and connects a new attribute table to a given layer of an existing vector map. |
| [v.db.connect](v.db.connect.md) | Prints/sets DB connection for a vector map to attribute table. |
| [v.db.dropcolumn](v.db.dropcolumn.md) | Drops a column from the attribute table connected to a given vector map. |
| [v.db.droprow](v.db.droprow.md) | Removes a vector feature from a vector map through attribute selection. |
| [v.db.droptable](v.db.droptable.md) | Removes existing attribute table of a vector map. |
| [v.db.join](v.db.join.md) | Joins a database table to a vector map table. |
| [v.db.reconnect.all](v.db.reconnect.all.md) | Reconnects attribute tables for all vector maps from the current mapset to a new database. |
| [v.db.renamecolumn](v.db.renamecolumn.md) | Renames a column in the attribute table connected to a given vector map. |
| [v.db.select](v.db.select.md) | Prints vector map attributes. |
| [v.db.univar](v.db.univar.md) | Calculates univariate statistics on selected table column for a GRASS vector map. |
| [v.db.update](v.db.update.md) | Updates a column in the attribute table connected to a vector map. |
| [v.decimate](v.decimate.md) | Decimates a point cloud Copies points from one vector to another while applying different decimations |
| [v.delaunay](v.delaunay.md) | Creates a Delaunay triangulation from an input vector map containing points or centroids. |
| [v.dissolve](v.dissolve.md) | Dissolves adjacent or overlapping features sharing a common category number or attribute. |
| [v.distance](v.distance.md) | Finds the nearest element in vector map 'to' for elements in vector map 'from'. |
| [v.drape](v.drape.md) | Converts 2D vector features to 3D by sampling of elevation raster map. |
| [v.edit](v.edit.md) | Edits a vector map, allows adding, deleting and modifying selected vector features. |
| [v.external](v.external.md) | Creates a new pseudo-vector map as a link to an OGR-supported layer or a PostGIS feature table. |
| [v.external.out](v.external.out.md) | Defines vector output format. |
| [v.extract](v.extract.md) | Selects vector features from an existing vector map and creates a new vector map containing only the selected features. |
| [v.extrude](v.extrude.md) | Extrudes flat vector features to 3D vector features with defined height. Optionally the height can be derived from sampling of elevation raster map. |
| [v.fill.holes](v.fill.holes.md) | Fill holes in areas by keeping only outer boundaries |
| [v.generalize](v.generalize.md) | Performs vector based generalization. |
| [v.hull](v.hull.md) | Produces a 2D/3D convex hull for a given vector map. |
| [v.import](v.import.md) | Imports vector data into a GRASS vector map using OGR library and reprojects on the fly. |
| [v.in.ascii](v.in.ascii.md) | Creates a vector map from an ASCII points file or ASCII vector file. |
| [v.in.db](v.in.db.md) | Creates new vector (points) map from database table containing coordinates. |
| [v.in.dxf](v.in.dxf.md) | Converts file in DXF format to GRASS vector map. |
| [v.in.e00](v.in.e00.md) | Imports E00 file into a vector map. |
| [v.in.geonames](v.in.geonames.md) | Imports geonames.org country files into a vector points map. |
| [v.in.lidar](v.in.lidar.md) | Converts LAS LiDAR point clouds to a GRASS vector map with libLAS. |
| [v.in.lines](v.in.lines.md) | Imports ASCII x,y[,z] coordinates as a series of lines. |
| [v.in.mapgen](v.in.mapgen.md) | Imports Mapgen or Matlab-ASCII vector maps into GRASS. |
| [v.in.ogr](v.in.ogr.md) | Imports vector data into a GRASS vector map using OGR library. |
| [v.in.region](v.in.region.md) | Creates a vector polygon from the current region extent. |
| [v.in.wfs](v.in.wfs.md) | Imports GetFeature from a WFS server. |
| [v.info](v.info.md) | Outputs basic information about a vector map. |
| [v.kcv](v.kcv.md) | Randomly partition points into test/train sets. |
| [v.kernel](v.kernel.md) | Generates a raster density map from vector points map. Density is computed using a moving kernel. Optionally generates a vector density map on a vector network. |
| [v.label](v.label.md) | Creates paint labels for a vector map from attached attributes. |
| [v.label.sa](v.label.sa.md) | Create optimally placed labels for vector map(s) |
| [v.lidar.correction](v.lidar.correction.md) | Corrects the v.lidar.growing output. It is the last of the three algorithms for LIDAR filtering. |
| [v.lidar.edgedetection](v.lidar.edgedetection.md) | Detects the object's edges from a LIDAR data set. |
| [v.lidar.growing](v.lidar.growing.md) | Building contour determination and Region Growing algorithm for determining the building inside |
| [v.lrs.create](v.lrs.create.md) | Creates a linear reference system. |
| [v.lrs.label](v.lrs.label.md) | Creates stationing from input lines, and linear reference system. |
| [v.lrs.segment](v.lrs.segment.md) | Creates points/segments from input lines, linear reference system and positions read from stdin or a file. |
| [v.lrs.where](v.lrs.where.md) | Finds line id and real km+offset for given points in vector map using linear reference system. |
| [v.mkgrid](v.mkgrid.md) | Creates a vector map of a user-defined grid. |
| [v.neighbors](v.neighbors.md) | Neighborhood analysis tool for vector point maps. Makes each cell value a function of the attribute values assigned to the vector points or centroids in a radius around it, and stores new cell values in an output raster map. |
| [v.net.alloc](v.net.alloc.md) | Allocates subnets for nearest centers. Center node must be opened (costs >= 0). Costs of center node are used in calculation. |
| [v.net.allpairs](v.net.allpairs.md) | Computes the shortest path between all pairs of nodes in the network. |
| [v.net.bridge](v.net.bridge.md) | Computes bridges and articulation points in the network. |
| [v.net.centrality](v.net.centrality.md) | Computes degree, centrality, betweeness, closeness and eigenvector centrality measures in the network. |
| [v.net.components](v.net.components.md) | Computes strongly and weakly connected components in the network. |
| [v.net.connectivity](v.net.connectivity.md) | Computes vertex connectivity between two sets of nodes in the network. |
| [v.net.distance](v.net.distance.md) | Computes shortest distance via the network between the given sets of features. Finds the shortest paths from each 'from' point to the nearest 'to' feature and various information about this relation are uploaded to the attribute table. |
| [v.net.flow](v.net.flow.md) | Computes the maximum flow between two sets of nodes in the network. |
| [v.net.iso](v.net.iso.md) | Splits subnets for nearest centers by cost isolines. Splits net to bands between cost isolines (direction from center). Center node must be opened (costs >= 0). Costs of center node are used in calculation. |
| [v.net](v.net.md) | Performs network maintenance. |
| [v.net.path](v.net.path.md) | Finds shortest path on vector network. |
| [v.net.salesman](v.net.salesman.md) | Creates a cycle connecting given nodes (Traveling salesman problem). Note that TSP is NP-hard, heuristic algorithm is used by this module and created cycle may be sub optimal |
| [v.net.spanningtree](v.net.spanningtree.md) | Computes minimum spanning tree for the network. |
| [v.net.steiner](v.net.steiner.md) | Creates Steiner tree for the network and given terminals. Note that 'Minimum Steiner Tree' problem is NP-hard and heuristic algorithm is used in this module so the result may be sub optimal. |
| [v.net.timetable](v.net.timetable.md) | Finds shortest path using timetables. |
| [v.net.visibility](v.net.visibility.md) | Performs visibility graph construction. |
| [v.normal](v.normal.md) | Tests for normality for vector points. |
| [v.out.ascii](v.out.ascii.md) | Exports a vector map to a GRASS ASCII vector representation. By default only features with category are exported. To export all features use 'layer=-1'. |
| [v.out.dxf](v.out.dxf.md) | Exports vector map to DXF file format. |
| [v.out.lidar](v.out.lidar.md) | Exports vector points as LAS point cloud Converts LAS LiDAR point clouds to a GRASS vector map with libLAS |
| [v.out.ogr](v.out.ogr.md) | Exports a vector map layer to any of the supported OGR vector formats. By default a vector map layer is exported to OGC GeoPackage format. |
| [v.out.pov](v.out.pov.md) | Converts GRASS x,y,z points to POV-Ray x,z,y format. |
| [v.out.svg](v.out.svg.md) | Exports a vector map to SVG file. |
| [v.out.vtk](v.out.vtk.md) | Converts a vector map to VTK ASCII output. |
| [v.outlier](v.outlier.md) | Removes outliers from vector point data. |
| [v.overlay](v.overlay.md) | Overlays two vector maps offering clip, intersection, difference, symmetrical difference, union operators. |
| [v.pack](v.pack.md) | Exports a vector map as GRASS specific archive file |
| [v.parallel](v.parallel.md) | Creates parallel line to input vector lines. |
| [v.patch](v.patch.md) | Creates a new vector map by combining other vector maps. |
| [v.perturb](v.perturb.md) | Random location perturbations of vector points. |
| [v.profile](v.profile.md) | Vector map profiling tool |
| [v.proj](v.proj.md) | Re-projects a vector map from one project to the current project. |
| [v.qcount](v.qcount.md) | Indices for quadrat counts of vector point lists. |
| [v.random](v.random.md) | Generates random 2D/3D vector points. |
| [v.rast.stats](v.rast.stats.md) | Calculates univariate statistics from a raster map based on a vector map and uploads statistics to new attribute columns. |
| [v.reclass](v.reclass.md) | Changes vector category values for an existing vector map according to results of SQL queries or a value in attribute table column. |
| [v.rectify](v.rectify.md) | Rectifies a vector by computing a coordinate transformation for each object in the vector based on the control points. |
| [v.report](v.report.md) | Reports geometry statistics for vector maps. |
| [v.sample](v.sample.md) | Samples a raster map at vector point locations. |
| [v.segment](v.segment.md) | Creates points/segments from input vector lines and positions. |
| [v.select](v.select.md) | Selects features from vector map (A) by features from other vector map (B). |
| [v.split](v.split.md) | Splits vector lines to shorter segments. |
| [v.support](v.support.md) | Updates vector map metadata. |
| [v.surf.bspline](v.surf.bspline.md) | Performs bicubic or bilinear spline interpolation with Tykhonov regularization. |
| [v.surf.idw](v.surf.idw.md) | Provides surface interpolation from vector point data by Inverse Distance Squared Weighting. |
| [v.surf.rst](v.surf.rst.md) | Performs surface interpolation from vector points map by splines. Spatial approximation and topographic analysis from given point or isoline data in vector format to floating point raster format using regularized spline with tension. |
| [v.timestamp](v.timestamp.md) | Modifies a timestamp for a vector map. Print/add/remove a timestamp for a vector map. |
| [v.to.3d](v.to.3d.md) | Performs transformation of 2D vector features to 3D. |
| [v.to.db](v.to.db.md) | Populates attribute values from vector features. |
| [v.to.lines](v.to.lines.md) | Converts vector polygons or points to lines. |
| [v.to.points](v.to.points.md) | Creates points along input lines in new vector map with 2 layers. |
| [v.to.rast](v.to.rast.md) | Converts (rasterize) a vector map into a raster map. |
| [v.to.rast3](v.to.rast3.md) | Converts a vector map (only points) into a 3D raster map. |
| [v.transform](v.transform.md) | Performs an affine transformation (shift, scale and rotate) on vector map. |
| [v.type](v.type.md) | Changes type of vector features. |
| [v.univar](v.univar.md) | Calculates univariate statistics of vector map features. Variance and standard deviation is calculated only for points if specified. |
| [v.unpack](v.unpack.md) | Imports a GRASS specific vector archive file (packed with v.pack) as a vector map |
| [v.vect.stats](v.vect.stats.md) | Count points in areas, calculate statistics from point attributes. |
| [v.vol.rst](v.vol.rst.md) | Interpolates point data to a 3D raster map using regularized spline with tension (RST) algorithm. |
| [v.voronoi](v.voronoi.md) | Creates a Voronoi diagram constrained to the extents of the current region from an input vector map containing points or centroids. |
| [v.what](v.what.md) | Queries a vector map at given locations. |
| [v.what.rast](v.what.rast.md) | Uploads raster values at positions of vector points to the table. |
| [v.what.rast3](v.what.rast3.md) | Uploads 3D raster values at positions of vector points to the table. |
| [v.what.strds](v.what.strds.md) | Uploads space time raster dataset values at positions of vector points to the table. |
| [v.what.vect](v.what.vect.md) | Uploads vector values at positions of vector points to the table. |
