---
name: g.compare.md5.py
description: Checks if two GRASS GIS maps are identical.
keywords: [ general, map management, list ]
---

# g.compare.md5.py

Checks if two GRASS GIS maps are identical.

=== "Command line"

    **g.compare.md5.py**
    [**-gct**]
    **ainput**=*name*
    **binput**=*string*
    **type**=*datatype* [,*datatype*,...]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.compare.md5.py ainput=name binput=string type=raster
    ```

=== "Python (grass.script)"

    *grass.script.parse_command*("***g.compare.md5.py***",
        **ainput**,
        **binput**,
        **type**=*"raster"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.parse_command("g.compare.md5.py", ainput="name", binput="string", type="raster")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_compare_md5_py*(**ainput**,
        **binput**,
        **type**=*"raster"*,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_compare_md5_py(ainput="name", binput="string", type="raster")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **ainput**=*name* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of first map to check  
    **binput**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of second map to check  
    **type**=*datatype* [,*datatype*,...] **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, vector*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *raster*  
    **-g**  
    &nbsp;&nbsp;&nbsp;&nbsp;Return output in shell script style (0 fail, 1 success)  
    **-c**  
    &nbsp;&nbsp;&nbsp;&nbsp;Does not consider the color table for raster  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Does not consider the topology for vector  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **ainput** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of first map to check  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **binput** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of second map to check  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file  
    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datatype*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, vector*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *raster*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *c*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return output in shell script style (0 fail, 1 success)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Does not consider the color table for raster  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Does not consider the topology for vector  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **ainput** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of first map to check  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file, *name*  
    **binput** : str | io.StringIO, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Name of second map to check  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, file  
    **type** : str | list[str], *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Data type(s)  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: *datatype*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *raster, vector*  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *raster*  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *g*, *c*, *t*  
    &nbsp;&nbsp;&nbsp;&nbsp;**g**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Return output in shell script style (0 fail, 1 success)  
    &nbsp;&nbsp;&nbsp;&nbsp;**c**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Does not consider the color table for raster  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Does not consider the topology for vector  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.compare.md5* is a module that checks if two GRASS maps are identical.
It uses the MD5 cryptographic hash function. For vector map layers it
does not check if the attribute table(s) are identical, too.

## EXAMPLE

North Carolina example, with elevation map:

```sh
# copy a raster map
g.copy raster=elevation,dem

# now check and return TRUE
g.compare.md5 ainput=elevation binput=dem

# now change the color table
r.colors map=dem color=srtm

# check again and it should return FALSE
g.compare.md5 ainput=elevation binput=dem

# but when adding the -c flag (ignore color table), TRUE is returned
g.compare.md5 -c ainput=elevation binput=dem
```

## AUTHOR

Luca Delucchi, Fondazione Edmund Mach, Research and Innovation Centre,
Department of Biodiversity and Molecular Ecology, [GIS and Remote
Sensing
Unit](https://web.archive.org/web/20151217025426/https://gis.cri.fmach.it/),
Italy

## SOURCE CODE

Available at: [g.compare.md5 source code](https://github.com/OSGeo/grass-addons/tree/grass8/src/general/g.compare.md5)
([history](https://github.com/OSGeo/grass-addons/commits/grass8/src/general/g.compare.md5))  
Latest change: Thursday Feb 20 13:02:26 2025 in commit [53de819](https://github.com/OSGeo/grass-addons/commit/53de8196a10ba5a8a9121898ce87861d227137e3)
