---
name: g.manual.py
description: Displays the manual pages of GRASS modules.
keywords: [ general, manual, help ]
---

# g.manual.py

Displays the manual pages of GRASS modules.

=== "Command line"

    **g.manual.py**
    [**-itmo**]
    **entry**=*string*
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.manual.py entry=string
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.manual.py***",
        **entry**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.manual.py", entry="string")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_manual_py*(**entry**,
        **flags**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_manual_py(entry="string")
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **entry**=*string* **[required]**  
    &nbsp;&nbsp;&nbsp;&nbsp;Manual entry to be displayed  
    **-i**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display index  
    **-t**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display topics  
    **-m**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display as MAN text page instead of HTML page in browser  
    **-o**  
    &nbsp;&nbsp;&nbsp;&nbsp;Display online manuals instead of locally installed  
    &nbsp;&nbsp;&nbsp;&nbsp;Use online manuals available at https://grass.osgeo.org website. This flag has no effect when displaying MAN text pages.  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **entry** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Manual entry to be displayed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *t*, *m*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display index  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display topics  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display as MAN text page instead of HTML page in browser  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display online manuals instead of locally installed  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use online manuals available at https://grass.osgeo.org website. This flag has no effect when displaying MAN text pages.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **entry** : str, *required*  
    &nbsp;&nbsp;&nbsp;&nbsp;Manual entry to be displayed  
    **flags** : str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allowed values: *i*, *t*, *m*, *o*  
    &nbsp;&nbsp;&nbsp;&nbsp;**i**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display index  
    &nbsp;&nbsp;&nbsp;&nbsp;**t**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display topics  
    &nbsp;&nbsp;&nbsp;&nbsp;**m**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display as MAN text page instead of HTML page in browser  
    &nbsp;&nbsp;&nbsp;&nbsp;**o**  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Display online manuals instead of locally installed  
    &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Use online manuals available at https://grass.osgeo.org website. This flag has no effect when displaying MAN text pages.  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.manual* displays the manual pages of GRASS in HTML and MAN format.

## NOTES

The name of the browser is defined in the environment variable
`GRASS_HTML_BROWSER`. For most platforms this should be an executable in
your PATH, or the full path to an executable. See
[variables](variables.md) for details.

## EXAMPLES

Show index page in the browser.

```sh
g.manual -i
```

Show manual page of *[d.vect](d.vect.md)* module in the browser.

```sh
g.manual d.vect
```

Show module manual page in terminal.

```sh
g.manual -m d.vect
```

## AUTHOR

Markus Neteler

## SOURCE CODE

Available at: [g.manual source code](https://github.com/OSGeo/grass/tree/main/scripts/g.manual)
([history](https://github.com/OSGeo/grass/commits/main/scripts/g.manual))  
Latest change: Tuesday Oct 21 09:57:14 2025 in commit [fb0165c](https://github.com/OSGeo/grass/commit/fb0165c2d021b7700528aca09c224847be871729)
