---
name: g.rename
description: Renames data base element files in the user's current mapset.
keywords: [ general, map management, rename ]
---

# g.rename

Renames data base element files in the user's current mapset.

=== "Command line"

    **g.rename**
    [**raster**=*from,to*]
    [**raster_3d**=*from,to*]
    [**vector**=*from,to*]
    [**label**=*from,to*]
    [**region**=*from,to*]
    [**group**=*from,to*]
    [**--overwrite**]
    [**--verbose**]
    [**--quiet**]
    [**--qq**]
    [**--ui**]

    Example:

    ```sh
    g.rename
    ```

=== "Python (grass.script)"

    *grass.script.run_command*("***g.rename***",
        **raster**=*None*,
        **raster_3d**=*None*,
        **vector**=*None*,
        **label**=*None*,
        **region**=*None*,
        **group**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    gs.run_command("g.rename")
    ```

=== "Python (grass.tools)"

    *grass.tools.Tools.g_rename*(**raster**=*None*,
        **raster_3d**=*None*,
        **vector**=*None*,
        **label**=*None*,
        **region**=*None*,
        **group**=*None*,
        **overwrite**=*None*,
        **verbose**=*None*,
        **quiet**=*None*,
        **superquiet**=*None*)

    Example:

    ```python
    tools = Tools()
    tools.g_rename()
    ```

    This grass.tools API is experimental in version 8.5 and expected to be stable in version 8.6.

## Parameters

=== "Command line"

    **raster**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;raster map(s) to be renamed  
    **raster_3d**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map(s) to be renamed  
    **vector**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;vector map(s) to be renamed  
    **label**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;paint label file(s) to be renamed  
    **region**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;region definition(s) to be renamed  
    **group**=*from,to*  
    &nbsp;&nbsp;&nbsp;&nbsp;imagery group(s) to be renamed  
    **--overwrite**  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    **--help**  
    &nbsp;&nbsp;&nbsp;&nbsp;Print usage summary  
    **--verbose**  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    **--quiet**  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    **--qq**  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    **--ui**  
    &nbsp;&nbsp;&nbsp;&nbsp;Force launching GUI dialog

=== "Python (grass.script)"

    **raster** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;raster map(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *from,to*  
    **raster_3d** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3D raster, *from,to*  
    **vector** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;vector map(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *from,to*  
    **label** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;paint label file(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, label, *from,to*  
    **region** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;region definition(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region definition, *from,to*  
    **group** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;imagery group(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, imagery group, *from,to*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

=== "Python (grass.tools)"

    **raster** : tuple[str | np.ndarray, str | np.ndarray] | list[str | np.ndarray] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;raster map(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, raster, *from,to*  
    **raster_3d** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;3D raster map(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, 3D raster, *from,to*  
    **vector** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;vector map(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, vector, *from,to*  
    **label** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;paint label file(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, label, *from,to*  
    **region** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;region definition(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, region definition, *from,to*  
    **group** : tuple[str, str] | list[str] | str, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;imagery group(s) to be renamed  
    &nbsp;&nbsp;&nbsp;&nbsp;Used as: input, imagery group, *from,to*  
    **overwrite** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Allow output files to overwrite existing files  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **verbose** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Verbose module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **quiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  
    **superquiet** : bool, *optional*  
    &nbsp;&nbsp;&nbsp;&nbsp;Very quiet module output  
    &nbsp;&nbsp;&nbsp;&nbsp;Default: *None*  

    Returns:

    **result** : grass.tools.support.ToolResult | None  
    If the tool produces text as standard output, a *ToolResult* object will be returned. Otherwise, `None` will be returned.

    Raises:

    *grass.tools.ToolError*: When the tool ended with an error.

## DESCRIPTION

*g.rename* allows the user to rename data base element files in the
user's current mapset. The user can specify all necessary information to
*g.rename* on the command line, by specifying: the type of data base
element to be renamed (one or more of: **raster**, **raster_3d**,
**vector**, **icon**, **labels**, **region**, and **group**); the
specific file element in the current mapset to be renamed (*old*); and
the new name to be assigned to this file element (*new*) in the current
mapset. The file element *old* is then renamed to *new*.

Users can also simply type *g.rename --help* without arguments on the
command line, to receive a menu of existing data base element types and
files from which to choose for possible renaming:

```sh
       raster   raster map(s) to be renamed
    raster_3d   3D raster map(s) to be renamed
       vector   vector map(s) to be renamed
       labels   paint label file(s) to be renamed
       region   region definition(s) to be renamed
        group   imagery group(s) to be renamed
```

## NOTES

If a data base element has support files (e.g., as is commonly the case
with raster maps), these support files also are renamed.

If the user attempts to rename a file to itself by setting the *new*
file name equal to the *old* file name (e.g., **g.rename
raster=soils,soils**), *g.rename* will not execute the rename, but
instead state that no rename is needed. However, *g.rename* will allow
the user to overwrite other existing files in the current mapset by
making the *new* file name that of an already existing file.

For portability reasons, *g.rename* is ignoring case of names. To change
the case of a map name, first rename the map to a name which differs by
more than case, then rename it to the intended name.

## EXAMPLE

```sh
# rename raster map
g.rename raster=oldrast,newrast

# rename vector map
g.rename vector=oldvect,newvect

# combined renaming
g.rename raster=oldrast,newrast vector=oldvect,newvect
```

## SEE ALSO

*[g.copy](g.copy.md), [g.list](g.list.md), [g.remove](g.remove.md)*

## AUTHOR

Michael Shapiro, U.S.Army Construction Engineering Research Laboratory

## SOURCE CODE

Available at: [g.rename source code](https://github.com/OSGeo/grass/tree/main/general/g.rename)
([history](https://github.com/OSGeo/grass/commits/main/general/g.rename))  
Latest change: Thursday May 08 14:35:40 2025 in commit [9528b1e](https://github.com/OSGeo/grass/commit/9528b1e38ba37992c1597a979dc3efbb07b74ec5)
